/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.web.action;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.web.util.RequestUtils;
import org.beangle.security.blueprint.SecurityUtils;
import org.beangle.security.blueprint.User;
import org.beangle.security.blueprint.data.DataPermission;
import org.beangle.security.blueprint.data.Profile;
import org.beangle.security.blueprint.data.ProfileField;
import org.beangle.security.blueprint.data.UserProfile;
import org.beangle.security.blueprint.data.service.DataPermissionService;
import org.beangle.security.blueprint.function.FuncResource;
import org.beangle.security.blueprint.function.service.FuncPermissionService;
import org.beangle.security.blueprint.model.UserBean;
import org.beangle.struts2.action.EntityActionSupport;

public abstract class SecurityActionSupport
extends EntityActionSupport {
    protected FuncPermissionService funcPermissionService;
    protected DataPermissionService dataPermissionService;

    protected FuncResource getResource() {
        String resourceName = SecurityUtils.getResource();
        if (null == resourceName) {
            resourceName = this.funcPermissionService.extractResource(RequestUtils.getServletPath((HttpServletRequest)ServletActionContext.getRequest()));
        }
        return this.funcPermissionService.getResource(resourceName);
    }

    protected boolean isAdmin() {
        return this.funcPermissionService.getUserService().isRoot(this.getUserId());
    }

    protected <T> List<T> getUserPropertyValues(String name) {
        ProfileField field = this.dataPermissionService.getProfileField(name);
        UserBean user = new UserBean(this.getUserId());
        List profiles = this.dataPermissionService.getUserProfiles((User)user);
        Set results = CollectUtils.newHashSet();
        for (UserProfile profile : profiles) {
            Object prop = this.dataPermissionService.getPropertyValue(field, (Profile)profile);
            if (prop instanceof Collection) {
                results.addAll((Collection)prop);
                continue;
            }
            results.add(prop);
        }
        return CollectUtils.newArrayList((Collection)results);
    }

    protected DataPermission getDataPermission(String dataResource) {
        FuncResource resource = this.getResource();
        return this.dataPermissionService.getPermission(this.getUserId(), dataResource, null == resource ? null : resource.getName());
    }

    protected void applyPermission(OqlBuilder<?> query, UserProfile profile) {
        this.dataPermissionService.apply(query, this.getDataPermission(query.getEntityClass().getName()), profile);
    }

    protected Long getUserId() {
        return SecurityUtils.getUserId();
    }

    protected String getUsername() {
        return SecurityUtils.getUsername();
    }

    protected String getUser() {
        return Strings.concat((String[])new String[]{SecurityUtils.getUsername(), "(", SecurityUtils.getFullname(), ")"});
    }

    public void setFuncPermissionService(FuncPermissionService permissionService) {
        this.funcPermissionService = permissionService;
    }

    public void setDataPermissionService(DataPermissionService dataPermissionService) {
        this.dataPermissionService = dataPermissionService;
    }
}

