/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.log;

import java.io.ByteArrayOutputStream;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.beangle.commons.bean.Disposable;
import org.beangle.commons.bean.Initializing;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.web.util.HttpUtils;
import org.beangle.ems.app.EmsApp;
import org.beangle.ems.log.BusinessLogProto;
import org.beangle.security.Securities;
import org.beangle.security.core.session.Session;

public class RemoteLogger
implements Initializing,
Disposable {
    String url;
    int queueSize = 512;
    private BlockingQueue<BusinessLogEvent> queue;
    private boolean started;
    private Worker worker;

    public void destroy() {
        this.worker.interrupt();
    }

    public void init() throws Exception {
        this.queue = new ArrayBlockingQueue<BusinessLogEvent>(this.queueSize);
        this.started = true;
        this.worker = new Worker(this);
        this.worker.setDaemon(true);
        this.worker.setName("Beangle async business logstore worker");
        this.worker.start();
    }

    public BusinessLogEvent newEvent(String summary) {
        BusinessLogEvent entry = new BusinessLogEvent();
        entry.appName = EmsApp.getName();
        entry.operator = Securities.getUsername();
        entry.operateAt = Instant.now();
        entry.level = Level.Info;
        entry.entry = Securities.getResource();
        Session s = Securities.getSession();
        entry.agent = s.getAgent().getOs() + " " + s.getAgent().getName();
        entry.summary = summary;
        return entry;
    }

    public void publish(BusinessLogEvent event) {
        this.queue.offer(event);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    private static class Worker
    extends Thread {
        boolean stopped = false;
        RemoteLogger logger;

        public Worker(RemoteLogger logger) {
            this.logger = logger;
        }

        @Override
        public void run() {
            while (this.logger.started && !this.stopped) {
                try {
                    ArrayList<BusinessLogEvent> elements = new ArrayList<BusinessLogEvent>();
                    BusinessLogEvent e0 = this.logger.queue.take();
                    elements.add(e0);
                    this.logger.queue.drainTo(elements);
                    for (BusinessLogEvent e : elements) {
                        this.publish(this.logger.url, e);
                    }
                }
                catch (InterruptedException e) {
                    this.stopped = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void publish(String url, BusinessLogEvent event) {
            BusinessLogProto.BusinessLogEvent.Builder builder = BusinessLogProto.BusinessLogEvent.newBuilder();
            builder.setOperator(event.operator);
            builder.setOperateAt(event.operateAt.toEpochMilli());
            builder.setSummary(event.summary);
            builder.setDetails(event.details);
            builder.setResources(event.resources);
            builder.setIp(event.ip);
            builder.setAgent(event.agent);
            builder.setEntry(event.entry);
            builder.setLevel(event.level.ordinal() + 1);
            builder.setAppName(event.appName);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                builder.build().writeTo(os);
                URL upload = new URL(url.replace("{level}", Strings.uncapitalize((String)event.level.toString())));
                HttpUtils.invoke((URL)upload, (byte[])os.toByteArray(), (String)"application/x-protobuf");
                System.out.println("log push to " + url.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class BusinessLogEvent {
        String appName;
        String operator;
        Instant operateAt;
        String summary;
        String details;
        String resources;
        String ip;
        String agent;
        String entry;
        Level level;

        public BusinessLogEvent from(String ip) {
            this.ip = ip;
            return this;
        }

        public BusinessLogEvent operateOn(String resources, String details) {
            this.resources = resources;
            this.details = details;
            return this;
        }

        public BusinessLogEvent operateOn(Object resources, Map<String, ?> params) {
            String details;
            this.resources = resources.toString();
            ArrayList<CallSite> paramList = new ArrayList<CallSite>();
            for (Map.Entry<String, ?> entry : params.entrySet()) {
                if (entry.getKey().startsWith("_")) continue;
                String string = ((String)entry.getKey()).contains("password") ? "*****" : entry.getValue().toString();
                paramList.add((CallSite)((Object)((String)entry.getKey() + " = " + string)));
            }
            Collections.sort(paramList);
            StringBuilder sb = new StringBuilder();
            for (String string : paramList) {
                sb.append(string).append("\n");
            }
            this.details = details = Strings.abbreviate((String)sb.toString(), (int)4000);
            return this;
        }
    }

    public static enum Level {
        Info,
        Warn,
        Error;

    }
}

