/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.app.util;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.sql.DataSource;
import org.beangle.commons.bean.PropertyUtils;
import org.beangle.commons.io.IOs;
import org.beangle.commons.io.StringBuilderWriter;
import org.beangle.commons.lang.Charsets;
import org.beangle.ems.app.util.DatasourceConfig;
import org.beangle.ems.app.util.DriverInfo;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class DataSourceUtils {
    private static Map<String, DriverInfo> drivers = new HashMap<String, DriverInfo>();

    public static DataSource build(String driver, String username, String password, Map<String, String> props) {
        return new HikariDataSource(new HikariConfig(DataSourceUtils.buildProperties(driver, username, password, props)));
    }

    private static Properties buildProperties(String driver, String username, String password, Map<String, String> props) {
        Properties properties = new Properties();
        Set writables = PropertyUtils.getWritableProperties(HikariConfig.class);
        for (Map.Entry<String, String> e : props.entrySet()) {
            Object key;
            Object object = key = e.getKey().equals("url") ? "jdbcUrl" : e.getKey();
            if (!writables.contains(key)) {
                key = "dataSource." + (String)key;
            }
            properties.put(key, e.getValue());
        }
        if (driver.equals("oracle") && !properties.containsKey("jdbcUrl") && !props.containsKey("driverType")) {
            properties.put("dataSource.driverType", "thin");
        }
        if (null != username) {
            properties.put("username", username);
        }
        if (null != password) {
            properties.put("password", password);
        }
        if (properties.containsKey("jdbcUrl")) {
            try {
                Class.forName(DataSourceUtils.drivers.get((Object)driver).driverClassName);
            }
            catch (Exception exception) {}
        } else if (!properties.containsKey("dataSourceClassName")) {
            properties.put("dataSourceClassName", DataSourceUtils.drivers.get((Object)driver).dataSourceClassName);
        }
        return properties;
    }

    public static void close(DataSource dataSource) {
        if (dataSource instanceof HikariDataSource) {
            ((HikariDataSource)dataSource).close();
        } else {
            try {
                Method method = dataSource.getClass().getMethod("close", new Class[0]);
                if (null != method) {
                    method.invoke((Object)dataSource, new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static DatasourceConfig parseXml(InputStream is, String dsname) {
        DatasourceConfig conf = null;
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(is);
            List nodes = document.selectNodes("/app/resources/datasource");
            Set<String> predefined = Set.of("user", "password", "driver", "props");
            for (Object o : nodes) {
                Node node;
                String name;
                if (!(o instanceof Node) || !(name = (node = (Node)o).valueOf("@name")).equals(dsname)) continue;
                conf = new DatasourceConfig();
                conf.user = node.selectSingleNode("user").getText();
                conf.password = node.selectSingleNode("password").getText();
                conf.driver = node.selectSingleNode("driver").getText();
                conf.name = name;
                List propNodes = node.selectNodes("props/prop");
                for (Object po : propNodes) {
                    Node pn = (Node)po;
                    conf.props.put(pn.valueOf("@name"), pn.valueOf("@value"));
                }
                List children = node.selectNodes("*");
                for (Object o1 : children) {
                    Node node1 = (Node)o1;
                    if (predefined.contains(node1.getName())) continue;
                    conf.props.put(node1.getName(), node1.getText());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return conf;
    }

    public static DatasourceConfig parseJson(InputStream is) {
        StringBuilderWriter sw = new StringBuilderWriter();
        Charset charset = Charsets.UTF_8;
        String string = null;
        try {
            IOs.copy((Reader)new InputStreamReader(is, charset.name()), (Writer)sw);
            string = sw.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        ScriptEngineManager sem = new ScriptEngineManager();
        ScriptEngine engine = sem.getEngineByName("javascript");
        HashMap<String, String> result = new HashMap<String, String>();
        HashMap data = null;
        try {
            data = (HashMap)engine.eval("result =" + string);
        }
        catch (Exception e) {
            e.printStackTrace();
            data = new HashMap();
        }
        for (Map.Entry one : data.entrySet()) {
            Double d;
            String value = null;
            value = one.getValue() instanceof Double ? (Double.compare(d = (Double)one.getValue(), d.intValue()) > 0 ? d.toString() : String.valueOf(d.intValue())) : one.getValue().toString();
            String key = one.getKey().toString();
            result.put(key, value);
        }
        return new DatasourceConfig(result);
    }

    public static void main(String[] args) {
        ScriptEngineManager sem = new ScriptEngineManager();
        ScriptEngine engine = sem.getEngineByName("javascript");
        System.out.println(engine);
    }

    static {
        drivers.put("postgresql", new DriverInfo("org.postgresql.Driver", "org.postgresql.ds.PGSimpleDataSource"));
        drivers.put("oracle", new DriverInfo("org.postgresql.Driver", "oracle.jdbc.pool.OracleDataSource"));
        drivers.put("jtds", new DriverInfo("net.sourceforge.jtds.jdbc.Driver", "net.sourceforge.jtds.jdbcx.JtdsDataSource"));
    }
}

