/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.config.service;

import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import org.beangle.commons.config.property.PropertyConfig;
import org.beangle.commons.conversion.impl.DefaultConversion;
import org.beangle.commons.dao.EntityDao;
import org.beangle.commons.entity.Entity;
import org.beangle.commons.lang.reflect.Reflections;
import org.beangle.ems.config.model.PropertyConfigItemBean;

public class DaoPropertyConfigProvider
implements PropertyConfig.Provider {
    private EntityDao entityDao;

    public void setEntityDao(EntityDao entityDao) throws ClassNotFoundException {
        this.entityDao = entityDao;
    }

    public Properties getConfig() {
        Properties props = new Properties();
        List rs = this.entityDao.getAll(PropertyConfigItemBean.class);
        for (PropertyConfigItemBean prop : rs) {
            Class<?> itemClass = null;
            try {
                itemClass = Class.forName(prop.getType());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            Object value = prop.getValue();
            if (null != itemClass && Entity.class.isAssignableFrom(itemClass)) {
                Class idType = Reflections.getPropertyType(itemClass, (String)"id");
                value = this.entityDao.get(itemClass.getName(), (Serializable)DefaultConversion.Instance.convert(value, idType));
            }
            props.put(prop.getName(), value);
        }
        return props;
    }
}

