/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.log.service;

import java.util.Date;
import org.beangle.commons.bean.PropertyUtils;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.event.BusinessEvent;
import org.beangle.commons.event.Event;
import org.beangle.commons.event.EventListener;
import org.beangle.commons.lang.Strings;
import org.beangle.ems.log.model.BusinessLogBean;
import org.beangle.ems.log.model.BusinessLogDetailBean;
import org.beangle.security.Securities;
import org.beangle.security.core.Authentication;

public class BusinessEventLogger
extends BaseServiceImpl
implements EventListener<Event> {
    public void onEvent(Event event) {
        Authentication auth = Securities.getAuthentication();
        if (null == auth) {
            return;
        }
        BusinessLogBean log = new BusinessLogBean();
        log.setOperateAt(new Date(event.getTimestamp()));
        log.setOperation((String)Strings.defaultIfBlank((CharSequence)event.getSubject(), (CharSequence)"  "));
        log.setResource((String)Strings.defaultIfBlank((CharSequence)event.getResource(), (CharSequence)"  "));
        log.setOperator(auth.getName());
        Object details = auth.getDetails();
        Object agent = PropertyUtils.getProperty((Object)details, (String)"agent");
        if (null != agent) {
            log.setIp((String)PropertyUtils.getProperty((Object)agent, (String)"ip"));
            log.setAgent(PropertyUtils.getProperty((Object)agent, (String)"os") + " " + PropertyUtils.getProperty((Object)agent, (String)"browser"));
            String lastAccessUri = (String)PropertyUtils.getProperty((Object)agent, (String)"lastAccessUri");
            log.setEntry((String)Strings.defaultIfBlank((CharSequence)lastAccessUri, (CharSequence)"--"));
        }
        if (null != event.getDetail()) {
            log.setDetail(new BusinessLogDetailBean(log, event.getDetail()));
        }
        this.entityDao.saveOrUpdate(new Object[]{log});
    }

    public boolean supportsEventType(Class<? extends Event> eventType) {
        return BusinessEvent.class.isAssignableFrom(eventType);
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }
}

