/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.avatar.service;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.collection.page.Page;
import org.beangle.commons.collection.page.PageLimit;
import org.beangle.commons.collection.page.PagedList;
import org.beangle.commons.collection.page.Pages;
import org.beangle.commons.config.property.PropertyConfig;
import org.beangle.commons.config.property.PropertyConfigEvent;
import org.beangle.commons.config.property.PropertyConfigListener;
import org.beangle.commons.io.Files;
import org.beangle.commons.lang.Strings;
import org.beangle.ems.avatar.Avatar;
import org.beangle.ems.avatar.model.FileAvatar;
import org.beangle.ems.avatar.service.AbstractAvatarBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemAvatarBase
extends AbstractAvatarBase
implements PropertyConfigListener {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemAvatarBase.class);
    private String avatarDir;

    @Override
    public Page<String> getAvatarNames(PageLimit limit) {
        if (null == this.avatarDir) {
            logger.error("avatar dir property not config properly");
            return Pages.emptyPage();
        }
        File file = new File(this.avatarDir);
        if (!file.exists()) {
            return Pages.emptyPage();
        }
        String[] names = file.list();
        List fileNames = CollectUtils.newArrayList();
        for (int i = 0; i < names.length; ++i) {
            String name = Strings.substringBefore((String)names[i], (String)".");
            String ext = Strings.substringAfter((String)names[i], (String)".");
            if (!Strings.isNotBlank((CharSequence)name) || !this.containType(ext)) continue;
            fileNames.add(name);
        }
        Collections.sort(fileNames);
        return new PagedList(fileNames, limit);
    }

    public String getAbsoluteAvatarPath(String name, String type) {
        StringBuilder sb = new StringBuilder(this.avatarDir);
        sb.append(name).append('.').append(type.toLowerCase());
        return sb.toString();
    }

    @Override
    public Avatar getAvatar(String name) {
        if (null == this.avatarDir) {
            return null;
        }
        if (Strings.contains((CharSequence)name, (int)46)) {
            File file = new File(this.avatarDir + name);
            if (file.exists()) {
                return new FileAvatar(file);
            }
        } else {
            for (int i = 0; i < this.typeList.size(); ++i) {
                StringBuilder sb = new StringBuilder(this.avatarDir);
                sb.append(name).append('.').append((String)this.typeList.get(i));
                File file = new File(sb.toString());
                if (!file.exists()) continue;
                return new FileAvatar(file);
            }
        }
        return null;
    }

    public String getAvatarDir() {
        return this.avatarDir;
    }

    public void setAvatarDir(String avatarDir) {
        this.avatarDir = null != avatarDir ? (!avatarDir.endsWith(File.separator) ? avatarDir + File.separator : avatarDir) : null;
    }

    @Override
    public String getDescription() {
        return "\u8def\u5f84:" + this.avatarDir + " <br><em>\u5982\u9700\u6539\u53d8\u8be5\u4f4d\u7f6e,\u8bf7\u914d\u7f6e\u7cfb\u7edf\u53c2\u6570:fileSystemAvatarBase.avatarDir.</em>";
    }

    public void setPropertyConfig(PropertyConfig config) {
        if (null != config) {
            config.addListener((PropertyConfigListener)this);
            this.setAvatarDir((String)config.get(String.class, "fileSystemAvatarBase.avatarDir"));
        }
    }

    public void onConfigEvent(PropertyConfigEvent event) {
        this.setAvatarDir((String)event.getSource().get(String.class, "fileSystemAvatarBase.avatarDir"));
    }

    @Override
    public boolean updateAvatar(String name, File avatar, String type) {
        try {
            Files.copyFile((File)avatar, (File)new File(this.getAbsoluteAvatarPath(name, type)));
        }
        catch (IOException e) {
            logger.error("copy avator error", (Throwable)e);
            return false;
        }
        return true;
    }
}

