/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.script;

import java.util.Map;
import java.util.WeakHashMap;
import ognl.Ognl;
import ognl.OgnlException;
import org.beangle.commons.script.EvaluationException;
import org.beangle.commons.script.ExpressionEvaluator;

public class OgnlExpressionEvaluator
implements ExpressionEvaluator {
    private Map<String, Object> trees = new WeakHashMap<String, Object>();

    public void parse(String exp) throws EvaluationException {
        try {
            Object tree = Ognl.parseExpression((String)exp);
            this.trees.put(exp, tree);
        }
        catch (OgnlException e) {
            throw new EvaluationException((Throwable)e);
        }
    }

    public Object eval(String exp, Object root) {
        try {
            Object tree = this.trees.get(exp);
            if (tree == null) {
                tree = Ognl.parseExpression((String)exp);
                this.trees.put(exp, tree);
            }
            return Ognl.getValue((Object)tree, (Object)root);
        }
        catch (OgnlException e) {
            throw new EvaluationException((Throwable)e);
        }
    }

    public <T> T eval(String exp, Object root, Class<T> resultType) {
        try {
            Object tree = this.trees.get(exp);
            if (tree == null) {
                tree = Ognl.parseExpression((String)exp);
                this.trees.put(exp, tree);
            }
            return (T)Ognl.getValue((Object)tree, (Object)root, resultType);
        }
        catch (OgnlException e) {
            throw new EvaluationException((Throwable)e);
        }
    }
}

