/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.avatar.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Date;
import org.beangle.commons.lang.Strings;
import org.beangle.ems.avatar.AvatarException;
import org.beangle.ems.avatar.model.AbstractAvatar;

public class FileAvatar
extends AbstractAvatar {
    private File file;

    public FileAvatar(File file) {
        this.file = file;
        this.setUpdatedAt(new Date(file.lastModified()));
        this.setName(file.getName());
    }

    public FileAvatar() {
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public String getType() {
        if (super.getType() == null) {
            this.setType(Strings.substringAfterLast((String)this.file.getAbsolutePath(), (String)"."));
        }
        return super.getType();
    }

    @Override
    public InputStream getInputStream() throws AvatarException {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new AvatarException(e);
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }
}

