/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.log.service;

import java.util.Date;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.event.BusinessEvent;
import org.beangle.commons.event.Event;
import org.beangle.commons.event.EventListener;
import org.beangle.commons.lang.Strings;
import org.beangle.ems.log.model.BusinessLogBean;
import org.beangle.ems.log.model.BusinessLogDetailBean;
import org.beangle.security.Securities;
import org.beangle.security.core.context.SecurityContext;
import org.beangle.security.core.session.Session;

public class BusinessEventLogger
extends BaseServiceImpl
implements EventListener<Event> {
    public void onEvent(Event event) {
        Session session = Securities.getSession();
        if (session == null) {
            return;
        }
        BusinessLogBean log = new BusinessLogBean();
        log.setOperateAt(new Date(event.getTimestamp()));
        log.setOperation((String)Strings.defaultIfBlank((CharSequence)event.getSubject(), (CharSequence)"  "));
        log.setResource((String)Strings.defaultIfBlank((CharSequence)event.getResource(), (CharSequence)"  "));
        log.setOperator(session.getPrincipal().getName());
        Session.Agent agent = session.getAgent();
        if (agent != null) {
            log.setIp(agent.getIp());
            log.setAgent(String.valueOf(agent.getOs()) + " " + agent.getName());
            log.setEntry((String)Strings.defaultIfBlank((CharSequence)SecurityContext.get().getRequest().getResource().toString(), (CharSequence)"--"));
        }
        if (event.getDetail() != null) {
            log.setDetail(new BusinessLogDetailBean(log, event.getDetail()));
        }
        this.entityDao.saveOrUpdate(new Object[]{log});
    }

    public boolean supportsEventType(Class<? extends Event> eventType) {
        return BusinessEvent.class.isAssignableFrom(eventType);
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }
}

