/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.rule.engine.impl;

import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.metadata.Model;
import org.beangle.ems.rule.Rule;
import org.beangle.ems.rule.engine.RuleExecutor;
import org.beangle.ems.rule.engine.RuleExecutorBuilder;
import org.beangle.ems.rule.engine.impl.CompositeExecutor;
import org.beangle.ems.rule.model.RuleConfig;
import org.beangle.ems.rule.model.RuleConfigParam;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultRuleExecutorBuilder
implements RuleExecutorBuilder,
ApplicationContextAware {
    ApplicationContext appContext;
    public static final String SPRING = "spring";
    public static final String BEAN = "bean";

    @Override
    public RuleExecutor build(Rule rule) {
        if (SPRING.equals(rule.getFactory())) {
            return (RuleExecutor)this.appContext.getBean(rule.getServiceName());
        }
        if (BEAN.equals(rule.getFactory())) {
            try {
                return (RuleExecutor)Class.forName(rule.getServiceName()).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    @Override
    public RuleExecutor build(List<Rule> rules, boolean stopWhenFail) {
        CompositeExecutor composite = new CompositeExecutor();
        composite.setStopWhenFail(stopWhenFail);
        for (Rule rule : rules) {
            composite.add(this.build(rule));
        }
        return composite;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appContext = applicationContext;
    }

    @Override
    public RuleExecutor build(RuleConfig ruleConfig) {
        RuleExecutor executor = this.build(ruleConfig.getRule());
        if (executor == null) {
            return null;
        }
        Map map = CollectUtils.newHashMap();
        for (RuleConfigParam configParam : ruleConfig.getParams()) {
            map.put(configParam.getParam().getName(), configParam.getValue());
        }
        Model.populate((Object)executor, (Map)map);
        return executor;
    }
}

