/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.avatar.service;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Strings;
import org.beangle.ems.avatar.Avatar;
import org.beangle.ems.avatar.service.AvatarBase;
import org.beangle.ems.util.ZipUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAvatarBase
implements AvatarBase {
    private final Logger logger = LoggerFactory.getLogger(AbstractAvatarBase.class);
    protected Set<String> types = CollectUtils.newHashSet();
    protected List<String> typeList = new ArrayList<String>();
    protected boolean readOnly = false;
    protected static final String DEFAULT_AVATAR = "default.jpg";

    public AbstractAvatarBase() {
        for (String name : new String[]{"jpg", "JPG", "jpeg", "png", "gif", "GIF"}) {
            this.types.add(name);
            this.typeList.add(name);
        }
    }

    @Override
    public boolean containType(String type) {
        return this.types.contains(type);
    }

    @Override
    public Set<String> getTypes() {
        return this.types;
    }

    public void setTypes(Set<String> types) {
        this.types = types;
    }

    @Override
    public Avatar getDefaultAvatar() {
        return this.getAvatar(DEFAULT_AVATAR);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public int updateAvatarBatch(File zipFile) {
        String tmpPath = System.getProperty("java.io.tmpdir") + "/avatar/";
        this.logger.debug("unzip avatar to {}", (Object)tmpPath);
        ZipUtils.unzip(zipFile, tmpPath);
        File tmpAvatar = new File(tmpPath);
        int count = this.updateFile(tmpAvatar);
        this.logger.debug("removing avatar tmp path {}", (Object)tmpPath);
        tmpAvatar.delete();
        return count;
    }

    private int updateFile(File path) {
        int count = 0;
        if (path.isDirectory()) {
            String[] fileNames;
            for (String fileName : fileNames = path.list()) {
                File file = new File(path.getAbsolutePath() + "/" + fileName);
                if (file.isDirectory()) {
                    count += this.updateFile(file);
                    file.delete();
                    continue;
                }
                String type = Strings.substringAfter((String)fileName, (String)".");
                boolean passed = this.containType(type);
                if (passed) {
                    this.logger.debug("updating avatar by {}", (Object)file.getName());
                    this.updateAvatar(Strings.substringBefore((String)fileName, (String)"."), file, type);
                    ++count;
                }
                file.delete();
            }
        }
        return count;
    }

    @Override
    public abstract boolean updateAvatar(String var1, File var2, String var3);
}

