/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.rule.engine.impl;

import java.util.List;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.ems.rule.Context;
import org.beangle.ems.rule.engine.RuleExecutor;

public class CompositeExecutor
implements RuleExecutor {
    private List<RuleExecutor> executors = CollectUtils.newArrayList();
    private boolean stopWhenFail = false;

    @Override
    public boolean execute(Context context) {
        boolean result = true;
        for (RuleExecutor executor : this.executors) {
            if (!this.stopWhenFail || (result &= executor.execute(context))) continue;
            return result;
        }
        return result;
    }

    public void add(RuleExecutor executor) {
        this.executors.add(executor);
    }

    public List<RuleExecutor> getExecutors() {
        return this.executors;
    }

    public void setExecutors(List<RuleExecutor> executors) {
        this.executors = executors;
    }

    public boolean isStopWhenFail() {
        return this.stopWhenFail;
    }

    public void setStopWhenFail(boolean stopWhenFailure) {
        this.stopWhenFail = stopWhenFailure;
    }
}

