/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.io.IOs;
import org.beangle.commons.lang.Strings;

public final class ZipUtils {
    private ZipUtils() {
    }

    public static File zip(List<String> fileNames, String zipPath) {
        return ZipUtils.zip(fileNames, zipPath, null);
    }

    public static File zip(List<String> fileNames, String zipPath, String encoding) {
        try {
            FileOutputStream f = new FileOutputStream(zipPath);
            ZipArchiveOutputStream zos = (ZipArchiveOutputStream)new ArchiveStreamFactory().createArchiveOutputStream("zip", (OutputStream)f);
            if (null != encoding) {
                zos.setEncoding(encoding);
            }
            for (int i = 0; i < fileNames.size(); ++i) {
                String fileName = fileNames.get(i);
                String entryName = Strings.substringAfterLast((String)fileName, (String)File.separator);
                ZipArchiveEntry entry = new ZipArchiveEntry(entryName);
                zos.putArchiveEntry((ArchiveEntry)entry);
                FileInputStream fis = new FileInputStream(fileName);
                IOs.copy((InputStream)fis, (OutputStream)zos);
                fis.close();
                zos.closeArchiveEntry();
            }
            zos.close();
            return new File(zipPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> unzip(File zipFile, String destination) {
        return ZipUtils.unzip(zipFile, destination, null);
    }

    public static List<String> unzip(File zipFile, String destination, String encoding) {
        List fileNames = CollectUtils.newArrayList();
        Object dest = destination;
        if (!destination.endsWith(File.separator)) {
            dest = destination + File.separator;
        }
        try {
            ZipFile file = null;
            file = null == encoding ? new ZipFile(zipFile) : new ZipFile(zipFile, encoding);
            Enumeration en = file.getEntries();
            ZipArchiveEntry ze = null;
            while (en.hasMoreElements()) {
                ze = (ZipArchiveEntry)en.nextElement();
                File f = new File((String)dest, ze.getName());
                if (ze.isDirectory()) {
                    f.mkdirs();
                    continue;
                }
                f.getParentFile().mkdirs();
                InputStream is = file.getInputStream(ze);
                FileOutputStream os = new FileOutputStream(f);
                IOs.copy((InputStream)is, (OutputStream)os);
                is.close();
                ((OutputStream)os).close();
                fileNames.add(f.getAbsolutePath());
            }
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fileNames;
    }

    public static boolean isZipFile(File zipFile) {
        try {
            ZipFile zf = new ZipFile(zipFile);
            boolean isZip = zf.getEntries().hasMoreElements();
            zf.close();
            return isZip;
        }
        catch (IOException e) {
            return false;
        }
    }
}

