/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.core.security.service;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.beangle.commons.event.Event;
import org.beangle.commons.event.EventListener;
import org.beangle.data.dao.EntityDao;
import org.beangle.ems.core.config.service.DomainService;
import org.beangle.ems.core.security.model.SessionEvent;
import org.beangle.security.authc.Account;
import org.beangle.security.session.EventType$;
import org.beangle.security.session.LogoutEvent;
import org.beangle.security.session.Session;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public class LogoutEventTracker
implements EventListener<LogoutEvent> {
    private EntityDao entityDao;
    private DomainService domainService;
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public DomainService domainService() {
        return this.domainService;
    }

    public void domainService_$eq(DomainService x$1) {
        this.domainService = x$1;
    }

    public void onEvent(LogoutEvent event) {
        SessionEvent logout = new SessionEvent();
        logout.eventType_$eq(EventType$.Logout);
        logout.updatedAt_$eq(Instant.now());
        Session session = event.session();
        logout.principal_$eq(session.principal().getName());
        logout.username_$eq(((Account)session.principal()).description());
        String logoutType = session.ttiSeconds() == 0 ? "\u5f3a\u5236\u9000\u51fa" : (session.expired() ? "\u8fc7\u671f" : "\u9000\u51fa");
        logout.name_$eq(logout.principal() + " " + logout.username() + " " + logoutType);
        logout.ip_$eq(session.agent().ip());
        String details = session.agent().name() + " " + session.agent().os() + " \u6700\u540e\u8bbf\u95ee" + this.formatter.format(session.lastAccessAt().atZone(ZoneId.systemDefault())) + " " + (String)(event.reason() != null ? event.reason() + "\u9000\u51fa" : "");
        logout.detail_$eq(details);
        logout.domain_$eq(this.domainService().getDomain());
        this.entityDao().saveOrUpdate((Object)logout, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SessionEvent[0]));
    }

    public boolean supportsEventType(Class<? extends Event> eventType) {
        return LogoutEvent.class.isAssignableFrom(eventType);
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }
}

