/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.core.user.service.impl;

import java.io.Serializable;
import java.time.ZonedDateTime;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.NumId;
import org.beangle.data.model.pojo.Hierarchical;
import org.beangle.data.model.util.Hierarchicals$;
import org.beangle.ems.app.EmsApp$;
import org.beangle.ems.core.config.service.DomainService;
import org.beangle.ems.core.security.model.FuncPermission;
import org.beangle.ems.core.user.model.MemberShip$;
import org.beangle.ems.core.user.model.Role;
import org.beangle.ems.core.user.model.RoleMember;
import org.beangle.ems.core.user.model.Root;
import org.beangle.ems.core.user.model.User;
import org.beangle.ems.core.user.service.RoleService;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class RoleServiceImpl
implements RoleService {
    private EntityDao entityDao;
    private DomainService domainService;

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public DomainService domainService() {
        return this.domainService;
    }

    public void domainService_$eq(DomainService x$1) {
        this.domainService = x$1;
    }

    @Override
    public boolean isManagedBy(User manager, Role role) {
        if (manager.roles().exists((Function1 & Serializable)rm -> {
            if (!rm.manager()) return false;
            Role role = rm.role();
            Role role2 = role;
            if (role != null) {
                if (!role.equals(role2)) return false;
                return true;
            }
            if (role2 == null) return true;
            return false;
        })) {
            return true;
        }
        OqlBuilder rq = OqlBuilder$.MODULE$.from(Root.class, "r");
        rq.where("r.user=:user and r.app.name=:appName", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{manager, EmsApp$.MODULE$.name()}));
        rq.where("r.app.domain=:domain", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.domainService().getDomain()}));
        return this.entityDao().search((QueryBuilder)rq).nonEmpty();
    }

    @Override
    public void create(User creator, Role role) {
        role.creator_$eq(creator);
        role.updatedAt_$eq(ZonedDateTime.now().toInstant());
        RoleMember rm = new RoleMember(creator, role, MemberShip$.Manager);
        rm.granter_$eq(true);
        this.entityDao().saveOrUpdate((Object)role, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new NumId[]{rm}));
    }

    @Override
    public void move(Role role, Role parent, int indexno) {
        Iterable iterable;
        role.parent().foreach((Function1)(JProcedure1 & Serializable)p -> {
            block3: {
                block2: {
                    if (parent == null) break block2;
                    Role role = p;
                    Role role2 = parent;
                    if (!(role == null ? role2 != null : !role.equals(role2))) break block3;
                }
                role.parent_$eq((Option)None$.MODULE$);
                this.entityDao().saveOrUpdate((Object)role, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Role[0]));
                this.entityDao().refresh(p);
                return;
            }
        });
        if (parent != null) {
            iterable = Hierarchicals$.MODULE$.move((Hierarchical)role, (Hierarchical)parent, indexno);
        } else {
            OqlBuilder builder = (OqlBuilder)OqlBuilder$.MODULE$.from(Role.class, "r").where("r.parent is null", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])).orderBy("r.indexno");
            iterable = Hierarchicals$.MODULE$.move((Hierarchical)role, this.entityDao().search((QueryBuilder)builder).toBuffer(), indexno);
        }
        Iterable nodes = iterable;
        this.entityDao().saveOrUpdate(nodes);
    }

    @Override
    public void remove(User manager, Seq<Role> roles) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(FuncPermission.class, "fp");
        query.where("fp.role in(:roles)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{roles}));
        Seq fps = this.entityDao().search((QueryBuilder)query);
        this.entityDao().remove((Iterable)roles.toList().$colon$colon((Object)fps));
    }

    @Override
    public Role get(int id) {
        return (Role)this.entityDao().get(Role.class, (Object)BoxesRunTime.boxToInteger((int)id));
    }
}

