/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.core.user.service.impl;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import org.beangle.commons.bean.Initializing;
import org.beangle.commons.collection.Collections$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.pojo.Named;
import org.beangle.ems.core.config.model.Domain;
import org.beangle.ems.core.config.service.DomainService;
import org.beangle.ems.core.user.model.Category;
import org.beangle.ems.core.user.model.MemberShip;
import org.beangle.ems.core.user.model.MemberShip$;
import org.beangle.ems.core.user.model.PasswordConfig;
import org.beangle.ems.core.user.model.Role;
import org.beangle.ems.core.user.model.RoleMember;
import org.beangle.ems.core.user.model.Root;
import org.beangle.ems.core.user.model.User;
import org.beangle.ems.core.user.service.PasswordConfigService;
import org.beangle.ems.core.user.service.UserService;
import org.beangle.security.authc.CredentialAge;
import org.beangle.security.authc.CredentialAge$;
import org.beangle.security.authc.DefaultAccount;
import org.beangle.security.authc.Profile;
import org.beangle.security.authc.Profile$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class UserServiceImpl
implements UserService,
Initializing {
    private final EntityDao entityDao;
    private DomainService domainService;
    private PasswordConfigService passwordConfigService;
    private PasswordConfig config;

    public UserServiceImpl(EntityDao entityDao) {
        this.entityDao = entityDao;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public DomainService domainService() {
        return this.domainService;
    }

    public void domainService_$eq(DomainService x$1) {
        this.domainService = x$1;
    }

    public PasswordConfigService passwordConfigService() {
        return this.passwordConfigService;
    }

    public void passwordConfigService_$eq(PasswordConfigService x$1) {
        this.passwordConfigService = x$1;
    }

    public void init() {
        this.config = this.passwordConfigService().get();
    }

    @Override
    public Option<User> get(String code) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(User.class, "u");
        query.where("u.org=:org", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.domainService().getOrg()}));
        query.where("u.code=:code", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{code}));
        return this.entityDao().search((QueryBuilder)query).headOption();
    }

    @Override
    public Option<User> getIgnoreCase(String code) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(User.class, "u");
        query.where("u.org=:org", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.domainService().getOrg()}));
        query.where("lower(u.code)=:code", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{code.toLowerCase()}));
        return this.entityDao().search((QueryBuilder)query).headOption();
    }

    @Override
    public User get(long id) {
        return (User)this.entityDao().get(User.class, (Object)BoxesRunTime.boxToLong((long)id));
    }

    @Override
    public Seq<RoleMember> getRoles(User user, MemberShip ship) {
        Domain domain = this.domainService().getDomain();
        MemberShip memberShip = ship;
        MemberShip memberShip2 = MemberShip$.Manager;
        MemberShip memberShip3 = memberShip;
        if (!(memberShip2 != null ? !memberShip2.equals(memberShip3) : memberShip3 != null)) {
            return (Buffer)user.roles().filter((Function1 & Serializable)m -> {
                if (!m.manager()) return false;
                Domain domain = m.role().domain();
                Domain domain2 = domain;
                if (domain != null) {
                    if (!domain.equals(domain2)) return false;
                    return true;
                }
                if (domain2 == null) return true;
                return false;
            });
        }
        MemberShip memberShip4 = MemberShip$.Granter;
        MemberShip memberShip5 = memberShip;
        if (!(memberShip4 != null ? !memberShip4.equals(memberShip5) : memberShip5 != null)) {
            return (Buffer)user.roles().filter((Function1 & Serializable)m -> {
                if (!m.granter()) return false;
                Domain domain = m.role().domain();
                Domain domain2 = domain;
                if (domain != null) {
                    if (!domain.equals(domain2)) return false;
                    return true;
                }
                if (domain2 == null) return true;
                return false;
            });
        }
        MemberShip memberShip6 = MemberShip$.Member;
        MemberShip memberShip7 = memberShip;
        if (!(memberShip6 != null ? !memberShip6.equals(memberShip7) : memberShip7 != null)) {
            return (Buffer)user.roles().filter((Function1 & Serializable)m -> {
                if (!m.member()) return false;
                Domain domain = m.role().domain();
                Domain domain2 = domain;
                if (domain != null) {
                    if (!domain.equals(domain2)) return false;
                    return true;
                }
                if (domain2 == null) return true;
                return false;
            });
        }
        throw new MatchError((Object)memberShip);
    }

    @Override
    public boolean isManagedBy(User manager, User user) {
        return true;
    }

    @Override
    public boolean isRoot(User user, String appName) {
        OqlBuilder rootQuery = OqlBuilder$.MODULE$.from(Root.class, "r");
        rootQuery.where("r.user=:user and r.app.name=:appName", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{user, appName}));
        rootQuery.where("r.app.domain=:domain", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.domainService().getDomain()}));
        return this.entityDao().search((QueryBuilder)rootQuery).nonEmpty();
    }

    @Override
    public void create(User creator, User user) {
        user.updatedAt_$eq(Instant.now());
        user.org_$eq(this.domainService().getOrg());
        PasswordConfig config = this.passwordConfigService().get();
        int maxdays = config.mindays() > 10000 ? 10000 : config.maxdays();
        user.passwdExpiredOn_$eq(LocalDate.ofInstant(user.updatedAt(), ZoneId.systemDefault()).plusDays(Int$.MODULE$.int2long(maxdays)));
        this.entityDao().saveOrUpdate((Object)user, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new User[0]));
    }

    @Override
    public void remove(User manager, User user) {
        if (this.isManagedBy(manager, user)) {
            Buffer removed = Collections$.MODULE$.newBuffer();
            removed.$plus$plus$eq((IterableOnce)this.entityDao().findBy(org.beangle.ems.core.user.model.Profile.class, "user", package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new User[]{user}))));
            this.entityDao().remove((Object)removed, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{user}));
            return;
        }
    }

    @Override
    public scala.collection.immutable.Seq<Category> getCategories() {
        OqlBuilder query = OqlBuilder$.MODULE$.from(Category.class, "uc");
        OqlBuilder oqlBuilder = (OqlBuilder)query.where("uc.org=:org", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.domainService().getOrg()}));
        oqlBuilder.cacheable(oqlBuilder.cacheable$default$1());
        return this.entityDao().search((QueryBuilder)query);
    }

    @Override
    public Option<DefaultAccount> getAccount(String code) {
        Domain domain = this.domainService().getDomain();
        Option<User> option = this.get(code);
        if (option instanceof Some) {
            User user = (User)((Some)option).value();
            DefaultAccount account = new DefaultAccount(user.code(), user.name());
            account.accountExpired_$eq(user.accountExpired());
            account.accountLocked_$eq(user.locked());
            account.credentialExpired_$eq(user.passwdInactive(this.config.idledays()));
            account.disabled_$eq(!user.enabled());
            account.categoryId_$eq(BoxesRunTime.unboxToInt((Object)user.category().id()));
            scala.collection.immutable.Seq<Role> rs = this.getRoles(user, domain);
            account.authorities_$eq((String[])((IterableOnceOps)rs.map((Function1 & Serializable)_$4 -> _$4.id().toString())).toArray(ClassTag$.MODULE$.apply(String.class)));
            OqlBuilder upQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(org.beangle.ems.core.user.model.Profile.class, "up").where("up.user=:user", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{user})).where("up.domain=:domain", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{domain}));
            scala.collection.immutable.Seq ups = this.entityDao().search((QueryBuilder)upQuery);
            if (ups.nonEmpty()) {
                account.profiles_$eq(new Profile[ups.size()]);
                IntRef i = IntRef.create((int)0);
                ups.foreach((Function1)(JProcedure1 & Serializable)up -> {
                    int n;
                    account$1.profiles()[i$1.elem] = Profile$.MODULE$.apply(BoxesRunTime.unboxToLong((Object)up.id()), up.name(), up.properties().map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)((Named)x._1()).name(), x._2())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                    i$1.elem = n = i$1.elem + 1;
                });
            }
            return Some$.MODULE$.apply((Object)account);
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    private scala.collection.immutable.Seq<Role> getRoles(User user, Domain domain) {
        Buffer roles = (Buffer)((IterableOps)user.roles().filter((Function1 & Serializable)m -> {
            if (!m.member()) return false;
            Domain domain = m.role().domain();
            Domain domain2 = domain;
            if (domain != null) {
                if (!domain.equals(domain2)) return false;
                return true;
            }
            if (domain2 == null) return true;
            return false;
        })).map((Function1 & Serializable)m -> m.role());
        user.group().foreach((Function1 & Serializable)g -> (Buffer)roles.addAll((IterableOnce)g.roles().filter((Function1 & Serializable)r -> {
            Domain domain = r.domain();
            Domain domain2 = domain;
            return !(domain != null ? !domain.equals(domain2) : domain2 != null);
        })));
        user.groups().foreach((Function1 & Serializable)gm -> (Buffer)roles.addAll((IterableOnce)gm.group().roles().filter((Function1 & Serializable)r -> {
            Domain domain = r.domain();
            Domain domain2 = domain;
            return !(domain != null ? !domain.equals(domain2) : domain2 != null);
        })));
        return roles.toSet().toSeq();
    }

    @Override
    public int enable(User manager, Iterable<Object> userIds, boolean enabled) {
        scala.collection.immutable.Seq users = this.entityDao().find(User.class, userIds);
        scala.collection.immutable.Seq updated = (scala.collection.immutable.Seq)users.filter((Function1 & Serializable)a -> this.isManagedBy(manager, (User)a));
        updated.foreach((Function1)(JProcedure1 & Serializable)u -> u.enabled_$eq(enabled));
        this.entityDao().saveOrUpdate((Iterable)updated);
        return updated.size();
    }

    @Override
    public Option<String> getActivePassword(String code) {
        OqlBuilder builder = OqlBuilder$.MODULE$.from(User.class.getName(), "u");
        builder.where("u.code=:code", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{code}));
        builder.where("u.org=:org", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.domainService().getOrg()}));
        builder.where("u.passwdExpiredOn >= :now", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now().minusDays(Int$.MODULE$.int2long(this.config.idledays()))}));
        builder.select("u.password");
        return this.entityDao().search((QueryBuilder)builder).headOption();
    }

    @Override
    public Option<CredentialAge> getPasswordAge(String code) {
        return this.get(code).map((Function1 & Serializable)u -> CredentialAge$.MODULE$.apply(u.updatedAt(), u.passwdExpiredOn(), u.passwdExpiredOn().plusDays(Int$.MODULE$.int2long(this.config.idledays()))));
    }

    @Override
    public void updatePassword(String code, String rawPassword) {
        this.get(code).foreach((Function1)(JProcedure1 & Serializable)u -> {
            PasswordConfig config = this.passwordConfigService().get();
            u.password_$eq(rawPassword);
            u.updatedAt_$eq(Instant.now());
            int maxdays = config.mindays() > 10000 ? 10000 : config.maxdays();
            u.passwdExpiredOn_$eq(LocalDate.ofInstant(u.updatedAt(), ZoneId.systemDefault()).plusDays(Int$.MODULE$.int2long(maxdays)));
            this.entityDao().saveOrUpdate(u, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new User[0]));
        });
    }
}

