/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.core.oa.service.impl;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import org.beangle.commons.json.Json$;
import org.beangle.commons.json.JsonObject;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.script.ExpressionEvaluator;
import org.beangle.commons.script.ExpressionEvaluator$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.LongId;
import org.beangle.ems.app.oa.Flows;
import org.beangle.ems.core.config.service.DomainService;
import org.beangle.ems.core.oa.model.Flow;
import org.beangle.ems.core.oa.model.FlowActiveProcess;
import org.beangle.ems.core.oa.model.FlowActiveTask;
import org.beangle.ems.core.oa.model.FlowActivity;
import org.beangle.ems.core.oa.model.FlowProcess;
import org.beangle.ems.core.oa.model.FlowStatus;
import org.beangle.ems.core.oa.model.FlowStatus$;
import org.beangle.ems.core.oa.model.FlowTask;
import org.beangle.ems.core.oa.service.FlowService;
import org.beangle.ems.core.oa.service.MessageService;
import org.beangle.ems.core.oa.service.TodoService;
import org.beangle.ems.core.oa.service.impl.FlowServiceImpl$;
import org.beangle.ems.core.user.model.User;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class FlowServiceImpl
implements FlowService {
    private DomainService domainService;
    private EntityDao entityDao;
    private TodoService todoService;
    private MessageService messageService;

    public static String resolveVar(JsonObject jsonObject, String string) {
        return FlowServiceImpl$.MODULE$.resolveVar(jsonObject, string);
    }

    public DomainService domainService() {
        return this.domainService;
    }

    public void domainService_$eq(DomainService x$1) {
        this.domainService = x$1;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public TodoService todoService() {
        return this.todoService;
    }

    public void todoService_$eq(TodoService x$1) {
        this.todoService = x$1;
    }

    public MessageService messageService() {
        return this.messageService;
    }

    public void messageService_$eq(MessageService x$1) {
        this.messageService = x$1;
    }

    @Override
    public Seq<Flow> getFlows(String businessCode, String profileId) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(Flow.class, "flow");
        query.where("flow.domain=:domain", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.domainService().getDomain()}));
        query.where("flow.business.code=:businessCode", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{businessCode}));
        query.where("flow.profileId=:profileId", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{profileId}));
        query.cacheable(query.cacheable$default$1());
        return this.entityDao().search((QueryBuilder)query);
    }

    @Override
    public Flow getFlow(String code) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(Flow.class, "flow");
        query.where("flow.domain=:domain", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.domainService().getDomain()}));
        query.where("flow.code=:flowCode", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{code}));
        query.cacheable(query.cacheable$default$1());
        return (Flow)((Object)this.entityDao().search((QueryBuilder)query).head());
    }

    @Override
    public FlowProcess start(Flow flow, String businessKey, JsonObject env) {
        if (flow.checkMatch(env)) {
            FlowActiveProcess ap = new FlowActiveProcess(flow, businessKey);
            this.entityDao().saveOrUpdate((Object)ap, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FlowActiveProcess[0]));
            FlowProcess p = new FlowProcess(ap, env);
            this.entityDao().saveOrUpdate((Object)p, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FlowProcess[0]));
            FlowActiveTask at = this.startTask(ap, p, flow.firstActivity());
            return p;
        }
        return null;
    }

    @Override
    public FlowProcess complete(FlowActiveTask activeTask, Flows.Payload payload) {
        FlowTask task = (FlowTask)this.entityDao().get(FlowTask.class, activeTask.id());
        FlowProcess process = task.process();
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"code");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)payload.assignee().code());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"org");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.domainService().getOrg());
        User assignee = (User)this.entityDao().findBy(User.class, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).head();
        task.complete(assignee, payload);
        this.entityDao().saveOrUpdate((Object)task, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LongId[]{process}));
        activeTask.complete(assignee);
        activeTask.process().tasks().subtractOne((Object)activeTask);
        this.entityDao().remove((Object)activeTask, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FlowActiveTask[0]));
        this.todoService().complete(assignee, process.flow().business(), process.businessKey());
        if (payload.data().getBoolean("passed", true)) {
            Option<FlowActivity> nextActivities = this.findNext(task);
            nextActivities.foreach((Function1 & Serializable)next -> this.startTask(activeTask.process(), process, (FlowActivity)((Object)next)));
            if (nextActivities.isEmpty()) {
                process.status_$eq(FlowStatus$.Completed);
                process.endAt_$eq((Option<Instant>)Some$.MODULE$.apply((Object)Instant.now()));
                this.entityDao().remove((Object)activeTask.process(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FlowActiveProcess[0]));
            } else {
                process.status_$eq(FlowStatus$.Running);
            }
        } else {
            this.startTask(activeTask.process(), process, process.flow().firstActivity());
            process.status_$eq(FlowStatus$.Rejected);
        }
        this.entityDao().saveOrUpdate((Object)process, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FlowProcess[0]));
        FlowStatus flowStatus = process.status();
        FlowStatus flowStatus2 = FlowStatus$.Completed;
        if (!(flowStatus != null ? !flowStatus.equals(flowStatus2) : flowStatus2 != null)) {
            this.messageService().newMessage((User)process.initiator().get(), process.flow(), process);
        }
        return process;
    }

    @Override
    public void cancel(FlowActiveProcess process) {
        FlowProcess p = (FlowProcess)this.entityDao().get(FlowProcess.class, process.id());
        p.endAt_$eq((Option<Instant>)Some$.MODULE$.apply((Object)Instant.now()));
        p.status_$eq(FlowStatus$.Canceled);
        p.tasks().foreach((Function1)(JProcedure1 & Serializable)t -> {
            if (t.endAt().isEmpty()) {
                t.endAt_$eq((Option<Instant>)Some$.MODULE$.apply((Object)Instant.now()));
                t.status_$eq(FlowStatus$.Canceled);
                return;
            }
        });
        this.entityDao().saveOrUpdate((Object)p, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FlowProcess[0]));
        this.entityDao().remove((Object)process, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FlowActiveProcess[0]));
    }

    @Override
    public void remove(FlowProcess process) {
        FlowActiveProcess ap = (FlowActiveProcess)this.entityDao().get(FlowActiveProcess.class, process.id());
        this.entityDao().remove((Object)ap, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LongId[]{process}));
    }

    private Option<FlowActivity> findNext(FlowTask task) {
        Buffer activities = (Buffer)task.process().flow().activities().sortBy((Function1 & Serializable)_$5 -> _$5.idx(), (Ordering)Ordering.Int$.MODULE$);
        return activities.find((Function1 & Serializable)a -> a.idx() > task.idx() && this.matchable((FlowActivity)((Object)a), task.process()));
    }

    private boolean matchable(FlowActivity activity, FlowProcess process) {
        Option<String> option = activity.guard();
        if (None$.MODULE$.equals(option)) {
            return true;
        }
        if (option instanceof Some) {
            String g = (String)((Some)option).value();
            ExpressionEvaluator ee = ExpressionEvaluator$.MODULE$.get("jexl3");
            return BoxesRunTime.unboxToBoolean((Object)ee.eval(g, (Object)Json$.MODULE$.parseObject(process.envJson()), Boolean.TYPE));
        }
        throw new MatchError(option);
    }

    private FlowActiveTask startTask(FlowActiveProcess ap, FlowProcess p, FlowActivity activity) {
        FlowActiveTask at = new FlowActiveTask(ap, activity);
        JsonObject env = Json$.MODULE$.parseObject(p.envJson());
        activity.assignees().foreach((Function1)(JProcedure1 & Serializable)assignee -> {
            String userCode = FlowServiceImpl$.MODULE$.resolveVar(env, (String)assignee);
            if (Strings$.MODULE$.isNotEmpty((CharSequence)userCode)) {
                Object[] objectArray = new Tuple2[2];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"code");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Strings$.MODULE$.split(userCode));
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"org");
                objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.domainService().getOrg());
                at.assignees().addAll((IterableOnce)this.entityDao().findBy(User.class, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
                return;
            }
        });
        if (activity.assignees().isEmpty() && activity.groups().nonEmpty()) {
            OqlBuilder q = OqlBuilder$.MODULE$.from(User.class, "u");
            q.where("exists(from u.groups as ug where ug.group in(:groups)) or u.group in (:groups)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{activity.groups()}));
            activity.depart().foreach((Function1)(JProcedure1 & Serializable)departExpr -> {
                Option depart = Option$.MODULE$.apply((Object)FlowServiceImpl$.MODULE$.resolveVar(env, (String)departExpr));
                depart.foreach((Function1 & Serializable)dcode -> (OqlBuilder)q.where("u.depart.code=:dcode", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{dcode})));
            });
            q.where("u.org=:org", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.domainService().getOrg()}));
            q.where("u.enabled = true", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            q.where("u.endOn is null or u.endOn>:today", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
            q.select("distinct u");
            q.limit(1, 50);
            Seq users = this.entityDao().search((QueryBuilder)q);
            at.assignees().addAll((IterableOnce)users);
        }
        this.entityDao().saveOrUpdate((Object)at, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FlowActiveTask[0]));
        FlowTask task = p.newTask(at);
        if (p.initiator().isEmpty() && p.tasks().size() == 1 && at.assignees().size() == 1) {
            p.initiator_$eq((Option<User>)at.assignees().headOption());
        }
        this.entityDao().saveOrUpdate((Object)p, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FlowProcess[0]));
        at.assignees().foreach((Function1)(JProcedure1 & Serializable)u -> {
            if (p.initiator().nonEmpty() && !p.initiator().contains(u)) {
                this.todoService().newTodo((User)u, task, at.process().flow(), p);
                return;
            }
        });
        return at;
    }

    @Override
    public void back(FlowActiveProcess ap, FlowActivity activity) {
        FlowProcess process = (FlowProcess)this.entityDao().get(FlowProcess.class, ap.id());
        Buffer afters = (Buffer)process.tasks().filter((Function1 & Serializable)_$6 -> _$6.idx() >= activity.idx());
        process.tasks().subtractAll((IterableOnce)afters);
        this.entityDao().saveOrUpdate((Object)process, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FlowProcess[0]));
        Buffer afters2 = (Buffer)ap.tasks().filter((Function1 & Serializable)_$7 -> _$7.idx() >= activity.idx());
        ap.tasks().subtractAll((IterableOnce)afters2);
        this.entityDao().saveOrUpdate((Object)ap, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FlowActiveProcess[0]));
        this.startTask(ap, process, activity);
    }
}

