/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.core.security.service.impl;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.Operation;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.ems.core.config.model.App;
import org.beangle.ems.core.security.model.FuncPermission;
import org.beangle.ems.core.security.model.FuncResource;
import org.beangle.ems.core.security.model.Menu;
import org.beangle.ems.core.security.service.FuncPermissionService;
import org.beangle.ems.core.user.model.Role;
import org.beangle.ems.core.user.model.User;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class FuncPermissionServiceImpl
implements FuncPermissionService {
    private final EntityDao entityDao;

    public FuncPermissionServiceImpl(EntityDao entityDao) {
        this.entityDao = entityDao;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    @Override
    public Option<FuncResource> getResource(App app, String name) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(FuncResource.class, "r");
        OqlBuilder oqlBuilder = (OqlBuilder)query.where("r.name=:name and r.app=:app", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name, app}));
        oqlBuilder.cacheable(oqlBuilder.cacheable$default$1());
        Seq rs = this.entityDao().search((QueryBuilder)query);
        if (rs.isEmpty()) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply(rs.head());
    }

    @Override
    public scala.collection.immutable.Set<Object> getResourceIdsByRole(int roleId) {
        String hql = "select a.resource.id from " + FuncPermission.class.getName() + " as a where a.role.id= :roleId and a.resource.enabled = true";
        OqlBuilder oqlBuilder = (OqlBuilder)OqlBuilder$.MODULE$.oql(hql).param("roleId", (Object)BoxesRunTime.boxToInteger((int)roleId));
        OqlBuilder query = (OqlBuilder)oqlBuilder.cacheable(oqlBuilder.cacheable$default$1());
        return this.entityDao().search((QueryBuilder)query).toSet();
    }

    @Override
    public Seq<FuncResource> getResources(User user) {
        return null;
    }

    @Override
    public Seq<FuncResource> getResources(App app) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(FuncResource.class, "r");
        query.where("r.app = :app", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{app}));
        return this.entityDao().search((QueryBuilder)query);
    }

    @Override
    public Seq<FuncPermission> getPermissions(App app, Role role) {
        return this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(FuncPermission.class, "fp").where("fp.resource.app=:app and fp.role=:role", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{app, role})));
    }

    @Override
    public void activate(Iterable<Object> ids, boolean active) {
        Seq resources = this.entityDao().find(FuncResource.class, ids);
        resources.foreach((Function1)(JProcedure1 & Serializable)f -> f.enabled_$eq(active));
        this.entityDao().saveOrUpdate((Iterable)resources);
    }

    @Override
    public void authorize(App app, Role role, scala.collection.immutable.Set<FuncResource> resources) {
        Set resourceSet = (Set)Collections$.MODULE$.newSet().$plus$plus(resources);
        Buffer permissions = this.getPermissions(app, role).toBuffer();
        Operation.Builder builder = new Operation.Builder();
        permissions.foreach((Function1 & Serializable)au -> {
            if (resources.contains((Object)au.resource())) {
                return BoxesRunTime.boxToBoolean((boolean)resourceSet.remove((Object)au.resource()));
            }
            return builder.remove((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{au}));
        });
        resourceSet.foreach((Function1 & Serializable)resource -> {
            FuncPermission authority = new FuncPermission(role, (FuncResource)((Object)resource));
            return builder.saveOrUpdate((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{authority}));
        });
        this.entityDao().execute(builder);
    }

    @Override
    public void removeResources(Iterable<FuncResource> resources) {
        OqlBuilder menuBuilder2 = (OqlBuilder)OqlBuilder$.MODULE$.from(Menu.class, "m").join("m.resources", "r");
        Seq menus2 = this.entityDao().search((QueryBuilder)menuBuilder2);
        menus2.foreach((Function1 & Serializable)m -> (Set)m.resources().$minus$minus$eq((IterableOnce)resources));
        this.entityDao().saveOrUpdate((Iterable)menus2);
        OqlBuilder menuBuilder = (OqlBuilder)OqlBuilder$.MODULE$.from(Menu.class, "m").where("m.entry in(:entries)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{resources}));
        Seq menus = this.entityDao().search((QueryBuilder)menuBuilder);
        menus.foreach((Function1)(JProcedure1 & Serializable)m -> m.entry_$eq((Option<FuncResource>)None$.MODULE$));
        OqlBuilder query = OqlBuilder$.MODULE$.from(FuncPermission.class, "fp");
        query.where("fp.resource in(:res)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{resources}));
        Seq fps = this.entityDao().search((QueryBuilder)query);
        this.entityDao().remove((Iterable)fps);
        this.entityDao().remove(resources);
    }
}

