/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.core.security.service.impl;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.collection.Properties;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.pojo.Hierarchical;
import org.beangle.data.model.pojo.Named;
import org.beangle.data.model.util.Hierarchicals$;
import org.beangle.ems.core.config.model.App;
import org.beangle.ems.core.config.model.AppGroup;
import org.beangle.ems.core.config.model.Domain;
import org.beangle.ems.core.config.service.DomainService;
import org.beangle.ems.core.security.model.FuncPermission;
import org.beangle.ems.core.security.model.FuncResource;
import org.beangle.ems.core.security.model.Menu;
import org.beangle.ems.core.security.service.AppMenus;
import org.beangle.ems.core.security.service.AppMenus$;
import org.beangle.ems.core.security.service.DomainMenus;
import org.beangle.ems.core.security.service.DomainMenus$;
import org.beangle.ems.core.security.service.GroupMenus;
import org.beangle.ems.core.security.service.GroupMenus$;
import org.beangle.ems.core.security.service.MenuService;
import org.beangle.ems.core.user.model.Role;
import org.beangle.ems.core.user.model.User;
import org.beangle.security.authz.Scope$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering$;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.xml.Node;
import scala.xml.NodeSeq;

public class MenuServiceImpl
implements MenuService {
    private final EntityDao entityDao;
    private DomainService domainService;

    public MenuServiceImpl(EntityDao entityDao) {
        this.entityDao = entityDao;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public DomainService domainService() {
        return this.domainService;
    }

    public void domainService_$eq(DomainService x$1) {
        this.domainService = x$1;
    }

    private scala.collection.immutable.Seq<Role> getRoles(User user) {
        Domain domain = this.domainService().getDomain();
        Buffer roles = (Buffer)((IterableOps)user.roles().filter((Function1 & Serializable)m -> {
            if (!m.member()) return false;
            Domain domain = m.role().domain();
            Domain domain2 = domain;
            if (domain != null) {
                if (!domain.equals(domain2)) return false;
                return true;
            }
            if (domain2 == null) return true;
            return false;
        })).map((Function1 & Serializable)m -> m.role());
        return roles.toSeq();
    }

    @Override
    public Seq<Menu> getTopMenus(App app, User user) {
        return this.getTopMenus((Option<App>)Some$.MODULE$.apply((Object)app), (Iterable<Role>)this.getRoles(user));
    }

    @Override
    public Seq<Menu> getTopMenus(User user) {
        return this.getTopMenus((Option<App>)None$.MODULE$, (Iterable<Role>)this.getRoles(user));
    }

    @Override
    public Seq<Menu> getTopMenus(App app, Role role) {
        return this.getTopMenus((Option<App>)Some$.MODULE$.apply((Object)app), (Iterable<Role>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Role[]{role}))));
    }

    private Seq<Menu> getTopMenus(Option<App> app, Iterable<Role> roles) {
        scala.collection.mutable.Set menuSet = Collections$.MODULE$.newSet();
        roles.foreach((Function1)(JProcedure1 & Serializable)role -> {
            OqlBuilder query = (OqlBuilder)OqlBuilder$.MODULE$.from(Menu.class.getName() + " menu," + FuncPermission.class.getName() + " fp").where("menu.enabled=true", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])).where("fp.role =:role", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{role})).where("fp.resource=menu.entry", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])).select("menu");
            app.foreach((Function1 & Serializable)p -> (OqlBuilder)query.where("menu.app=:app", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{p})));
            query.where("menu.app.domain =:domain and menu.app.enabled=true", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.domainService().getDomain()}));
            query.cacheable(query.cacheable$default$1());
            this.entityDao().search((QueryBuilder)query).foreach((Function1)(JProcedure1 & Serializable)m -> {
                menuSet.$plus$eq((Object)m);
                Menu p = (Menu)((Object)((Object)((Object)m.parent().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()))));
                while (p != null) {
                    if (!menuSet.contains((Object)p)) {
                        menuSet.$plus$eq((Object)p);
                        p = (Menu)((Object)((Object)((Object)p.parent().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()))));
                        continue;
                    }
                    p = null;
                }
            });
        });
        Buffer menus = Collections$.MODULE$.newBuffer();
        menuSet.foreach((Function1)(JProcedure1 & Serializable)m -> {
            if (m.parent().isEmpty()) {
                menus.$plus$eq((Object)m);
                this.reserveChildren((Menu)((Object)m), (Set<Menu>)menuSet);
                return;
            }
        });
        return (Seq)menus.sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
    }

    private void reserveChildren(Menu menu, Set<Menu> menus) {
        menu.children().$minus$minus$eq((IterableOnce)menu.children().filter((Function1 & Serializable)f -> !menus.contains((Object)f)));
        menu.children().foreach((Function1)(JProcedure1 & Serializable)c -> this.reserveChildren((Menu)((Object)c), menus));
    }

    @Override
    public Seq<Menu> getMenus(App app, Role role) {
        OqlBuilder<Menu> query = this.buildMenuQuery(app, role);
        query.where("menu.enabled = true", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        scala.collection.mutable.Set menus = Collections$.MODULE$.newSet();
        menus.$plus$plus$eq((IterableOnce)this.entityDao().search(query));
        return this.addParentMenus((scala.collection.mutable.Set<Menu>)menus);
    }

    @Override
    public Seq<Menu> getMenus(App app, User user) {
        scala.collection.mutable.Set menus = Collections$.MODULE$.newSet();
        user.roles().foreach((Function1)(JProcedure1 & Serializable)rm -> {
            if (rm.member()) {
                OqlBuilder<Menu> query = this.buildMenuQuery(app, rm.role());
                query.where("menu.enabled= true", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                menus.$plus$plus$eq((IterableOnce)this.entityDao().search(query));
                return;
            }
        });
        return this.addParentMenus((scala.collection.mutable.Set<Menu>)menus);
    }

    @Override
    public Seq<Menu> getTopMenus(App app) {
        OqlBuilder oqlBuilder = (OqlBuilder)OqlBuilder$.MODULE$.from(Menu.class).where("menu.app= :app and menu.parent = null", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{app})).orderBy("menu.indexno");
        OqlBuilder builder = (OqlBuilder)oqlBuilder.cacheable(oqlBuilder.cacheable$default$1());
        return this.entityDao().search((QueryBuilder)builder);
    }

    @Override
    public Seq<Menu> getMenus(App app) {
        OqlBuilder oqlBuilder = (OqlBuilder)OqlBuilder$.MODULE$.from(Menu.class).where("menu.app= :app", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{app})).orderBy("menu.indexno");
        OqlBuilder builder = (OqlBuilder)oqlBuilder.cacheable(oqlBuilder.cacheable$default$1());
        return this.entityDao().search((QueryBuilder)builder);
    }

    private OqlBuilder<Menu> buildMenuQuery(App app, Role role) {
        OqlBuilder builder = OqlBuilder$.MODULE$.from(Menu.class);
        builder.join("menu.resources", "mr");
        builder.where("exists(from " + FuncPermission.class.getName() + " a where a.role=:role and a.resource=mr)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{role}));
        builder.where("mr=menu.entry", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        builder.where("menu.app = :app", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{app}));
        builder.cacheable(builder.cacheable$default$1());
        return builder;
    }

    private Seq<Menu> addParentMenus(scala.collection.mutable.Set<Menu> menus) {
        Hierarchicals$.MODULE$.addParent(menus);
        return (Seq)menus.toList().sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
    }

    @Override
    public void move(Menu menu, Menu location, int index) {
        Iterable iterable;
        menu.parent().foreach((Function1)(JProcedure1 & Serializable)p -> {
            block3: {
                block2: {
                    if (location == null) break block2;
                    Menu menu = p;
                    Menu menu2 = location;
                    if (!(menu == null ? menu2 != null : !((Object)((Object)menu)).equals((Object)menu2))) break block3;
                }
                menu.parent_$eq((Option)None$.MODULE$);
                this.entityDao().saveOrUpdate((Object)menu, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Menu[0]));
                this.entityDao().refresh((Object)p);
                return;
            }
        });
        if (location != null) {
            iterable = Hierarchicals$.MODULE$.move((Hierarchical)menu, (Hierarchical)location, index);
        } else {
            OqlBuilder builder = (OqlBuilder)OqlBuilder$.MODULE$.from(Menu.class, "m").where("m.app = :app and m.parent is null", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{menu.app()})).orderBy("m.indexno");
            iterable = Hierarchicals$.MODULE$.move((Hierarchical)menu, this.entityDao().search((QueryBuilder)builder).toBuffer(), index);
        }
        Iterable nodes = iterable;
        this.entityDao().saveOrUpdate(nodes);
        if (location != null) {
            this.entityDao().refresh((Object)location);
            return;
        }
    }

    @Override
    public void importFrom(App app, Node xml) {
        this.parseMenu(app, (Option<Menu>)None$.MODULE$, xml);
    }

    @Override
    public DomainMenus getDomainMenus(User user, boolean isEnName) {
        Seq<Menu> menus = this.getTopMenus(user);
        Map appsMenus = menus.groupBy((Function1 & Serializable)_$2 -> _$2.app());
        Map groupApps = appsMenus.keys().groupBy((Function1 & Serializable)_$3 -> _$3.group());
        Map directMenuMaps = (Map)groupApps.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                AppGroup oned = (AppGroup)tuple2._1();
                Properties group = new Properties((Object)oned, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "indexno"}));
                group.put((Object)"title", (Object)(isEnName ? oned.enTitle() : oned.title()));
                Buffer appMenus = (Buffer)((IterableOps)((IterableOnceOps)groupApps.apply((Object)oned)).toBuffer().sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).map((Function1 & Serializable)app -> {
                    Properties appProps = new Properties(app, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "base", "url", "logoUrl", "navStyle"}));
                    appProps.put((Object)"title", (Object)(isEnName ? app.enTitle() : app.title()));
                    return AppMenus$.MODULE$.apply(appProps, (Iterable<Properties>)((Iterable)((IterableOps)appsMenus.apply(app)).map((Function1 & Serializable)x -> this.convert((Menu)((Object)((Object)((Object)x))), isEnName))));
                });
                return Tuple2$.MODULE$.apply((Object)oned, (Object)GroupMenus$.MODULE$.apply(group, (Iterable<AppMenus>)appMenus));
            }
            throw new MatchError((Object)tuple2);
        });
        Buffer groups = Collections$.MODULE$.newBuffer();
        ((IterableOnceOps)directMenuMaps.keys().toSeq().sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).foreach((Function1 & Serializable)g -> (Buffer)groups.$plus$eq(directMenuMaps.apply(g)));
        Domain domain = this.domainService().getDomain();
        Properties domainp = new Properties((Object)domain, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name"}));
        domainp.put((Object)"title", (Object)domain.getTitle(isEnName));
        return DomainMenus$.MODULE$.apply(domainp, (Iterable<GroupMenus>)groups);
    }

    @Override
    public Properties convert(Menu one, boolean isEnName) {
        Properties menu = new Properties((Object)one, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "fonticon", "indexno"}));
        menu.put((Object)"title", (Object)(isEnName ? one.enName() : one.name()));
        if (one.entry().isDefined()) {
            menu.put((Object)"entry", (Object)(((Named)one.entry().get()).name() + (String)(one.params().isDefined() ? "?" + one.params().get() : "")));
        }
        if (one.children().nonEmpty()) {
            ListBuffer children = new ListBuffer();
            one.children().foreach((Function1 & Serializable)child -> (ListBuffer)children.$plus$eq((Object)this.convert((Menu)((Object)child), isEnName)));
            menu.put((Object)"children", (Object)children);
        }
        return menu;
    }

    private void parseMenu(App app, Option<Menu> parent, Node xml) {
        xml.$bslash("resources").$bslash("resource").foreach((Function1)(JProcedure1 & Serializable)r -> {
            String name = r.$bslash("@name").text().trim();
            String title = r.$bslash("@title").text().trim();
            String scope = r.$bslash("@scope").text().trim();
            String enabled = r.$bslash("@enabled").text().trim();
            FuncResource fr = this.findOrCreateFuncResource(app, name, title, scope, enabled);
            this.entityDao().saveOrUpdate((Object)fr, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FuncResource[0]));
        });
        xml.$bslash("menu").foreach((Function1)(JProcedure1 & Serializable)m -> {
            String indexno = m.$bslash("@indexno").text().trim();
            String name = m.$bslash("@name").text().trim();
            Menu menu = (Menu)((Object)((Object)this.findMenu(app, parent, name).getOrElse(MenuServiceImpl::$anonfun$7)));
            menu.name_$eq(name);
            menu.indexno_$eq(indexno);
            menu.app_$eq(app);
            NodeSeq enName = m.$bslash("@enName");
            menu.enName_$eq(enName.isEmpty() ? menu.name() : enName.text().trim());
            NodeSeq params = m.$bslash("@params");
            if (params.isEmpty() || Strings$.MODULE$.isBlank((CharSequence)params.text())) {
                menu.params_$eq((Option<String>)None$.MODULE$);
            } else {
                menu.params_$eq((Option<String>)Some$.MODULE$.apply((Object)params.text().trim()));
            }
            NodeSeq enabled = m.$bslash("@enabled");
            if (enabled.isEmpty()) {
                menu.enabled_$eq(true);
            } else {
                menu.enabled_$eq(StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(enabled.text().trim())));
            }
            m.$bslash("@fonticon").foreach((Function1)(JProcedure1 & Serializable)fi -> menu.fonticon_$eq((Option<String>)Some$.MODULE$.apply((Object)fi.text().trim())));
            Option<FuncResource> entry = this.findFuncResource(app, m.$bslash("@entry").text().trim());
            NodeSeq resources = m.$bslash("@resources");
            if (resources.nonEmpty()) {
                Object object = Predef$.MODULE$.refArrayOps((Object[])Strings$.MODULE$.split(resources.text()));
                ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)n -> this.findFuncResource(app, (String)n).foreach((Function1 & Serializable)r -> (scala.collection.mutable.Set)menu.resources().$plus$eq((Object)r)));
            }
            entry.foreach((Function1 & Serializable)r -> (scala.collection.mutable.Set)menu.resources().$plus$eq((Object)r));
            menu.entry_$eq(entry);
            menu.parent_$eq(parent);
            this.entityDao().saveOrUpdate((Object)menu, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Menu[0]));
            NodeSeq children = m.$bslash("children");
            if (children.nonEmpty()) {
                this.parseMenu(app, (Option<Menu>)Some$.MODULE$.apply((Object)menu), (Node)children.head());
                return;
            }
        });
    }

    private Option<Menu> findMenu(App app, Option<Menu> parent, String name) {
        OqlBuilder builder = (OqlBuilder)OqlBuilder$.MODULE$.from(Menu.class, "m").where("m.app=:app", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{app}));
        Option<Menu> option = parent;
        if (None$.MODULE$.equals(option)) {
            v0 = (OqlBuilder)builder.where("m.name=:name and m.parent is null", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name}));
        } else if (option instanceof Some) {
            Menu p = (Menu)((Object)((Some)option).value());
            v0 = (OqlBuilder)builder.where("m.name=:name and m.parent=:p", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name, p}));
        } else {
            throw new MatchError(option);
        }
        return this.entityDao().search((QueryBuilder)builder).headOption();
    }

    private Option<FuncResource> findFuncResource(App app, String name) {
        OqlBuilder builder = (OqlBuilder)OqlBuilder$.MODULE$.from(FuncResource.class, "fr").where("fr.app=:app", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{app}));
        builder.where("fr.name=:name", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name}));
        return this.entityDao().search((QueryBuilder)builder).headOption();
    }

    private FuncResource findOrCreateFuncResource(App app, String name, String title, String scope, String enabled) {
        Option<FuncResource> option = this.findFuncResource(app, name);
        if (None$.MODULE$.equals(option)) {
            FuncResource resource = new FuncResource();
            resource.app_$eq(app);
            resource.name_$eq(name);
            resource.title_$eq(title);
            resource.scope_$eq(Strings$.MODULE$.isEmpty((CharSequence)scope) ? Scope$.Private : Scope$.MODULE$.valueOf(scope));
            if (Strings$.MODULE$.isEmpty((CharSequence)enabled)) {
                resource.enabled_$eq(true);
            } else {
                resource.enabled_$eq(StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(enabled)));
            }
            this.entityDao().saveOrUpdate((Object)resource, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FuncResource[0]));
            return resource;
        }
        if (option instanceof Some) {
            FuncResource r = (FuncResource)((Object)((Some)option).value());
            return r;
        }
        throw new MatchError(option);
    }

    private static final Menu $anonfun$7() {
        return new Menu();
    }
}

