/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.database.action;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Map;
import javax.sql.DataSource;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Throwables;
import org.beangle.ems.database.service.DatasourceService;
import org.beangle.ems.web.action.SecurityActionSupport;

public class DatasourceAction
extends SecurityActionSupport {
    private DatasourceService datasourceService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String test() {
        Integer datasourceId = (Integer)this.getId("datasource", Integer.class);
        DataSource dataSource = this.datasourceService.getDatasource(datasourceId);
        Map driverinfo = CollectUtils.newHashMap();
        Map dbinfo = CollectUtils.newHashMap();
        Map jdbcinfo = CollectUtils.newHashMap();
        Connection con = null;
        try {
            con = dataSource.getConnection();
            if (con != null) {
                DatabaseMetaData dm = con.getMetaData();
                driverinfo.put("Driver Name", dm.getDriverName());
                driverinfo.put("Driver Version", dm.getDriverVersion());
                dbinfo.put("Database Name", dm.getDatabaseProductName());
                dbinfo.put("Database Version", dm.getDatabaseProductVersion());
                jdbcinfo.put("JDBC Version", dm.getJDBCMajorVersion() + "." + dm.getJDBCMinorVersion());
                StringBuilder catelogs = new StringBuilder();
                dbinfo.put("Avalilable Catalogs", catelogs);
                ResultSet rs = dm.getCatalogs();
                while (rs.next()) {
                    catelogs.append(rs.getString(1));
                    if (!rs.next()) continue;
                    catelogs.append(',');
                }
                rs.close();
            }
        }
        catch (Exception e) {
            this.put("exceptionStack", Throwables.getStackTrace((Throwable)e));
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
                con = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.put("driverinfo", driverinfo);
        this.put("dbinfo", dbinfo);
        this.put("jdbcinfo", jdbcinfo);
        return this.forward();
    }

    protected String getEntityName() {
        return "org.beangle.webapp.database.model.DatasourceBean";
    }

    protected String getShortName() {
        return "datasource";
    }

    public void setDatasourceService(DatasourceService dataSourceService) {
        this.datasourceService = dataSourceService;
    }
}

