/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.database.action;

import com.opensymphony.xwork2.ActionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.collection.page.PageLimit;
import org.beangle.commons.collection.page.SinglePage;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.lang.Throwables;
import org.beangle.ems.database.action.QueryResult;
import org.beangle.ems.database.service.SqlService;
import org.beangle.ems.web.action.SecurityActionSupport;

public class QueryAction
extends SecurityActionSupport {
    private String sql;
    private SqlService sqlService;

    private void processSql() {
        this.sql = this.get("sql");
        if (null != this.sql) {
            this.sql = this.sql.trim();
        }
    }

    protected Collection<?> getExportDatas() {
        this.processSql();
        String newSql = this.sql;
        if (Strings.isEmpty((CharSequence)newSql)) {
            return Collections.emptyList();
        }
        boolean thisPage = this.getBool("thisPage");
        if (thisPage) {
            PageLimit limit = this.getPageLimit();
            newSql = this.sqlService.getLimitString(this.sql, limit);
        }
        List datas = this.sqlService.queryForList(newSql);
        return datas;
    }

    public String index() {
        DataSource datasource = (DataSource)ActionContext.getContext().getSession().get("datasource");
        this.sqlService.setDataSource(datasource);
        this.processSql();
        List results = CollectUtils.newArrayList();
        this.put("results", results);
        if (Strings.isEmpty((CharSequence)this.sql)) {
            return this.forward("result");
        }
        boolean isBatch = this.getBool("isBatch");
        if (isBatch) {
            String[] sqls;
            for (String one : sqls = Strings.split((String)this.sql, (String)";")) {
                results.add(this.query(one.trim()));
            }
        } else {
            results.add(this.query(this.sql.trim()));
        }
        return this.forward("result");
    }

    private QueryResult query(String sqlString) {
        QueryResult result = new QueryResult(sqlString);
        try {
            if (sqlString.toLowerCase().startsWith("select")) {
                PageLimit limit = this.getPageLimit();
                String newSql = this.sqlService.getLimitString(sqlString, limit);
                List datas = this.sqlService.queryForList(newSql);
                SinglePage page = new SinglePage(limit.getPageNo(), limit.getPageSize(), this.sqlService.count(sqlString), datas);
                if (!datas.isEmpty()) {
                    result.setColumns(new ArrayList<String>(((Map)datas.get(0)).keySet()));
                }
                result.setDatas((List<?>)page);
            } else {
                int updateCount = this.sqlService.update(sqlString);
                result.setUpdateCount(updateCount);
            }
        }
        catch (Exception e) {
            result.setMsg(Throwables.getStackTrace((Throwable)e));
        }
        List history = (List)ActionContext.getContext().getSession().get("sql_history");
        if (null == history) {
            history = CollectUtils.newArrayList();
            ActionContext.getContext().getSession().put("sql_history", history);
        }
        history.add(sqlString);
        return result;
    }

    public String history() {
        boolean clear;
        List history = (List)ActionContext.getContext().getSession().get("sql_history");
        if (null == history) {
            history = CollectUtils.newArrayList();
            ActionContext.getContext().getSession().put("sql_history", history);
        }
        if (clear = this.getBool("clear")) {
            history.clear();
            return this.redirect("index", "info.save.success");
        }
        return this.forward();
    }

    public void setSqlService(SqlService sqlService) {
        this.sqlService = sqlService;
    }
}

