/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.database.service;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.ems.database.model.DatasourceBean;
import org.beangle.ems.database.model.DatasourcePropertyBean;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

public class DatasourceService
extends BaseServiceImpl {
    private Map<Integer, DataSource> datasources = CollectUtils.newHashMap();

    public DataSource getDatasource(Integer id) {
        DataSource datasource = this.datasources.get(id);
        if (null == datasource) {
            OqlBuilder builder = OqlBuilder.from(DatasourceBean.class, (String)"ds");
            builder.where("ds.id=:id", (Object)id);
            List beans = this.entityDao.search((QueryBuilder)builder);
            if (!beans.isEmpty()) {
                DatasourceBean bean = (DatasourceBean)((Object)beans.get(0));
                DriverManagerDataSource ds = new DriverManagerDataSource();
                ds.setUrl(bean.getUrl());
                ds.setUsername(bean.getUsername());
                ds.setPassword(bean.getPassword());
                ds.setDriverClassName(bean.getDriverClassName());
                Properties properties = new Properties();
                for (DatasourcePropertyBean propertyBean : bean.getProperties()) {
                    properties.put(propertyBean.getName(), propertyBean.getValue());
                }
                ds.setConnectionProperties(properties);
                datasource = ds;
            }
            this.datasources.put(id, datasource);
        }
        return datasource;
    }
}

