/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.web.helper;

import com.opensymphony.xwork2.ActionContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;
import org.beangle.commons.bean.PropertyUtils;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.web.util.RequestUtils;
import org.beangle.security.access.AccessDeniedException;
import org.beangle.security.blueprint.Dimension;
import org.beangle.security.blueprint.Profile;
import org.beangle.security.blueprint.SecurityUtils;
import org.beangle.security.blueprint.User;
import org.beangle.security.blueprint.data.DataPermission;
import org.beangle.security.blueprint.data.service.DataPermissionService;
import org.beangle.security.blueprint.function.FuncResource;
import org.beangle.security.blueprint.function.service.FuncPermissionService;
import org.beangle.security.blueprint.nav.service.MenuService;
import org.beangle.security.blueprint.service.ProfileService;
import org.beangle.security.blueprint.service.UserService;
import org.beangle.security.web.auth.AuthenticationService;

public class SecurityHelper {
    private static final String ProfileIdSessionAttributeName = "security.profileId";
    private FuncPermissionService funcPermissionService;
    private DataPermissionService dataPermissionService;
    private ProfileService profileService;
    private UserService userService;
    private MenuService menuService;
    private AuthenticationService authenticationService;

    public List<Profile> getProfiles() {
        return this.getProfiles(this.userService.get(this.getUserId()), this.getResource());
    }

    public Profile getSessionProfile() {
        Object profileId = ActionContext.getContext().getSession().get(ProfileIdSessionAttributeName);
        if (null == profileId) {
            return null;
        }
        return this.profileService.get((Long)profileId);
    }

    public void setSessionProfile(Profile profile) {
        if (null == profile) {
            ActionContext.getContext().getSession().remove(ProfileIdSessionAttributeName);
        } else {
            ActionContext.getContext().getSession().put(ProfileIdSessionAttributeName, PropertyUtils.getProperty((Object)profile, (String)"id"));
        }
    }

    private List<Profile> getProfiles(User user, FuncResource resource) {
        List profiles = this.profileService.getProfiles(user, resource);
        Object profileId = ActionContext.getContext().getSession().get(ProfileIdSessionAttributeName);
        if (null == profileId) {
            return profiles;
        }
        Profile sessionProfile = null;
        for (Profile p : profiles) {
            if (!PropertyUtils.getProperty((Object)p, (String)"id").equals(profileId)) continue;
            sessionProfile = p;
            break;
        }
        if (null == sessionProfile) {
            throw new AccessDeniedException((Object)resource.getName(), "error.security.errorprofile");
        }
        return Collections.singletonList(sessionProfile);
    }

    public FuncResource getResource() {
        String resourceName = SecurityUtils.getResource();
        if (null == resourceName) {
            resourceName = this.funcPermissionService.extractResource(RequestUtils.getServletPath((HttpServletRequest)ServletActionContext.getRequest()));
        }
        return this.funcPermissionService.getResource(resourceName);
    }

    protected boolean isAdmin() {
        return this.funcPermissionService.getUserService().isRoot(this.getUserId());
    }

    public <T> List<T> getProperties(String name) {
        List<Profile> profiles = this.getProfiles(this.userService.get(this.getUserId()), this.getResource());
        Dimension field = this.profileService.getDimension(name);
        Set results = CollectUtils.newHashSet();
        for (Profile profile : profiles) {
            Object prop = this.profileService.getProperty(profile, field);
            if (prop instanceof Collection) {
                results.addAll((Collection)prop);
                continue;
            }
            results.add(prop);
        }
        return CollectUtils.newArrayList((Collection)results);
    }

    protected Long getUserId() {
        return SecurityUtils.getUserId();
    }

    public void applyPermission(OqlBuilder<?> query) {
        User user = this.userService.get(this.getUserId());
        if (this.userService.isRoot(user)) {
            return;
        }
        DataPermission dp = this.dataPermissionService.getPermission(user, query.getEntityClass().getName(), SecurityUtils.getResource());
        if (null == dp) {
            return;
        }
        List<Profile> profiles = this.getProfiles(user, this.getResource());
        if (profiles.isEmpty()) {
            throw new AccessDeniedException((Object)SecurityUtils.getResource(), "error.security.errorprofile");
        }
        this.dataPermissionService.apply(query, dp, profiles);
    }

    public void setFuncPermissionService(FuncPermissionService funcPermissionService) {
        this.funcPermissionService = funcPermissionService;
    }

    public void setDataPermissionService(DataPermissionService dataPermissionService) {
        this.dataPermissionService = dataPermissionService;
    }

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public FuncPermissionService getFuncPermissionService() {
        return this.funcPermissionService;
    }

    public DataPermissionService getDataPermissionService() {
        return this.dataPermissionService;
    }

    public ProfileService getProfileService() {
        return this.profileService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public MenuService getMenuService() {
        return this.menuService;
    }

    public void setMenuService(MenuService menuService) {
        this.menuService = menuService;
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }
}

