/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.ws.oauth;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.UUID;
import org.beangle.commons.collection.Properties;
import org.beangle.commons.logging.Logging;
import org.beangle.data.dao.EntityDao;
import org.beangle.ems.core.config.model.AccessToken;
import org.beangle.ems.core.config.model.App;
import org.beangle.ems.core.config.service.AppService;
import org.beangle.ems.core.oauth.service.TokenRepository;
import org.beangle.webmvc.api.action.ActionSupport;
import org.beangle.webmvc.api.action.MessageSupport;
import org.beangle.webmvc.api.action.ParamSupport;
import org.beangle.webmvc.api.action.RouteSupport;
import org.beangle.webmvc.api.action.To;
import org.beangle.webmvc.api.action.ToClass;
import org.beangle.webmvc.api.action.ToURI;
import org.beangle.webmvc.api.annotation.ignore;
import org.beangle.webmvc.api.annotation.param;
import org.beangle.webmvc.api.annotation.response;
import org.beangle.webmvc.api.view.PathView;
import org.beangle.webmvc.api.view.View;
import org.slf4j.Logger;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005\rb\u0001B\u0006\r\u0001]A\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\te\u0001\u0011\t\u0011)A\u0005g!)!\b\u0001C\u0001w!I\u0001\t\u0001a\u0001\u0002\u0004%\t!\u0011\u0005\n\u0015\u0002\u0001\r\u00111A\u0005\u0002-C\u0011\"\u0015\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\"\t\u000bI\u0003A\u0011A*\t\u000bm\u0004A\u0011\u0001?\t\u000f\u0005-\u0001\u0001\"\u0003\u0002\u000e!9\u0011q\u0002\u0001\u0005\n\u0005E!a\u0002+pW\u0016twk\u0015\u0006\u0003\u001b9\tQa\\1vi\"T!a\u0004\t\u0002\u0005]\u001c(BA\t\u0013\u0003\r)Wn\u001d\u0006\u0003'Q\tqAY3b]\u001edWMC\u0001\u0016\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001D\b\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005}1S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013AB1di&|gN\u0003\u0002$I\u0005\u0019\u0011\r]5\u000b\u0005\u0015\u0012\u0012AB<fE648-\u0003\u0002(A\ti\u0011i\u0019;j_:\u001cV\u000f\u001d9peR\fq\u0002^8lK:\u0014V\r]8tSR|'/\u001f\t\u0003UAj\u0011a\u000b\u0006\u0003Y5\nqa]3sm&\u001cWM\u0003\u0002\u000e])\u0011q\u0006E\u0001\u0005G>\u0014X-\u0003\u00022W\tyAk\\6f]J+\u0007o\\:ji>\u0014\u00180\u0001\u0006baB\u001cVM\u001d<jG\u0016\u0004\"\u0001\u000e\u001d\u000e\u0003UR!\u0001\f\u001c\u000b\u0005]r\u0013AB2p]\u001aLw-\u0003\u0002:k\tQ\u0011\t\u001d9TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\radh\u0010\t\u0003{\u0001i\u0011\u0001\u0004\u0005\u0006Q\r\u0001\r!\u000b\u0005\u0006e\r\u0001\raM\u0001\nK:$\u0018\u000e^=EC>,\u0012A\u0011\t\u0003\u0007\"k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000b1\u0001Z1p\u0015\t9%#\u0001\u0003eCR\f\u0017BA%E\u0005%)e\u000e^5us\u0012\u000bw.A\u0007f]RLG/\u001f#b_~#S-\u001d\u000b\u0003\u0019>\u0003\"!G'\n\u00059S\"\u0001B+oSRDq\u0001U\u0003\u0002\u0002\u0003\u0007!)A\u0002yIE\n!\"\u001a8uSRLH)Y8!\u0003\u0015awnZ5o)\r!Fl\u001d\t\u0003+jk\u0011A\u0016\u0006\u0003/b\u000b!bY8mY\u0016\u001cG/[8o\u0015\tI&#A\u0004d_6lwN\\:\n\u0005m3&A\u0003)s_B,'\u000f^5fg\")Ql\u0002a\u0001=\u0006!a.Y7f!\tyfM\u0004\u0002aIB\u0011\u0011MG\u0007\u0002E*\u00111MF\u0001\u0007yI|w\u000e\u001e \n\u0005\u0015T\u0012A\u0002)sK\u0012,g-\u0003\u0002hQ\n11\u000b\u001e:j]\u001eT!!\u001a\u000e)\tqS\u0007/\u001d\t\u0003W:l\u0011\u0001\u001c\u0006\u0003[\n\n!\"\u00198o_R\fG/[8o\u0013\tyGNA\u0003qCJ\fW.A\u0003wC2,X-I\u0001s\u0003\r\t\u0007\u000f\u001d\u0005\u0006i\u001e\u0001\rAX\u0001\u0007g\u0016\u001c'/\u001a;)\tMT\u0007O^\u0011\u0002i\"\u0012q\u0001\u001f\t\u0003WfL!A\u001f7\u0003\u0011I,7\u000f]8og\u0016\f\u0001B^1mS\u0012\fG/\u001a\u000b\u0004{\u0006\u0005\u0001CA\r\u007f\u0013\ty(DA\u0002B]fDa!a\u0001\t\u0001\u0004q\u0016!\u0002;pW\u0016t\u0007FBA\u0001UB\f9!\t\u0002\u0002\u0004!\u0012\u0001\u0002_\u0001\u0016O\u0016tWM]1uK\u0006\u001b7-Z:t)>\\WM\\%e)\u0005q\u0016!E4f]\u0016\u0014\u0018\r^3FqBL'/\u001a3BiR\u0011\u00111\u0003\t\u0005\u0003+\ty\"\u0004\u0002\u0002\u0018)!\u0011\u0011DA\u000e\u0003\u0011!\u0018.\\3\u000b\u0005\u0005u\u0011\u0001\u00026bm\u0006LA!!\t\u0002\u0018\t9\u0011J\\:uC:$\b")
public class TokenWS
implements ActionSupport {
    private final TokenRepository tokenRepository;
    private final AppService appService;
    private EntityDao entityDao;
    private Logger logger;

    public final void put(String key, Object value) {
        ParamSupport.put$((ParamSupport)this, (String)key, (Object)value);
    }

    public final Iterable<Object> getAll(String paramName) {
        return ParamSupport.getAll$((ParamSupport)this, (String)paramName);
    }

    public final <T> Iterable<T> getAll(String paramName, Class<T> clazz, ClassTag<T> evidence$1) {
        return ParamSupport.getAll$((ParamSupport)this, (String)paramName, clazz, evidence$1);
    }

    public final Option<String> get(String paramName) {
        return ParamSupport.get$((ParamSupport)this, (String)paramName);
    }

    public final <T> T get(String paramName, T defaultValue) {
        return (T)ParamSupport.get$((ParamSupport)this, (String)paramName, defaultValue);
    }

    public final Object attribute(String name) {
        return ParamSupport.attribute$((ParamSupport)this, (String)name);
    }

    public final <T> T attribute(String name, Class<T> clazz) {
        return (T)ParamSupport.attribute$((ParamSupport)this, (String)name, clazz);
    }

    public final <T> Option<T> get(String name, Class<T> clazz) {
        return ParamSupport.get$((ParamSupport)this, (String)name, clazz);
    }

    public final Option<Object> getBoolean(String name) {
        return ParamSupport.getBoolean$((ParamSupport)this, (String)name);
    }

    public final boolean getBoolean(String name, boolean defaultValue) {
        return ParamSupport.getBoolean$((ParamSupport)this, (String)name, (boolean)defaultValue);
    }

    public final Option<LocalDate> getDate(String name) {
        return ParamSupport.getDate$((ParamSupport)this, (String)name);
    }

    public final Option<LocalDateTime> getDateTime(String name) {
        return ParamSupport.getDateTime$((ParamSupport)this, (String)name);
    }

    public final Option<Instant> getInstant(String name) {
        return ParamSupport.getInstant$((ParamSupport)this, (String)name);
    }

    public final Option<Object> getFloat(String name) {
        return ParamSupport.getFloat$((ParamSupport)this, (String)name);
    }

    public final Option<Object> getShort(String name) {
        return ParamSupport.getShort$((ParamSupport)this, (String)name);
    }

    public final Option<Object> getInt(String name) {
        return ParamSupport.getInt$((ParamSupport)this, (String)name);
    }

    public final int getInt(String name, int defaultValue) {
        return ParamSupport.getInt$((ParamSupport)this, (String)name, (int)defaultValue);
    }

    public final Option<Object> getLong(String name) {
        return ParamSupport.getLong$((ParamSupport)this, (String)name);
    }

    @ignore
    public final PathView forward(String view) {
        return RouteSupport.forward$((RouteSupport)this, (String)view);
    }

    public final String forward$default$1() {
        return RouteSupport.forward$default$1$((RouteSupport)this);
    }

    @ignore
    public final PathView forward(String view, String message) {
        return RouteSupport.forward$((RouteSupport)this, (String)view, (String)message);
    }

    @ignore
    public final View forward(To action2) {
        return RouteSupport.forward$((RouteSupport)this, (To)action2);
    }

    @ignore
    public final View forward(To action2, String message) {
        return RouteSupport.forward$((RouteSupport)this, (To)action2, (String)message);
    }

    @ignore
    public final ToClass to(Object obj, String method) {
        return RouteSupport.to$((RouteSupport)this, (Object)obj, (String)method);
    }

    @ignore
    public final ToClass to(Object obj, String method, String params) {
        return RouteSupport.to$((RouteSupport)this, (Object)obj, (String)method, (String)params);
    }

    @ignore
    public final ToClass to(Class<?> clazz, String method) {
        return RouteSupport.to$((RouteSupport)this, clazz, (String)method);
    }

    @ignore
    public final ToClass to(Class<?> clazz, String method, String params) {
        return RouteSupport.to$((RouteSupport)this, clazz, (String)method, (String)params);
    }

    @ignore
    public final ToURI to(String uri, String params) {
        return RouteSupport.to$((RouteSupport)this, (String)uri, (String)params);
    }

    @ignore
    public final To to(String uri) {
        return RouteSupport.to$((RouteSupport)this, (String)uri);
    }

    @ignore
    public final View redirect(String method) {
        return RouteSupport.redirect$((RouteSupport)this, (String)method);
    }

    @ignore
    public final View redirect(String method, String message) {
        return RouteSupport.redirect$((RouteSupport)this, (String)method, (String)message);
    }

    @ignore
    public final View redirect(String method, String params, String message) {
        return RouteSupport.redirect$((RouteSupport)this, (String)method, (String)params, (String)message);
    }

    @ignore
    public final View redirect(To action2, String message) {
        return RouteSupport.redirect$((RouteSupport)this, (To)action2, (String)message);
    }

    public final String getText(String aTextName) {
        return MessageSupport.getText$((MessageSupport)this, (String)aTextName);
    }

    public final String getText(String key, String defaultValue, Seq<Object> args) {
        return MessageSupport.getText$((MessageSupport)this, (String)key, (String)defaultValue, args);
    }

    public final String getTextInternal(String msgKey, Seq<Object> args) {
        return MessageSupport.getTextInternal$((MessageSupport)this, (String)msgKey, args);
    }

    public final void addMessage(String msgKey, Seq<Object> args) {
        MessageSupport.addMessage$((MessageSupport)this, (String)msgKey, args);
    }

    public final void addError(String msgKey, Seq<Object> args) {
        MessageSupport.addError$((MessageSupport)this, (String)msgKey, args);
    }

    public final void addFlashError(String msgKey, Seq<Object> args) {
        MessageSupport.addFlashError$((MessageSupport)this, (String)msgKey, args);
    }

    public final void addFlashMessage(String msgKey, Seq<Object> args) {
        MessageSupport.addFlashMessage$((MessageSupport)this, (String)msgKey, args);
    }

    @ignore
    public final List<String> actionMessages() {
        return MessageSupport.actionMessages$((MessageSupport)this);
    }

    @ignore
    public final List<String> actionErrors() {
        return MessageSupport.actionErrors$((MessageSupport)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    @response
    public Properties login(@param(value="app") String name, @param(value="secret") String secret) {
        Option option;
        Properties properties = new Properties();
        Option option2 = this.appService.getApp(name, secret);
        if (None$.MODULE$.equals(option2)) {
            option = properties.put((Object)"error", (Object)"Incorrect app name or secret!");
        } else if (option2 instanceof Some) {
            Some some = (Some)option2;
            App app = (App)some.value();
            AccessToken token = new AccessToken();
            token.id_$eq(this.generateAccessTokenId());
            token.appId_$eq(BoxesRunTime.unboxToInt((Object)app.id()));
            token.principal_$eq(app.name());
            token.expiredAt_$eq(this.generateExpiredAt());
            this.tokenRepository.put(token);
            properties.put((Object)"token", (Object)token.id());
            properties.put((Object)"appId", app.id());
            option = properties.put((Object)"expiredAt", (Object)token.expiredAt());
        } else {
            throw new MatchError((Object)option2);
        }
        return properties;
    }

    @response
    public Object validate(@param(value="token") String token) {
        Option option;
        Properties properties = new Properties();
        if (token == null) {
            option = properties.put((Object)"error", (Object)"token needed");
        } else {
            AccessToken accessToken;
            Option option2 = this.tokenRepository.get(token);
            if (option2 instanceof Some) {
                AccessToken app;
                Some some = (Some)option2;
                accessToken = app = (AccessToken)some.value();
            } else if (None$.MODULE$.equals(option2)) {
                properties.put((Object)"error", (Object)"cannot find app");
                accessToken = properties;
            } else {
                throw new MatchError((Object)option2);
            }
            option = accessToken;
        }
        return option;
    }

    private String generateAccessTokenId() {
        return UUID.randomUUID().toString();
    }

    private Instant generateExpiredAt() {
        return Instant.now().plus(Duration.ofDays(360L));
    }

    public TokenWS(TokenRepository tokenRepository, AppService appService) {
        this.tokenRepository = tokenRepository;
        this.appService = appService;
        MessageSupport.$init$((MessageSupport)this);
        RouteSupport.$init$((RouteSupport)this);
        ParamSupport.$init$((ParamSupport)this);
        Logging.$init$((Logging)this);
        Statics.releaseFence();
    }
}

