/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.ems.portal.admin.action.user;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.collection.Order$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.Condition;
import org.beangle.data.dao.Operation;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.ems.app.EmsApp$;
import org.beangle.ems.core.config.model.Domain;
import org.beangle.ems.core.config.model.Org;
import org.beangle.ems.core.config.service.DomainService;
import org.beangle.ems.core.user.model.Account;
import org.beangle.ems.core.user.model.MemberShip$;
import org.beangle.ems.core.user.model.Role;
import org.beangle.ems.core.user.model.RoleMember;
import org.beangle.ems.core.user.model.User;
import org.beangle.ems.core.user.service.AccountService;
import org.beangle.ems.core.user.service.UserService;
import org.beangle.security.Securities$;
import org.beangle.security.authc.DBCredentialStore;
import org.beangle.security.codec.DefaultPasswordEncoder$;
import org.beangle.webmvc.api.view.View;
import org.beangle.webmvc.entity.action.RestfulAction;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005mb\u0001B\f\u0019\u0001\u001dBQA\u000f\u0001\u0005\u0002mB\u0011B\u0010\u0001A\u0002\u0003\u0007I\u0011A \t\u0013\u0019\u0003\u0001\u0019!a\u0001\n\u00039\u0005\"\u0003)\u0001\u0001\u0004\u0005\t\u0015)\u0003A\u0011%\t\u0006\u00011AA\u0002\u0013\u0005!\u000bC\u0005W\u0001\u0001\u0007\t\u0019!C\u0001/\"I\u0011\f\u0001a\u0001\u0002\u0003\u0006Ka\u0015\u0005\n5\u0002\u0001\r\u00111A\u0005\u0002mC\u0011\u0002\u001a\u0001A\u0002\u0003\u0007I\u0011A3\t\u0013\u001d\u0004\u0001\u0019!A!B\u0013a\u0006\"\u00035\u0001\u0001\u0004\u0005\r\u0011\"\u0001j\u0011%\t\b\u00011AA\u0002\u0013\u0005!\u000fC\u0005u\u0001\u0001\u0007\t\u0011)Q\u0005U\")Q\u000f\u0001C!m\")q\u000f\u0001C)q\"9\u00111\u0001\u0001\u0005R\u0005\u0015\u0001bBA\u000e\u0001\u0011\u0005\u0011Q\u0004\u0005\b\u0003?\u0001A\u0011KA\u0011\u0011\u001d\t)\u0003\u0001C\u0005\u0003OAq!a\f\u0001\t\u0003\ni\u0002C\u0004\u00022\u0001!\t!!\b\t\u000f\u0005M\u0002\u0001\"\u0005\u00026\ti\u0011iY2pk:$\u0018i\u0019;j_:T!!\u0007\u000e\u0002\tU\u001cXM\u001d\u0006\u00037q\ta!Y2uS>t'BA\u000f\u001f\u0003\u0015\tG-\\5o\u0015\ty\u0002%\u0001\u0004q_J$\u0018\r\u001c\u0006\u0003C\t\n1!Z7t\u0015\t\u0019C%A\u0004cK\u0006tw\r\\3\u000b\u0003\u0015\n1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0015\u0011\u0007%z\u0013'D\u0001+\u0015\tY2F\u0003\u0002-[\u00051QM\u001c;jifT!A\f\u0012\u0002\r],'-\u001c<d\u0013\t\u0001$FA\u0007SKN$h-\u001e7BGRLwN\u001c\t\u0003eaj\u0011a\r\u0006\u0003iU\nQ!\\8eK2T!!\u0007\u001c\u000b\u0005]\u0002\u0013\u0001B2pe\u0016L!!O\u001a\u0003\u000f\u0005\u001b7m\\;oi\u00061A(\u001b8jiz\"\u0012\u0001\u0010\t\u0003{\u0001i\u0011\u0001G\u0001\fkN,'oU3sm&\u001cW-F\u0001A!\t\tE)D\u0001C\u0015\t\u0019U'A\u0004tKJ4\u0018nY3\n\u0005\u0015\u0013%aC+tKJ\u001cVM\u001d<jG\u0016\fq\"^:feN+'O^5dK~#S-\u001d\u000b\u0003\u0011:\u0003\"!\u0013'\u000e\u0003)S\u0011aS\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b*\u0013A!\u00168ji\"9qjAA\u0001\u0002\u0004\u0001\u0015a\u0001=%c\u0005aQo]3s'\u0016\u0014h/[2fA\u0005q\u0011mY2pk:$8+\u001a:wS\u000e,W#A*\u0011\u0005\u0005#\u0016BA+C\u00059\t5mY8v]R\u001cVM\u001d<jG\u0016\f!#Y2d_VtGoU3sm&\u001cWm\u0018\u0013fcR\u0011\u0001\n\u0017\u0005\b\u001f\u001a\t\t\u00111\u0001T\u0003=\t7mY8v]R\u001cVM\u001d<jG\u0016\u0004\u0013aD2sK\u0012,g\u000e^5bYN#xN]3\u0016\u0003q\u0003\"!\u00182\u000e\u0003yS!a\u00181\u0002\u000b\u0005,H\u000f[2\u000b\u0005\u0005\u0014\u0013\u0001C:fGV\u0014\u0018\u000e^=\n\u0005\rt&!\u0005#C\u0007J,G-\u001a8uS\u0006d7\u000b^8sK\u0006\u00192M]3eK:$\u0018.\u00197Ti>\u0014Xm\u0018\u0013fcR\u0011\u0001J\u001a\u0005\b\u001f&\t\t\u00111\u0001]\u0003A\u0019'/\u001a3f]RL\u0017\r\\*u_J,\u0007%A\u0007e_6\f\u0017N\\*feZL7-Z\u000b\u0002UB\u00111n\\\u0007\u0002Y*\u00111)\u001c\u0006\u0003]Z\naaY8oM&<\u0017B\u00019m\u00055!u.\\1j]N+'O^5dK\u0006\tBm\\7bS:\u001cVM\u001d<jG\u0016|F%Z9\u0015\u0005!\u001b\bbB(\r\u0003\u0003\u0005\rA[\u0001\u000fI>l\u0017-\u001b8TKJ4\u0018nY3!\u00031Ig\u000eZ3y'\u0016$H/\u001b8h)\u0005A\u0015aD4fiF+XM]=Ck&dG-\u001a:\u0016\u0003e\u00042A_@2\u001b\u0005Y(B\u0001?~\u0003\r!\u0017m\u001c\u0006\u0003}\n\nA\u0001Z1uC&\u0019\u0011\u0011A>\u0003\u0015=\u000bHNQ;jY\u0012,'/A\btCZ,\u0017I\u001c3SK\u0012L'/Z2u)\u0011\t9!a\u0006\u0011\t\u0005%\u00111C\u0007\u0003\u0003\u0017QA!!\u0004\u0002\u0010\u0005!a/[3x\u0015\r\t\t\"L\u0001\u0004CBL\u0017\u0002BA\u000b\u0003\u0017\u0011AAV5fo\"1\u0011\u0011\u0004\tA\u0002E\nq!Y2d_VtG/\u0001\u0005tCZ,'k\u001c7f)\t\t9!A\u0006fI&$8+\u001a;uS:<Gc\u0001%\u0002$!1\u0011\u0011\u0004\nA\u0002E\n\u0011\u0002\\8hS:,6/\u001a:\u0016\u0005\u0005%\u0002c\u0001\u001a\u0002,%\u0019\u0011QF\u001a\u0003\tU\u001bXM]\u0001\u0007e\u0016lwN^3\u0002\u0011\u0005\u001cG/\u001b<bi\u0016\fQ\"\u001e9eCR,\u0017iY2pk:$H#\u0002%\u00028\u0005e\u0002BB\r\u0017\u0001\u0004\tI\u0003\u0003\u0004\u0002\u001aY\u0001\r!\r")
public class AccountAction
extends RestfulAction<Account> {
    private UserService userService;
    private AccountService accountService;
    private DBCredentialStore credentialStore;
    private DomainService domainService;

    public UserService userService() {
        return this.userService;
    }

    public void userService_$eq(UserService x$1) {
        this.userService = x$1;
    }

    public AccountService accountService() {
        return this.accountService;
    }

    public void accountService_$eq(AccountService x$1) {
        this.accountService = x$1;
    }

    public DBCredentialStore credentialStore() {
        return this.credentialStore;
    }

    public void credentialStore_$eq(DBCredentialStore x$1) {
        this.credentialStore = x$1;
    }

    public DomainService domainService() {
        return this.domainService;
    }

    public void domainService_$eq(DomainService x$1) {
        this.domainService = x$1;
    }

    public void indexSetting() {
        this.put("categories", this.userService().getCategories());
    }

    /*
     * WARNING - void declaration
     */
    public OqlBuilder<Account> getQueryBuilder() {
        void var2_2;
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        Domain domain = this.domainService().getDomain();
        this.put("domain", domain);
        OqlBuilder accQuery = OqlBuilder$.MODULE$.from(Account.class, "account");
        accQuery.where("account.domain=:domain", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{domain}));
        accQuery.join("account.user", "user");
        StringBuilder sb = new StringBuilder();
        ListBuffer params = new ListBuffer();
        String roleName = (String)this.get("roleName", "");
        if (Strings$.MODULE$.isNotEmpty((CharSequence)roleName)) {
            sb.append("exists(from user.members m where ");
            sb.append("m.role.name like :roleName and m.domain=:domain ");
            params.$plus$eq((Object)new java.lang.StringBuilder(2).append("%").append(roleName).append("%").toString());
            params.$plus$eq((Object)domain);
            boxedUnit2 = sb.append(')');
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (sb.nonEmpty()) {
            Condition roleCondition = new Condition(sb.toString(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            roleCondition.params((Seq)params);
            boxedUnit = accQuery.where(roleCondition);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.populateConditions(accQuery);
        accQuery.tailOrder("account.id");
        accQuery.orderBy((String)this.get(Order$.MODULE$.OrderStr()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).limit(this.getPageLimit());
        return var2_2;
    }

    public View saveAndRedirect(Account account) {
        User user;
        User user2;
        if (this.getLong("user.id").isEmpty()) {
            User user3;
            String code = (String)Option$.MODULE$.option2Iterable(this.get("user.code")).head();
            Org org = this.domainService().getOrg();
            OqlBuilder userQuery = OqlBuilder$.MODULE$.from(User.class, "u");
            userQuery.where("u.code=:code and u.org=:org", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{code, org}));
            Option option = this.entityDao().search((QueryBuilder)userQuery).headOption();
            if (option instanceof Some) {
                User v;
                Some some = (Some)option;
                user3 = v = (User)some.value();
            } else if (None$.MODULE$.equals(option)) {
                user3 = (User)this.populateEntity(User.class, "user");
            } else {
                throw new MatchError((Object)option);
            }
            user2 = user3;
        } else {
            user2 = user = (User)this.populateEntity(User.class, "user");
        }
        if (!user.persisted()) {
            user.beginOn_$eq(account.beginOn());
            user.endOn_$eq(account.endOn());
            this.userService().create(this.loginUser(), user);
        } else {
            this.entityDao().saveOrUpdate((Object)user, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new User[0]));
        }
        account.user_$eq(user);
        this.updateAccount(account.user(), account);
        return this.redirect("search", "info.save.success");
    }

    public View saveRole() {
        Seq seq;
        User user = (User)this.entityDao().get(User.class, (Object)BoxesRunTime.boxToLong((long)this.longId("user")));
        Buffer userMembers = user.roles();
        HashMap memberMap = new HashMap();
        userMembers.foreach((Function1 & Serializable)gm -> {
            Domain domain = gm.role().domain();
            Domain domain2 = this.domainService().getDomain();
            return !(domain != null ? !domain.equals(domain2) : domain2 != null) ? memberMap.put((Object)gm.role(), gm) : BoxedUnit.UNIT;
        });
        Buffer newMembers = Collections$.MODULE$.newBuffer();
        Buffer removedMembers = Collections$.MODULE$.newBuffer();
        User manager = this.loginUser();
        boolean isAdmin = this.userService().isRoot(manager, EmsApp$.MODULE$.name());
        if (isAdmin) {
            OqlBuilder adminRoleQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Role.class, "r").where("r.domain=:domain", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.domainService().getDomain()}));
            seq = (Seq)this.entityDao().search((QueryBuilder)adminRoleQuery).map((Function1 & Serializable)r -> new RoleMember(manager, r, MemberShip$.MODULE$.Granter()));
        } else {
            seq = this.userService().getRoles(manager, MemberShip$.MODULE$.Granter());
        }
        Seq members = seq;
        members.foreach((Function1 & Serializable)member -> {
            BoxedUnit boxedUnit;
            RoleMember myMember = (RoleMember)memberMap.getOrElse((Object)member.role(), (Function0 & Serializable)() -> null);
            boolean isMember = this.getBoolean(new java.lang.StringBuilder(6).append("member").append(member.role().id()).toString(), false);
            boolean isGranter = this.getBoolean(new java.lang.StringBuilder(7).append("granter").append(member.role().id()).toString(), false);
            boolean isManager = this.getBoolean(new java.lang.StringBuilder(7).append("manager").append(member.role().id()).toString(), false);
            if (!(isMember || isGranter || isManager)) {
                if (myMember != null) {
                    user.roles().$minus$eq((Object)myMember);
                    boxedUnit = removedMembers.$plus$eq((Object)myMember);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                if (myMember == null) {
                    myMember = new RoleMember(user, member.role());
                }
                myMember.updatedAt_$eq(Instant.now());
                myMember.member_$eq(isMember);
                myMember.granter_$eq(isGranter);
                myMember.manager_$eq(isManager);
                boxedUnit = newMembers.$plus$eq((Object)myMember);
            }
            return boxedUnit;
        });
        Operation.Builder ob = new Operation.Builder();
        newMembers.foreach((Function1 & Serializable)m -> ob.saveOrUpdate((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{m})));
        removedMembers.foreach((Function1 & Serializable)m -> ob.remove((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{m})));
        this.entityDao().execute(ob);
        this.entityDao().refresh((Object)user);
        return this.redirect("search", "info.save.success");
    }

    public void editSetting(Account account) {
        this.put("categories", this.userService().getCategories());
        Domain domain = this.domainService().getDomain();
        User manager = this.loginUser();
        HashSet roles = new HashSet();
        HashMap mngMemberMap = new HashMap();
        boolean emsAdmin = this.userService().isRoot(manager, EmsApp$.MODULE$.name());
        if (emsAdmin) {
            OqlBuilder roleQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Role.class, "r").orderBy("r.indexno");
            roleQuery.where("r.domain=:domain", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{domain}));
            roles.$plus$plus$eq((IterableOnce)this.entityDao().search((QueryBuilder)roleQuery));
            roles.foreach((Function1 & Serializable)role -> mngMemberMap.put(role, (Object)new RoleMember(manager, role, MemberShip$.MODULE$.Granter())));
        } else {
            Seq members = this.userService().getRoles(manager, MemberShip$.MODULE$.Granter());
            members.foreach((Function1 & Serializable)gm -> {
                roles.add((Object)gm.role());
                return mngMemberMap.put((Object)gm.role(), gm);
            });
        }
        this.put("roles", roles);
        HashMap memberMap = new HashMap();
        if (account.user() != null) {
            account.user().roles().foreach((Function1 & Serializable)gm -> {
                Domain domain = gm.role().domain();
                Domain domain2 = domain;
                return !(domain != null ? !domain.equals(domain2) : domain2 != null) ? memberMap.put((Object)gm.role(), gm) : BoxedUnit.UNIT;
            });
        }
        this.put("memberMap", memberMap);
        this.put("mngMemberMap", mngMemberMap);
    }

    private User loginUser() {
        return (User)Option$.MODULE$.option2Iterable(this.userService().get(Securities$.MODULE$.user())).head();
    }

    public View remove() {
        block3: {
            IntRef expected;
            IntRef success;
            block2: {
                BoxedUnit boxedUnit;
                List accountIds = this.longIds("account");
                User creator = this.loginUser();
                scala.collection.immutable.Seq toBeRemoved = this.entityDao().find(Account.class, (Iterable)accountIds);
                StringBuilder sb = new StringBuilder();
                ObjectRef removed = ObjectRef.create(null);
                success = IntRef.create((int)0);
                expected = IntRef.create((int)toBeRemoved.size());
                try {
                    toBeRemoved.foreach((Function1 & Serializable)one -> {
                        AccountAction.$anonfun$remove$1(this, removed, creator, success, expected, one);
                        return BoxedUnit.UNIT;
                    });
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Exception exception) {
                    boxedUnit = sb.append(',').append(((Account)removed.elem).user().getName());
                }
                if (!sb.nonEmpty()) break block2;
                sb.deleteCharAt(0);
                this.addFlashMessage("security.info.userRemovePartial", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)success.elem), sb}));
                break block3;
            }
            if (expected.elem != success.elem || success.elem <= 0) break block3;
            this.addFlashMessage("info.remove.success", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        return this.redirect("search");
    }

    public View activate() {
        List accountIds = this.longIds("account");
        String isActivate = (String)this.get("isActivate", "true");
        int successCnt = 0;
        User manager = this.loginUser();
        String msg = "security.info.freeze.success";
        if (Strings$.MODULE$.isNotEmpty((CharSequence)isActivate) && "false".equals(isActivate)) {
            successCnt = this.accountService().enable(manager, (Iterable)accountIds, false);
        } else {
            msg = "security.info.activate.success";
            successCnt = this.accountService().enable(manager, (Iterable)accountIds, true);
        }
        this.addFlashMessage(msg, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)successCnt)}));
        return this.redirect("search");
    }

    public void updateAccount(User user, Account account) {
        String password = (String)this.get("password").orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (Strings$.MODULE$.isBlank((CharSequence)password) && !user.persisted()) {
            password = user.code();
        }
        if (Strings$.MODULE$.isNotBlank((CharSequence)password)) {
            password = DefaultPasswordEncoder$.MODULE$.generate(password, null, "sha");
        }
        if (account.persisted()) {
            if (Strings$.MODULE$.isNotBlank((CharSequence)password)) {
                this.credentialStore().updatePassword((Object)user.code(), password);
            }
        } else {
            if (password != null) {
                account.password_$eq(password);
            }
            this.accountService().createAccount(user, account);
        }
    }

    public static final /* synthetic */ void $anonfun$remove$1(AccountAction $this, ObjectRef removed$1, User creator$1, IntRef success$1, IntRef expected$1, Account one) {
        removed$1.elem = one;
        User user = one.user();
        User user2 = creator$1;
        if (user == null ? user2 != null : !user.equals(user2)) {
            User user3 = one.user();
            user3.acounts().$minus$eq((Object)one);
            $this.entityDao().saveOrUpdate((Object)user3, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new User[0]));
            if (user3.acounts().isEmpty()) {
                $this.userService().remove(creator$1, user3);
            }
            ++success$1.elem;
        } else {
            $this.addFlashError("security.info.cannotRemoveSelf", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            --expected$1.elem;
        }
    }
}

