/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.notification.service;

import org.beangle.notification.Message;
import org.beangle.notification.MessageQueue;
import org.beangle.notification.NotificationException;
import org.beangle.notification.NotificationTask;
import org.beangle.notification.Notifier;
import org.beangle.notification.service.DefaultMessageQueue;
import org.beangle.notification.service.SendingObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNotificationTask<T extends Message>
implements NotificationTask<T> {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultNotificationTask.class);
    private MessageQueue<T> queue = new DefaultMessageQueue();
    private Notifier<T> notifier;
    private SendingObserver observer;
    private long taskInterval = 0L;

    @Override
    public MessageQueue<T> getMessageQueue() {
        return this.queue;
    }

    @Override
    public void setMessageQueue(MessageQueue<T> messageQueue) {
        this.queue = messageQueue;
    }

    @Override
    public Notifier<T> getNotifier() {
        return this.notifier;
    }

    @Override
    public void setNotifier(Notifier<T> notifier) {
        this.notifier = notifier;
    }

    @Override
    public void send() {
        while (this.queue.size() > 0) {
            T msg = this.queue.remove();
            try {
                if (null != this.observer) {
                    this.observer.onStart((Message)msg);
                }
                this.notifier.deliver(msg);
                if (this.taskInterval > 0L) {
                    Thread.sleep(this.taskInterval);
                }
            }
            catch (NotificationException e) {
                logger.error("send error", (Throwable)e);
            }
            catch (InterruptedException e) {
                logger.error("send error", (Throwable)e);
            }
            if (null == this.observer) continue;
            this.observer.onFinish((Message)msg);
        }
    }

    public void setObserver(SendingObserver observer) {
        this.observer = observer;
    }
}

