/*
 * Beangle, Agile Java/Scala Development Scaffold and Toolkit
 *
 * Copyright (c) 2005-2012, Beangle Software.
 *
 * Beangle is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Beangle is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Beangle.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.beangle.notification;

import java.util.ArrayList;
import java.util.List;

public class SimpleMessage extends AbstractMessage {

  private List<String> recipients = new ArrayList<String>();

  public SimpleMessage() {
    super();
  }

  public SimpleMessage(String recipient, String subject, String text) {
    recipients.add(recipient);
    setSubject(subject);
    setText(text);
  }

  public List<String> getRecipients() {
    return recipients;
  }

  public String getContentType() {
    return "text/plain";
  }

}
