/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.notification.mail;

import org.beangle.commons.lang.Assert;
import org.beangle.notification.AbstractMessage;
import org.beangle.notification.Message;
import org.beangle.notification.NotificationException;
import org.beangle.notification.Notifier;
import org.beangle.notification.mail.MailMessage;
import org.beangle.notification.mail.MailSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMailNotifier<T extends MailMessage>
implements Notifier<T> {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractMailNotifier.class);
    protected MailSender mailSender;
    private String from;

    @Override
    public String getType() {
        return "mail";
    }

    @Override
    public void deliver(T msg) throws NotificationException {
        this.beforeSend((Message)msg);
        try {
            if (null == ((MailMessage)msg).getFrom() && null != this.getFrom()) {
                ((MailMessage)msg).from(this.getFrom());
            }
            this.mailSender.send(new MailMessage[]{msg});
            this.afterSend((Message)msg);
        }
        catch (NotificationException e) {
            logger.error("Cannot send message " + ((AbstractMessage)msg).getSubject(), (Throwable)e);
        }
    }

    protected abstract String buildSubject(Message var1);

    protected abstract String buildText(Message var1);

    protected void beforeSend(Message msg) {
    }

    protected void afterSend(Message msg) {
    }

    public MailSender getMailSender() {
        return this.mailSender;
    }

    public void setMailSender(MailSender MailSender2) {
        this.mailSender = MailSender2;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        Assert.notEmpty((CharSequence)from);
        this.from = from;
    }
}

