/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.notification.mail;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.lang.Throwables;
import org.beangle.notification.NotificationException;
import org.beangle.notification.NotificationSendException;
import org.beangle.notification.mail.MailMessage;
import org.beangle.notification.mail.MailSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaMailSender
implements MailSender {
    protected static final Logger logger = LoggerFactory.getLogger(JavaMailSender.class);
    private static final String HEADER_MESSAGE_ID = "Message-ID";
    private Properties javaMailProperties = new Properties();
    private Session session;
    private String protocol = "smtp";
    private String host;
    private int port = -1;
    private String username;
    private String password;
    private String defaultEncoding;

    public void send(MailMessage ... messages) {
        List mimeMsgs = CollectUtils.newArrayList();
        for (MailMessage m : messages) {
            try {
                mimeMsgs.add(this.createMimeMessage(m));
            }
            catch (MessagingException e) {
                logger.error("Cannot mapping message" + m.getSubject(), (Throwable)e);
            }
        }
        this.doSend(mimeMsgs.toArray(new MimeMessage[mimeMsgs.size()]));
    }

    protected MimeMessage createMimeMessage(MailMessage mailMsg) throws MessagingException {
        MimeMessage mimeMsg = new MimeMessage(this.getSession());
        mimeMsg.setSentDate(null == mailMsg.getSentAt() ? new Date() : mailMsg.getSentAt());
        if (null != mailMsg.getFrom()) {
            mimeMsg.setFrom((Address)mailMsg.getFrom());
        }
        this.addRecipient(mimeMsg, mailMsg);
        String encoding = Strings.substringAfter((String)mailMsg.getContentType(), (String)"charset=");
        try {
            mimeMsg.setSubject(MimeUtility.encodeText((String)mailMsg.getSubject(), (String)encoding, (String)"B"));
        }
        catch (UnsupportedEncodingException e) {
            Throwables.propagate((Throwable)e);
        }
        String text = mailMsg.getText();
        boolean html = Strings.contains((CharSequence)mailMsg.getContentType(), (CharSequence)"html");
        if (html) {
            if (Strings.isEmpty((CharSequence)encoding)) {
                mimeMsg.setContent((Object)text, "text/html");
            } else {
                mimeMsg.setContent((Object)text, "text/html;charset=" + encoding);
            }
        } else if (Strings.isEmpty((CharSequence)encoding)) {
            mimeMsg.setText(text);
        } else {
            mimeMsg.setText(text, encoding);
        }
        return mimeMsg;
    }

    protected synchronized Session getSession() {
        if (this.session == null) {
            this.session = Session.getInstance((Properties)this.javaMailProperties);
        }
        return this.session;
    }

    protected Transport getTransport(Session session) throws NoSuchProviderException {
        String protocol = this.getProtocol();
        if (protocol == null) {
            protocol = session.getProperty("mail.transport.protocol");
        }
        return session.getTransport(protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSend(MimeMessage[] mimeMessages) {
        Transport transport;
        LinkedHashMap<Object, Exception> failedMessages = new LinkedHashMap<Object, Exception>();
        try {
            transport = this.getTransport(this.getSession());
            transport.connect(this.getHost(), this.getPort(), this.getUsername(), this.getPassword());
        }
        catch (AuthenticationFailedException ex) {
            throw new NotificationException(ex);
        }
        catch (MessagingException ex) {
            for (int i = 0; i < mimeMessages.length; ++i) {
                MimeMessage original = mimeMessages[i];
                failedMessages.put(original, (Exception)((Object)ex));
            }
            throw new NotificationException("Mail server connection failed", ex);
        }
        try {
            for (MimeMessage mimeMessage : mimeMessages) {
                try {
                    if (mimeMessage.getSentDate() == null) {
                        mimeMessage.setSentDate(new Date());
                    }
                    String messageId = mimeMessage.getMessageID();
                    mimeMessage.saveChanges();
                    if (messageId != null) {
                        mimeMessage.setHeader(HEADER_MESSAGE_ID, messageId);
                    }
                    transport.sendMessage((Message)mimeMessage, mimeMessage.getAllRecipients());
                }
                catch (MessagingException ex) {
                    failedMessages.put(mimeMessage, (Exception)((Object)ex));
                }
            }
        }
        finally {
            try {
                transport.close();
            }
            catch (MessagingException ex) {
                if (!failedMessages.isEmpty()) {
                    throw new NotificationSendException("Failed to close server connection after message failures", ex, failedMessages);
                }
                throw new NotificationException("Failed to close server connection after message sending", ex);
            }
        }
        if (!failedMessages.isEmpty()) {
            throw new NotificationSendException(failedMessages);
        }
    }

    private int addRecipient(MimeMessage mimeMsg, MailMessage mailMsg) throws MessagingException {
        int recipients = 0;
        for (InternetAddress to : mailMsg.getTo()) {
            mimeMsg.addRecipient(Message.RecipientType.TO, (Address)to);
            ++recipients;
        }
        for (InternetAddress cc : mailMsg.getCc()) {
            mimeMsg.addRecipient(Message.RecipientType.CC, (Address)cc);
            ++recipients;
        }
        for (InternetAddress bcc : mailMsg.getBcc()) {
            mimeMsg.addRecipient(Message.RecipientType.BCC, (Address)bcc);
            ++recipients;
        }
        return recipients;
    }

    public Properties getJavaMailProperties() {
        return this.javaMailProperties;
    }

    public void setJavaMailProperties(Properties javaMailProperties) {
        this.javaMailProperties = javaMailProperties;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public void setSession(Session session) {
        this.session = session;
    }
}

