/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.notification.mail;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.mail.internet.InternetAddress;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Assert;
import org.beangle.commons.lang.Strings;
import org.beangle.notification.AbstractMessage;
import org.beangle.notification.mail.MimeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailMessage
extends AbstractMessage {
    private InternetAddress from = null;
    private List<InternetAddress> to = CollectUtils.newArrayList();
    private List<InternetAddress> cc = CollectUtils.newArrayList();
    private List<InternetAddress> bcc = CollectUtils.newArrayList();
    private Date sentAt;

    public MailMessage() {
    }

    public String getEncoding() {
        return Strings.substringAfter((String)this.getContentType(), (String)"charset=");
    }

    @Override
    public List<String> getRecipients() {
        ArrayList<String> recipients = new ArrayList<String>();
        for (InternetAddress address : this.to) {
            recipients.add(address.toString());
        }
        for (InternetAddress address : this.cc) {
            recipients.add(address.toString());
        }
        for (InternetAddress address : this.bcc) {
            recipients.add(address.toString());
        }
        return recipients;
    }

    public MailMessage(String subject, String text, String sendTo) {
        this.to = MimeUtils.parseAddress(sendTo, this.getEncoding());
        this.setSubject(subject);
        this.setText(text);
    }

    public MailMessage(String subject, String text, String sendTo, String sendCc, String sendBcc) {
        this.to = MimeUtils.parseAddress(sendTo, this.getEncoding());
        this.cc = MimeUtils.parseAddress(sendCc, this.getEncoding());
        this.bcc = MimeUtils.parseAddress(sendBcc, this.getEncoding());
        this.setSubject(subject);
        this.setText(text);
    }

    public List<InternetAddress> getTo() {
        return this.to;
    }

    public List<InternetAddress> getCc() {
        return this.cc;
    }

    public List<InternetAddress> getBcc() {
        return this.bcc;
    }

    public MailMessage from(String from) {
        List<InternetAddress> froms = MimeUtils.parseAddress(from, this.getEncoding());
        if (froms.size() > 0) {
            this.from = froms.get(0);
        }
        return this;
    }

    public InternetAddress getFrom() {
        return this.from;
    }

    public void addTo(String sendTo) {
        Assert.notNull((Object)sendTo);
        this.to.addAll(MimeUtils.parseAddress(sendTo, this.getEncoding()));
    }

    public void addCc(String sendCc) {
        Assert.notNull((Object)sendCc);
        this.cc.addAll(MimeUtils.parseAddress(sendCc, this.getEncoding()));
    }

    public void addBcc(String sendBcc) {
        Assert.notNull((Object)sendBcc);
        this.bcc.addAll(MimeUtils.parseAddress(sendBcc, this.getEncoding()));
    }

    public Date getSentAt() {
        return this.sentAt;
    }

    public void setSentAt(Date sendAt) {
        this.sentAt = sendAt;
    }
}

