/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.notification.msn;

import org.beangle.notification.Message;
import org.beangle.notification.NotificationException;
import org.beangle.notification.Notifier;
import org.codehaus.plexus.msn.MsnClient;
import org.codehaus.plexus.msn.MsnException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MsnNotifier
implements Notifier<Message> {
    private MsnClient msnClient;

    public String getType() {
        return "msn";
    }

    public void deliver(Message msg) throws NotificationException {
        try {
            this.msnClient.login();
            for (String recipient : msg.getRecipients()) {
                this.msnClient.sendMessage(recipient, msg.getText());
            }
        }
        catch (MsnException e) {
            throw new RuntimeException("Exception while sending message.", e);
        }
        finally {
            try {
                this.msnClient.logout();
            }
            catch (MsnException e) {}
        }
    }

    public MsnClient getMsnClient() {
        return this.msnClient;
    }

    public void setMsnClient(MsnClient msnClient) {
        this.msnClient = msnClient;
    }
}

