/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.otk.captcha.core.image;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.security.SecureRandom;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import org.beangle.otk.captcha.core.CaptchaException;
import org.beangle.otk.captcha.core.image.ChangeableAttributedString$;
import org.beangle.otk.captcha.core.image.ColorGenerator;
import scala.Function1;
import scala.Predef$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class ChangeableAttributedString {
    private final Graphics2D g2;
    private final AttributedString[] aStrings;
    private final Rectangle2D[] bounds;
    private final LineMetrics[] metrics;
    private int kerning;
    private final SecureRandom myRandom;

    public static ChangeableAttributedString apply(Graphics2D graphics2D, AttributedString attributedString, int n) {
        return ChangeableAttributedString$.MODULE$.apply(graphics2D, attributedString, n);
    }

    public ChangeableAttributedString(Graphics2D g2, AttributedString[] aStrings, Rectangle2D[] bounds, LineMetrics[] metrics, int kerning) {
        this.g2 = g2;
        this.aStrings = aStrings;
        this.bounds = bounds;
        this.metrics = metrics;
        this.kerning = kerning;
        this.myRandom = new SecureRandom();
    }

    public Graphics2D g2() {
        return this.g2;
    }

    public int kerning() {
        return this.kerning;
    }

    public void kerning_$eq(int x$1) {
        this.kerning = x$1;
    }

    public void drawString(Graphics2D g2) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.length()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> g2.drawString(this.getIterator(i), (float)this.getX(i), (float)this.getY(i)));
    }

    public void drawString(Graphics2D g2, ColorGenerator colorGenerator) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.length()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            g2.setColor(colorGenerator.next());
            g2.drawString(this.getIterator(i), (float)this.getX(i), (float)this.getY(i));
        });
    }

    public Point2D moveToRandomSpot(BufferedImage background) {
        return this.moveToRandomSpot(background, null);
    }

    private Point2D moveToRandomSpot(BufferedImage background, Point2D startingPoint) {
        int maxHeight = (int)this.getMaxHeight();
        double maxX = (double)background.getWidth() - this.getTotalWidth() - 10.0;
        double maxY = background.getHeight() - maxHeight - 5;
        int newY = 0;
        newY = startingPoint == null ? (int)this.getMaxAscent() + this.myRandom.nextInt(Math.max(1, (int)maxY)) : (int)(startingPoint.getY() + (double)this.myRandom.nextInt(10));
        if (maxX < 0.0 || maxY < 0.0) {
            String problem = "too tall:";
            if (maxX < 0.0 && maxY > 0.0) {
                problem = "too long:";
                this.useMinimumSpacing(this.kerning() / 2);
                maxX = (double)background.getWidth() - this.getTotalWidth();
                if (maxX < 0.0) {
                    this.useMinimumSpacing(0.0);
                    maxX = (double)background.getWidth() - this.getTotalWidth();
                    if (maxX < 0.0) {
                        maxX = this.reduceHorizontalSpacing(background.getWidth(), 0.05);
                    }
                }
                if (maxX > 0.0) {
                    this.moveTo(0.0, newY);
                    return new Point2D.Float(0.0f, newY);
                }
            }
            throw new CaptchaException("word is " + problem + " try to use less letters, smaller font or bigger background:  text bounds = " + this + " with fonts " + this.getFontListing() + " versus image width = " + background.getWidth() + ", height = " + background.getHeight());
        }
        int newX = 0;
        newX = startingPoint == null ? this.myRandom.nextInt(Math.max(1, (int)maxX)) : (int)(startingPoint.getX() + (double)this.myRandom.nextInt(10));
        this.moveTo(newX, newY);
        return new Point2D.Float(newX, newY);
    }

    private String getFontListing() {
        StringBuffer buf = new StringBuffer();
        String RS = "\n\t";
        buf.append("{");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.length()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            AttributedCharacterIterator iter = this.aStrings[i].getIterator();
            Font font = (Font)iter.getAttribute(TextAttribute.FONT);
            if (font != null) {
                buf.append(font.toString()).append("\n\t");
            }
        });
        buf.append("}");
        return buf.toString();
    }

    public void useMonospacing(double kerning) {
        double maxWidth = this.getMaxWidth();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.bounds.length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.getBounds(i).setRect(this.getX(i - 1) + maxWidth + kerning, this.getY(i), this.getWidth(i), this.getHeight(i)));
    }

    public void useMinimumSpacing(double kerning) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.length()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.bounds[i].setRect(this.bounds[i - 1].getX() + this.bounds[i - 1].getWidth() + kerning, this.bounds[i].getY(), this.bounds[i].getWidth(), this.bounds[i].getHeight()));
    }

    private double reduceHorizontalSpacing(int imageWidth, double maxReductionPct) {
        double stepSize;
        double d;
        double maxX = (double)imageWidth - this.getTotalWidth();
        DoubleRef pct = DoubleRef.create((double)0.0);
        pct.elem = d = (stepSize = maxReductionPct / 25.0);
        while (pct.elem < maxReductionPct && maxX < 0.0) {
            double d2;
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.length()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.bounds[i].setRect((1.0 - pct$1.elem) * this.bounds[i].getX(), this.bounds[i].getY(), this.bounds[i].getWidth(), this.bounds[i].getHeight()));
            maxX = (double)imageWidth - this.getTotalWidth();
            pct.elem = d2 = pct.elem + stepSize;
        }
        return maxX;
    }

    private void moveTo(double newX, double newY) {
        this.bounds[0].setRect(newX, newY, this.bounds[0].getWidth(), this.bounds[0].getHeight());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.length()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.bounds[i].setRect(newX + this.bounds[i].getX(), newY, this.bounds[i].getWidth(), this.bounds[i].getHeight()));
    }

    public void shiftBoundariesToNonLinearLayout(double backgroundWidth, double backgroundHeight) {
        double newX = backgroundWidth / 20.0;
        double middleY = backgroundHeight / 2.0;
        SecureRandom myRandom = new SecureRandom();
        this.bounds[0].setRect(newX, middleY, this.bounds[0].getWidth(), this.bounds[0].getHeight());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.length()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            double characterHeight = this.bounds[i].getHeight();
            double randomY = (double)myRandom.nextInt() % (backgroundHeight / 4.0);
            double currentY = middleY + (myRandom.nextBoolean() ? randomY : -randomY) + characterHeight / 4.0;
            this.bounds[i].setRect(newX + this.bounds[i].getX(), currentY, this.bounds[i].getWidth(), this.bounds[i].getHeight());
        });
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{text=");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.length()).foreach((Function1 & Serializable)i -> this.toString$$anonfun$1(buf, BoxesRunTime.unboxToInt((Object)i)));
        String RS = "\n\t";
        buf.append("\n\t");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.length()).foreach((Function1 & Serializable)i -> this.toString$$anonfun$2(buf, BoxesRunTime.unboxToInt((Object)i)));
        buf.append("}");
        return buf.toString();
    }

    public int length() {
        return this.bounds.length;
    }

    public double getX(int index) {
        return this.getBounds(index).getX();
    }

    public double getY(int index) {
        return this.getBounds(index).getY();
    }

    public double getHeight(int index) {
        return this.getBounds(index).getHeight();
    }

    public double getTotalWidth() {
        return this.getX(this.length() - 1) + this.getWidth(this.length() - 1);
    }

    public double getWidth(int index) {
        return this.getBounds(index).getWidth();
    }

    public double getAscent(int index) {
        return this.getMetric(index).getAscent();
    }

    private double getDescent(int index) {
        return this.getMetric(index).getDescent();
    }

    public double getMaxWidth() {
        DoubleRef maxWidth = DoubleRef.create((double)-1.0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.bounds.length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            double w = this.getWidth(i);
            if (maxWidth$2.elem < w) {
                double d;
                maxWidth$2.elem = d = w;
            }
        });
        return maxWidth.elem;
    }

    public double getMaxAscent() {
        DoubleRef maxAscent = DoubleRef.create((double)-1.0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.bounds.length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            double a = this.getAscent(i);
            if (maxAscent$1.elem < a) {
                double d;
                maxAscent$1.elem = d = a;
            }
        });
        return maxAscent.elem;
    }

    public double getMaxDescent() {
        DoubleRef maxDescent = DoubleRef.create((double)-1.0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.bounds.length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            double d = this.getDescent(i);
            if (maxDescent$1.elem < d) {
                double d2;
                maxDescent$1.elem = d2 = d;
            }
        });
        return maxDescent.elem;
    }

    public double getMaxHeight() {
        DoubleRef maxHeight = DoubleRef.create((double)-1.0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.bounds.length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            double h = this.getHeight(i);
            if (maxHeight$1.elem < h) {
                double d;
                maxHeight$1.elem = d = h;
            }
        });
        return maxHeight.elem;
    }

    public double getMaxX() {
        return this.getX(0) + this.getTotalWidth();
    }

    public double getMaxY() {
        return this.getY(0) + this.getMaxHeight();
    }

    public Rectangle2D getBounds(int index) {
        return this.bounds[index];
    }

    public LineMetrics getMetric(int index) {
        return this.metrics[index];
    }

    public AttributedCharacterIterator getIterator(int i) {
        return this.aStrings[i].getIterator();
    }

    private final /* synthetic */ StringBuffer toString$$anonfun$1(StringBuffer buf$2, int i) {
        return buf$2.append(this.aStrings[i].getIterator().current());
    }

    private final /* synthetic */ StringBuffer toString$$anonfun$2(StringBuffer buf$3, int i) {
        buf$3.append(this.bounds[i].toString());
        String FS = " ";
        LineMetrics m = this.metrics[i];
        buf$3.append(" ascent=").append(m.getAscent()).append(" ");
        buf$3.append("descent=").append(m.getDescent()).append(" ");
        buf$3.append("leading=").append(m.getLeading()).append(" ");
        return buf$3.append("\n\t");
    }
}

