/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.otk.captcha.core.image;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.SecureRandom;
import javax.imageio.ImageIO;
import org.beangle.otk.captcha.core.Captcha;
import org.beangle.otk.captcha.core.Captcha$;
import org.beangle.otk.captcha.core.CaptchaEngine;
import org.beangle.otk.captcha.core.image.GmailEngine$;
import org.beangle.otk.captcha.core.image.WordToImage;
import org.beangle.otk.captcha.core.word.WordGenerator;
import scala.MatchError;
import scala.Predef$;

public class GmailEngine
implements CaptchaEngine<InputStream, String> {
    private final WordGenerator generator;
    private final WordToImage wordToImage;
    private final SecureRandom myRandom;

    public static GmailEngine image() {
        return GmailEngine$.MODULE$.image();
    }

    public GmailEngine(WordGenerator generator, WordToImage wordToImage) {
        this.generator = generator;
        this.wordToImage = wordToImage;
        this.myRandom = new SecureRandom();
    }

    public WordGenerator generator() {
        return this.generator;
    }

    public WordToImage wordToImage() {
        return this.wordToImage;
    }

    @Override
    public final Captcha<InputStream, String> next() {
        Integer wordLength = this.getRandomLength();
        String word = this.generator().getWord(Predef$.MODULE$.Integer2int(wordLength));
        BufferedImage image = this.wordToImage().getImage(word);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "JPEG", os);
        return Captcha$.MODULE$.apply(new ByteArrayInputStream(os.toByteArray()), word);
    }

    @Override
    public boolean validate(String answer, String response) {
        boolean bl;
        String string = response;
        if (string == null) {
            bl = false;
        } else if (string != null) {
            String r;
            String string2 = r = string;
            String string3 = answer;
            bl = !(string2 != null ? !string2.equals(string3) : string3 != null);
        } else {
            throw new MatchError((Object)string);
        }
        return bl;
    }

    public Integer getRandomLength() {
        WordToImage wtoi = this.wordToImage();
        int range = wtoi.maxAcceptedWordLength() - wtoi.minAcceptedWordLength();
        int randomRange = range != 0 ? this.myRandom.nextInt(range + 1) : 0;
        return Predef$.MODULE$.int2Integer(randomRange + wtoi.minAcceptedWordLength());
    }
}

