/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.otk.captcha.core.image;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.text.AttributedString;
import org.beangle.otk.captcha.core.CaptchaException;
import org.beangle.otk.captcha.core.image.BackgroundGenerator;
import org.beangle.otk.captcha.core.image.FontGenerator;
import org.beangle.otk.captcha.core.image.TextPaster;
import org.beangle.otk.captcha.core.image.WordToImage;
import scala.Function1;
import scala.Predef$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public abstract class AbstractWordToImage
implements WordToImage {
    private final FontGenerator fontGenerator;
    private final BackgroundGenerator backgroundGenerator;
    private final TextPaster textPaster;

    public AbstractWordToImage(FontGenerator fontGenerator, BackgroundGenerator backgroundGenerator, TextPaster textPaster) {
        this.fontGenerator = fontGenerator;
        this.backgroundGenerator = backgroundGenerator;
        this.textPaster = textPaster;
    }

    @Override
    public BufferedImage getImage(String word) {
        AttributedString aword = this.getAttributedString(word, this.checkWordLength(word));
        BufferedImage background = this.backgroundGenerator.next();
        return this.pasteText(background, aword);
    }

    /*
     * WARNING - void declaration
     */
    public AttributedString getAttributedString(String word, int wordLength) {
        void var3_3;
        AttributedString attributedWord = new AttributedString(word);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), wordLength).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Font font = this.fontGenerator.next();
            attributedWord.addAttribute(TextAttribute.FONT, font, i, i + 1);
        });
        return var3_3;
    }

    public int checkWordLength(String word) {
        if (word == null) {
            throw new CaptchaException("null word");
        }
        int wordLength = word.length();
        if (wordLength > this.textPaster.maxAcceptedWordLength() || wordLength < this.textPaster.minAcceptedWordLength()) {
            throw new CaptchaException("invalid length word");
        }
        return wordLength;
    }

    @Override
    public int minAcceptedWordLength() {
        return this.textPaster.minAcceptedWordLength();
    }

    @Override
    public int maxAcceptedWordLength() {
        return this.textPaster.maxAcceptedWordLength();
    }

    public BufferedImage pasteText(BufferedImage background, AttributedString attributedWord) {
        return this.textPaster.pasteText(background, attributedWord);
    }
}

