/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.otk.captcha.core.image;

import java.awt.Color;
import java.security.SecureRandom;
import org.beangle.otk.captcha.core.image.ColorGenerator$;

public interface ColorGenerator {
    public static ColorGenerator random(Color[] colorArray) {
        return ColorGenerator$.MODULE$.random(colorArray);
    }

    public Color next();

    public static class Random
    implements ColorGenerator {
        private final Color[] colorsList;
        private final SecureRandom random;

        public Random(Color[] colorsList) {
            this.colorsList = colorsList;
            this.random = new SecureRandom();
        }

        public Color[] colorsList() {
            return this.colorsList;
        }

        @Override
        public Color next() {
            int index = this.random.nextInt(this.colorsList().length);
            return this.colorsList()[index];
        }
    }

    public static class Single
    implements ColorGenerator {
        private final Color color;

        public Single(Color color) {
            this.color = color;
        }

        public Color color() {
            return this.color;
        }

        @Override
        public Color next() {
            return this.color();
        }
    }
}

