/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.otk.captcha.core.service;

import org.beangle.commons.logging.Logging;
import org.beangle.otk.captcha.core.Captcha;
import org.beangle.otk.captcha.core.CaptchaEngine;
import org.beangle.otk.captcha.core.service.CaptchaService;
import org.beangle.otk.captcha.core.service.CaptchaStore;
import org.slf4j.Logger;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.Statics;

public class DefaultCaptchaService<C, A>
implements CaptchaService<C, A>,
Logging {
    private Logger logger;
    private final CaptchaStore store;
    private final CaptchaEngine engine;

    public DefaultCaptchaService(CaptchaStore<A> store, CaptchaEngine<C, A> engine) {
        this.store = store;
        this.engine = engine;
        Logging.$init$((Logging)this);
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public CaptchaStore<A> store() {
        return this.store;
    }

    public CaptchaEngine<C, A> engine() {
        return this.engine;
    }

    @Override
    public C getChallenge(String id) {
        Captcha<C, A> captcha = this.engine().next();
        this.store().put(id, captcha.answer());
        return captcha.challenge();
    }

    @Override
    public boolean validateResponse(String id, A response, boolean removeAfterCheck) {
        boolean bl;
        Option<A> option = this.store().get(id);
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            Object answer = ((Some)option).value();
            if (removeAfterCheck) {
                this.store().remove(id);
            }
            bl = this.engine().validate(answer, response);
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    @Override
    public boolean validateResponse$default$3() {
        return true;
    }
}

