/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.otk.captcha.core.image;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.text.AttributedString;
import org.beangle.otk.captcha.core.CaptchaException;
import org.beangle.otk.captcha.core.image.BackgroundGenerator;
import org.beangle.otk.captcha.core.image.FontGenerator;
import org.beangle.otk.captcha.core.image.TextPaster;
import org.beangle.otk.captcha.core.image.WordToImage;
import scala.Function1;
import scala.Predef$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public abstract class AbstractWordToImage
implements WordToImage {
    private final FontGenerator fontGenerator;
    private final BackgroundGenerator backgroundGenerator;
    private final TextPaster textPaster;
    private final int minAcceptedWordLength;
    private final int maxAcceptedWordLength;

    public AbstractWordToImage(FontGenerator fontGenerator, BackgroundGenerator backgroundGenerator, TextPaster textPaster, int minAcceptedWordLength, int maxAcceptedWordLength) {
        this.fontGenerator = fontGenerator;
        this.backgroundGenerator = backgroundGenerator;
        this.textPaster = textPaster;
        this.minAcceptedWordLength = minAcceptedWordLength;
        this.maxAcceptedWordLength = maxAcceptedWordLength;
        Predef$.MODULE$.require(minAcceptedWordLength < maxAcceptedWordLength && minAcceptedWordLength > 0);
    }

    @Override
    public int minAcceptedWordLength() {
        return this.minAcceptedWordLength;
    }

    @Override
    public int maxAcceptedWordLength() {
        return this.maxAcceptedWordLength;
    }

    @Override
    public BufferedImage getImage(String word) {
        AttributedString aword = this.getAttributedString(word, this.checkWordLength(word));
        BufferedImage background = this.backgroundGenerator.next();
        return this.pasteText(background, aword);
    }

    /*
     * WARNING - void declaration
     */
    public AttributedString getAttributedString(String word, int wordLength) {
        void var3_3;
        AttributedString attributedWord = new AttributedString(word);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), wordLength).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Font font = this.fontGenerator.next();
            attributedWord.addAttribute(TextAttribute.FONT, font, i, i + 1);
        });
        return var3_3;
    }

    public int checkWordLength(String word) {
        if (word == null) {
            throw new CaptchaException("null word");
        }
        int wordLength = word.length();
        if (wordLength > this.maxAcceptedWordLength() || wordLength < this.minAcceptedWordLength()) {
            throw new CaptchaException("invalid length word");
        }
        return wordLength;
    }

    public BufferedImage pasteText(BufferedImage background, AttributedString attributedWord) {
        return this.textPaster.pasteText(background, attributedWord);
    }
}

