/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.otk.code.web.action;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.beangle.commons.lang.Charsets$;
import org.beangle.commons.net.http.HttpUtils$;
import org.beangle.commons.net.http.Response;
import org.beangle.otk.code.web.helper.RangeChecker$;
import org.beangle.web.action.annotation.mapping;
import org.beangle.web.action.annotation.param;
import org.beangle.web.action.support.ActionSupport;
import org.beangle.web.action.view.Stream$;
import org.beangle.web.action.view.View;
import scala.Function1;
import scala.Predef$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class QrWS
extends ActionSupport {
    private final HashMap hints = new HashMap();

    public QrWS() {
        this.hints().put(EncodeHintType.CHARACTER_SET, "utf-8");
        this.hints().put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        this.hints().put(EncodeHintType.MARGIN, BoxesRunTime.boxToInteger((int)2));
    }

    public HashMap<EncodeHintType, Object> hints() {
        return this.hints;
    }

    @mapping(value="{content}")
    public View index(@param(value="content") String content) {
        int size = RangeChecker$.MODULE$.check(this.getInt("size"), 100, 500, 300);
        String decoded = URLDecoder.decode(content, Charsets$.MODULE$.UTF_8());
        BitMatrix bitMatrix = new MultiFormatWriter().encode(decoded, BarcodeFormat.QR_CODE, size, size, (Map)this.hints());
        BufferedImage image = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
        this.get("logo").foreach((Function1)(JProcedure1 & Serializable)url -> {
            Response rs = HttpUtils$.MODULE$.getData(url, HttpUtils$.MODULE$.getData$default$2());
            if (rs.isOk()) {
                this.addLogo(image, (byte[])rs.content());
                return;
            }
        });
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "PNG", os);
        return Stream$.MODULE$.apply((InputStream)new ByteArrayInputStream(os.toByteArray()), "image/png", "qrcode.png", Stream$.MODULE$.apply$default$4());
    }

    private void addLogo(BufferedImage qrImg, byte[] logoBytes) {
        try {
            BufferedImage logo = ImageIO.read(new ByteArrayInputStream(logoBytes));
            float logoSize = 0.15f;
            Graphics2D g = qrImg.createGraphics();
            int logoWidth = (float)logo.getWidth(null) > (float)qrImg.getWidth() * logoSize ? (int)((float)qrImg.getWidth() * logoSize) : logo.getWidth(null);
            int logoHeight = (float)logo.getHeight(null) > (float)qrImg.getHeight() * logoSize ? (int)((float)qrImg.getHeight() * logoSize) : logo.getHeight(null);
            int x = (qrImg.getWidth() - logoWidth) / 2;
            int y = (qrImg.getHeight() - logoHeight) / 2;
            g.drawImage(logo, x, y, logoWidth, logoHeight, null);
            g.drawRoundRect(x, y, logoWidth, logoHeight, 15, 15);
            g.setStroke(new BasicStroke(2.0f));
            g.setColor(Color.WHITE);
            g.drawRect(x, y, logoWidth, logoHeight);
            g.dispose();
            logo.flush();
            qrImg.flush();
        }
        catch (Throwable e) {
            Predef$.MODULE$.println((Object)e.getMessage());
        }
    }
}

