/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.otk.captcha.core.service;

import java.util.HashMap;
import org.beangle.commons.cache.Cache;
import scala.Option;
import scala.Option$;

public interface CaptchaStore<A> {
    public boolean exists(String var1);

    public void put(String var1, A var2);

    public boolean remove(String var1);

    public Option<A> get(String var1);

    public static class CacheStore<A>
    implements CaptchaStore<A> {
        private final Cache<String, A> cache;

        public CacheStore(Cache<String, A> cache) {
            this.cache = cache;
        }

        @Override
        public boolean exists(String id) {
            return this.cache.exists((Object)id);
        }

        @Override
        public void put(String id, A response) {
            this.cache.put((Object)id, response);
        }

        @Override
        public boolean remove(String id) {
            return this.cache.evict((Object)id);
        }

        @Override
        public Option<A> get(String id) {
            return this.cache.get((Object)id);
        }
    }

    public static final class MemoryStore<A>
    implements CaptchaStore<A> {
        private final HashMap<String, A> store = new HashMap();

        @Override
        public boolean exists(String id) {
            return this.store.containsKey(id);
        }

        @Override
        public void put(String id, A response) {
            this.store.put(id, response);
        }

        @Override
        public boolean remove(String id) {
            return this.store.remove(id) != null;
        }

        @Override
        public Option<A> get(String id) {
            return Option$.MODULE$.apply(this.store.get(id));
        }
    }
}

