/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.otk.captcha.core.word;

import java.io.Serializable;
import java.security.SecureRandom;
import org.beangle.otk.captcha.core.word.DictionaryReader;
import org.beangle.otk.captcha.core.word.WordGenerator$;
import org.beangle.otk.captcha.core.word.WordGenerator$Random$;
import org.beangle.otk.captcha.core.word.WordList;
import scala.Function1;
import scala.Predef$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public interface WordGenerator {
    public String getWord(int var1);

    public static class ComposeDictionary
    extends Dictionary {
        public ComposeDictionary(DictionaryReader reader) {
            super(reader);
        }

        @Override
        public String getWord(int length) {
            if (length <= 2) {
                return (String)this.words().next(length).getOrElse(() -> WordGenerator$.org$beangle$otk$captcha$core$word$WordGenerator$ComposeDictionary$$_$getWord$$anonfun$2(length));
            }
            int firstLength = length / 2;
            ObjectRef firstWord = ObjectRef.create(null);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(firstLength), 50).withFilter((Function1)((JFunction1.mcZI.sp & Serializable)arg_0 -> WordGenerator$.org$beangle$otk$captcha$core$word$WordGenerator$ComposeDictionary$$_$getWord$$anonfun$3(firstWord, arg_0))).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.words().next(firstLength + i).foreach((Function1)((JProcedure1 & Serializable)arg_0 -> WordGenerator$.org$beangle$otk$captcha$core$word$WordGenerator$ComposeDictionary$$_$getWord$$anonfun$4$$anonfun$1(firstWord, firstLength, arg_0))));
            ObjectRef secondWord = ObjectRef.create(null);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(firstLength), 50).withFilter((Function1)((JFunction1.mcZI.sp & Serializable)arg_0 -> WordGenerator$.org$beangle$otk$captcha$core$word$WordGenerator$ComposeDictionary$$_$getWord$$anonfun$5(secondWord, arg_0))).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.words().next(length - firstLength + i).foreach((Function1)((JProcedure1 & Serializable)arg_0 -> WordGenerator$.org$beangle$otk$captcha$core$word$WordGenerator$ComposeDictionary$$_$getWord$$anonfun$6$$anonfun$1(secondWord, length, firstLength, arg_0))));
            return this.checkAndFindSmaller((String)firstWord.elem, firstLength) + this.checkAndFindSmaller((String)secondWord.elem, length - firstLength);
        }

        private String checkAndFindSmaller(String firstWord, int length) {
            if (firstWord == null) {
                return this.getWord(length);
            }
            return firstWord;
        }
    }

    public static class Dictionary
    implements WordGenerator {
        private final WordList words;

        public Dictionary(DictionaryReader reader) {
            this.words = reader.read();
        }

        public WordList words() {
            return this.words;
        }

        @Override
        public String getWord(int length) {
            return (String)this.words().next(length).getOrElse(() -> WordGenerator$.org$beangle$otk$captcha$core$word$WordGenerator$Dictionary$$_$getWord$$anonfun$1(length));
        }
    }

    public static class Random
    implements WordGenerator {
        private final String acceptedChars;
        private final char[] possiblesChars;
        private final SecureRandom myRandom;

        public static String $lessinit$greater$default$1() {
            return WordGenerator$Random$.MODULE$.$lessinit$greater$default$1();
        }

        public Random(String acceptedChars) {
            this.acceptedChars = acceptedChars;
            this.possiblesChars = acceptedChars.toCharArray();
            this.myRandom = new SecureRandom();
        }

        public String acceptedChars() {
            return this.acceptedChars;
        }

        @Override
        public String getWord(int length) {
            StringBuffer word = new StringBuffer(length);
            for (int i = 0; i < length; ++i) {
                word.append(this.possiblesChars[this.myRandom.nextInt(this.possiblesChars.length)]);
            }
            return word.toString();
        }
    }
}

