/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.caldav.util;

import java.util.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.property.DateProperty;
import org.apache.log4j.Logger;

public class TimeRange {
    private DateTime start;
    private DateTime end;
    private DateTime startExpanded;
    private DateTime endExpanded;
    private String tzid;
    private static Dur oneDayForward = new Dur(1, 0, 0, 0);
    private static Dur oneDayBack = new Dur(-1, 0, 0, 0);

    public TimeRange(DateTime start, DateTime end) {
        this.start = start;
        this.end = end;
        if (start != null) {
            this.startExpanded = this.inc(start, oneDayBack);
        }
        if (end != null) {
            this.endExpanded = this.inc(end, oneDayForward);
        }
    }

    private DateTime inc(DateTime dt, Dur dur) {
        Date jdt = dur.getTime((Date)dt);
        return new DateTime(jdt);
    }

    public DateTime getStart() {
        return this.start;
    }

    public DateTime getEnd() {
        return this.end;
    }

    public DateTime getStartExpanded() {
        return this.startExpanded;
    }

    public DateTime getEndExpanded() {
        return this.endExpanded;
    }

    public void setTzid(String val) {
        this.tzid = val;
    }

    public String getTzid() {
        return this.tzid;
    }

    public boolean matches(Property candidate) {
        return candidate instanceof DateProperty;
    }

    public void dump(Logger log, String indent) {
        log.debug((Object)(indent + this.toString()));
    }

    protected void toStringSegment(StringBuilder sb) {
        if (this.start != null) {
            sb.append("start=");
            sb.append(this.start);
        }
        if (this.end != null) {
            if (this.start != null) {
                sb.append(" ");
            }
            sb.append("end=");
            sb.append(this.end);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<time-range ");
        this.toStringSegment(sb);
        sb.append("/>");
        return sb.toString();
    }
}

