/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.caldav.util.notifications.suggest;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.bedework.caldav.util.notifications.BaseNotificationType;
import org.bedework.caldav.util.notifications.parse.BaseNotificationParser;
import org.bedework.caldav.util.notifications.parse.Parser;
import org.bedework.caldav.util.notifications.suggest.SuggestNotificationType;
import org.bedework.caldav.util.notifications.suggest.SuggestResponseNotificationType;
import org.bedework.util.xml.XmlUtil;
import org.bedework.util.xml.tagdefs.AppleServerTags;
import org.bedework.util.xml.tagdefs.BedeworkServerTags;
import org.bedework.util.xml.tagdefs.WebdavTags;
import org.bedework.webdav.servlet.shared.WebdavBadRequest;
import org.bedework.webdav.servlet.shared.WebdavException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SuggestParsers {
    public static final QName acceptedTag = BedeworkServerTags.accepted;
    public static final QName commentTag = BedeworkServerTags.comment;
    public static final QName hrefTag = WebdavTags.href;
    public static final QName nameTag = BedeworkServerTags.name;
    public static final QName suggesteeHrefTag = BedeworkServerTags.suggesteeHref;
    public static final QName suggesterHrefTag = BedeworkServerTags.suggesterHref;
    public static final QName suggestTag = BedeworkServerTags.suggest;
    public static final QName suggestReplyTag = BedeworkServerTags.suggestReply;
    public static final QName uidTag = AppleServerTags.uid;

    public static Document parseXmlString(String val) throws WebdavException {
        if (val == null || val.length() == 0) {
            return null;
        }
        return SuggestParsers.parseXml(new StringReader(val));
    }

    public static Document parseXml(Reader val) throws WebdavException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new InputSource(val));
        }
        catch (SAXException e) {
            throw SuggestParsers.parseException(e);
        }
        catch (Throwable t) {
            throw new WebdavException(t);
        }
    }

    public SuggestNotificationType parseSuggest(String val) throws WebdavException {
        Document d = SuggestParsers.parseXmlString(val);
        return this.parseSuggest(d.getDocumentElement());
    }

    public SuggestNotificationType parseSuggest(Node nd) throws WebdavException {
        try {
            Element[] els;
            if (!XmlUtil.nodeMatches((Node)nd, (QName)suggestTag)) {
                throw new WebdavBadRequest("Expected " + suggestTag);
            }
            SuggestNotificationType snt = new SuggestNotificationType();
            for (Element curnode : els = XmlUtil.getElementsArray((Node)nd)) {
                if (XmlUtil.nodeMatches((Node)curnode, (QName)nameTag)) {
                    snt.setName(XmlUtil.getElementContent((Element)curnode));
                    continue;
                }
                if (XmlUtil.nodeMatches((Node)curnode, (QName)uidTag)) {
                    snt.setUid(XmlUtil.getElementContent((Element)curnode));
                    continue;
                }
                if (XmlUtil.nodeMatches((Node)curnode, (QName)hrefTag)) {
                    snt.setHref(XmlUtil.getElementContent((Element)curnode));
                    continue;
                }
                if (XmlUtil.nodeMatches((Node)curnode, (QName)suggesteeHrefTag)) {
                    snt.setSuggesteeHref(XmlUtil.getElementContent((Element)curnode));
                    continue;
                }
                if (XmlUtil.nodeMatches((Node)curnode, (QName)suggesterHrefTag)) {
                    snt.setSuggesterHref(XmlUtil.getElementContent((Element)curnode));
                    continue;
                }
                if (XmlUtil.nodeMatches((Node)curnode, (QName)commentTag)) {
                    snt.setComment(XmlUtil.getElementContent((Element)curnode));
                    continue;
                }
                throw new WebdavBadRequest("Unexpected element " + curnode);
            }
            return snt;
        }
        catch (SAXException e) {
            throw SuggestParsers.parseException(e);
        }
        catch (WebdavException wde) {
            throw wde;
        }
        catch (Throwable t) {
            throw new WebdavException(t);
        }
    }

    public SuggestResponseNotificationType parseSuggestReply(Node nd) throws WebdavException {
        try {
            Element[] els;
            if (!XmlUtil.nodeMatches((Node)nd, (QName)suggestReplyTag)) {
                throw new WebdavBadRequest("Expected " + suggestReplyTag);
            }
            SuggestResponseNotificationType srnt = new SuggestResponseNotificationType();
            for (Element curnode : els = XmlUtil.getElementsArray((Node)nd)) {
                if (XmlUtil.nodeMatches((Node)curnode, (QName)nameTag)) {
                    srnt.setName(XmlUtil.getElementContent((Element)curnode));
                    continue;
                }
                if (XmlUtil.nodeMatches((Node)curnode, (QName)uidTag)) {
                    srnt.setUid(XmlUtil.getElementContent((Element)curnode));
                    continue;
                }
                if (XmlUtil.nodeMatches((Node)curnode, (QName)hrefTag)) {
                    srnt.setHref(XmlUtil.getElementContent((Element)curnode));
                    continue;
                }
                if (XmlUtil.nodeMatches((Node)curnode, (QName)suggesteeHrefTag)) {
                    srnt.setSuggesteeHref(XmlUtil.getElementContent((Element)curnode));
                    continue;
                }
                if (XmlUtil.nodeMatches((Node)curnode, (QName)suggesterHrefTag)) {
                    srnt.setSuggesterHref(XmlUtil.getElementContent((Element)curnode));
                    continue;
                }
                if (XmlUtil.nodeMatches((Node)curnode, (QName)commentTag)) {
                    srnt.setComment(XmlUtil.getElementContent((Element)curnode));
                    continue;
                }
                if (XmlUtil.nodeMatches((Node)curnode, (QName)acceptedTag)) {
                    srnt.setAccepted(Boolean.parseBoolean(XmlUtil.getElementContent((Element)curnode)));
                    continue;
                }
                throw new WebdavBadRequest("Unexpected element " + curnode);
            }
            return srnt;
        }
        catch (SAXException e) {
            throw SuggestParsers.parseException(e);
        }
        catch (WebdavException wde) {
            throw wde;
        }
        catch (Throwable t) {
            throw new WebdavException(t);
        }
    }

    private static WebdavException parseException(SAXException e) throws WebdavException {
        Logger log = SuggestParsers.getLog();
        if (log.isDebugEnabled()) {
            log.error((Object)"Parse error:", (Throwable)e);
        }
        return new WebdavBadRequest();
    }

    private static Logger getLog() {
        return Logger.getLogger(SuggestParsers.class);
    }

    static {
        Parser.register(new SuggestParser());
        Parser.register(new SuggestReplyParser());
    }

    static class SuggestReplyParser
    extends SuggestionParser {
        SuggestReplyParser() {
            super(suggestReplyTag);
        }

        @Override
        public BaseNotificationType parse(Element nd) throws WebdavException {
            try {
                SuggestResponseNotificationType suggestResponseNotificationType = this.getParser().parseSuggestReply(nd);
                return suggestResponseNotificationType;
            }
            finally {
                this.putParser();
            }
        }
    }

    static class SuggestParser
    extends SuggestionParser {
        SuggestParser() {
            super(suggestTag);
        }

        @Override
        public BaseNotificationType parse(Element nd) throws WebdavException {
            try {
                SuggestNotificationType suggestNotificationType = this.getParser().parseSuggest(nd);
                return suggestNotificationType;
            }
            finally {
                this.putParser();
            }
        }
    }

    private static abstract class SuggestionParser
    implements BaseNotificationParser {
        private static final int maxPoolSize = 10;
        private final List<SuggestParsers> parsers = new ArrayList<SuggestParsers>();
        protected SuggestParsers parser;
        protected QName element;

        protected SuggestionParser(QName element) {
            this.element = element;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SuggestParsers getParser() {
            if (this.parser != null) {
                return this.parser;
            }
            List<SuggestParsers> list = this.parsers;
            synchronized (list) {
                if (this.parsers.size() > 0) {
                    this.parser = this.parsers.remove(0);
                    return this.parser;
                }
                this.parser = new SuggestParsers();
                this.parsers.add(this.parser);
                return this.parser;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void putParser() {
            List<SuggestParsers> list = this.parsers;
            synchronized (list) {
                if (this.parsers.size() >= 10) {
                    return;
                }
                this.parsers.add(this.parser);
            }
        }

        @Override
        public QName getElement() {
            return this.element;
        }
    }
}

