/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.caldav.util;

import ietf.params.xml.ns.caldav.CalendarDataType;
import ietf.params.xml.ns.caldav.CompFilterType;
import ietf.params.xml.ns.caldav.CompType;
import ietf.params.xml.ns.caldav.FilterType;
import ietf.params.xml.ns.caldav.ParamFilterType;
import ietf.params.xml.ns.caldav.PropFilterType;
import ietf.params.xml.ns.caldav.PropType;
import ietf.params.xml.ns.caldav.TextMatchType;
import ietf.params.xml.ns.caldav.UTCTimeRangeType;
import org.bedework.util.logging.BwLogger;

public class DumpUtil {
    private static final BwLogger logger = new BwLogger().setLoggedClass(DumpUtil.class);

    public static void dumpCalendarData(CalendarDataType cd) {
        StringBuilder sb = new StringBuilder("  <calendar-data");
        if (cd.getContentType() != null) {
            sb.append("  content-type=\"");
            sb.append(cd.getContentType());
            sb.append("\"");
        }
        sb.append(">");
        logger.debug(sb.toString());
        if (cd.getComp() != null) {
            DumpUtil.dumpComp(cd.getComp(), "    ");
        }
        if (cd.getExpand() != null) {
            DumpUtil.dumpUTCTimeRange((UTCTimeRangeType)cd.getExpand(), "expand", "    ");
        }
        if (cd.getLimitRecurrenceSet() != null) {
            DumpUtil.dumpUTCTimeRange((UTCTimeRangeType)cd.getLimitRecurrenceSet(), "limit-recurrence-set", "    ");
        }
        if (cd.getLimitFreebusySet() != null) {
            DumpUtil.dumpUTCTimeRange((UTCTimeRangeType)cd.getLimitFreebusySet(), "limit-freebusy-set", "    ");
        }
        logger.debug("  </calendar-data>");
    }

    public static void dumpComp(CompType comp, String indent) {
        StringBuilder sb = new StringBuilder(indent);
        sb.append("<comp name=");
        sb.append(comp.getName());
        sb.append(">");
        logger.debug(sb.toString());
        if (comp.getAllcomp() != null) {
            logger.debug(indent + "  <allcomp/>");
        } else {
            for (CompType c : comp.getComp()) {
                DumpUtil.dumpComp(c, indent + "  ");
            }
        }
        if (comp.getAllprop() != null) {
            logger.debug(indent + "  <allprop/>");
        } else {
            for (PropType prop : comp.getProp()) {
                DumpUtil.dumpProp(prop, indent + "  ");
            }
        }
        logger.debug(indent + "</comp>");
    }

    public static void dumpProp(PropType prop, String indent) {
        StringBuilder sb = new StringBuilder(indent);
        sb.append("<calddav:prop name=");
        sb.append(prop.getName());
        sb.append(" novalue=");
        sb.append(prop.getNovalue());
        sb.append("/>");
        logger.debug(sb.toString());
    }

    public static void dumpUTCTimeRange(UTCTimeRangeType tr, String name, String indent) {
        StringBuilder sb = new StringBuilder(indent);
        sb.append("<");
        sb.append(name);
        sb.append(" ");
        if (tr.getStart() != null) {
            sb.append("start=");
            sb.append(tr.getStart());
        }
        if (tr.getEnd() != null) {
            if (tr.getStart() != null) {
                sb.append(" ");
            }
            sb.append("end=");
            sb.append(tr.getEnd());
        }
        sb.append("/>");
        logger.debug(sb.toString());
    }

    public static void dumpFilter(FilterType f) {
        logger.debug("<filter>");
        DumpUtil.dumpCompFilter(f.getCompFilter(), "  ");
        logger.debug("</filter>");
    }

    public static void dumpCompFilter(CompFilterType cf, String indent) {
        StringBuilder sb = new StringBuilder(indent);
        sb.append("<comp-filter name=\"");
        sb.append(cf.getName());
        sb.append("\">");
        logger.debug(sb.toString());
        if (cf.getIsNotDefined() != null) {
            logger.debug(indent + "  <is-not-defined/>");
        } else if (cf.getTimeRange() != null) {
            DumpUtil.dumpUTCTimeRange(cf.getTimeRange(), "time-range", indent + "  ");
        }
        if (cf.getCompFilter() != null) {
            for (CompFilterType subcf : cf.getCompFilter()) {
                DumpUtil.dumpCompFilter(subcf, indent + "  ");
            }
        }
        if (cf.getPropFilter() != null) {
            for (PropFilterType pf : cf.getPropFilter()) {
                DumpUtil.dumpPropFilter(pf, indent + "  ");
            }
        }
        logger.debug(indent + "</comp-filter>");
    }

    public static void dumpPropFilter(PropFilterType pf, String indent) {
        StringBuilder sb = new StringBuilder(indent);
        sb.append("<prop-filter name=\"");
        sb.append(pf.getName());
        sb.append("\">\n");
        logger.debug(sb.toString());
        if (pf.getIsNotDefined() != null) {
            logger.debug(indent + "  <is-not-defined/>\n");
        } else if (pf.getTimeRange() != null) {
            DumpUtil.dumpUTCTimeRange(pf.getTimeRange(), "time-range", indent + "  ");
        } else if (pf.getTextMatch() != null) {
            DumpUtil.dumpTextMatch(pf.getTextMatch(), indent + "  ");
        }
        if (pf.getParamFilter() != null) {
            for (ParamFilterType parf : pf.getParamFilter()) {
                DumpUtil.dumpParamFilter(parf, indent + "  ");
            }
        }
        logger.debug(indent + "</prop-filter>");
    }

    public static void dumpParamFilter(ParamFilterType pf, String indent) {
        StringBuilder sb = new StringBuilder(indent);
        sb.append("<param-filter name=\"");
        sb.append(pf.getName());
        sb.append(">\n");
        logger.debug(sb.toString());
        if (pf.getIsNotDefined() != null) {
            logger.debug(indent + "  <is-not-defined/>\n");
        } else {
            DumpUtil.dumpTextMatch(pf.getTextMatch(), indent + "  ");
        }
        logger.debug(indent + "</param-filter>");
    }

    public static void dumpTextMatch(TextMatchType tm, String indent) {
        StringBuilder sb = new StringBuilder(indent);
        sb.append("<text-match");
        sb.append(" collation=");
        sb.append(tm.getCollation());
        sb.append(" negate-condition=");
        sb.append(tm.getNegateCondition());
        sb.append(">");
        logger.debug(sb.toString());
        logger.debug(tm.getValue());
        logger.debug(indent + "</text-match>\n");
    }
}

