/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.convert.jscal;

import java.util.Arrays;
import java.util.List;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Duration;
import org.bedework.calfacade.BwAlarm;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.BwContact;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.ifs.IcalCallback;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calfacade.util.ChangeTable;
import org.bedework.convert.CnvUtil;
import org.bedework.convert.Icalendar;
import org.bedework.convert.ical.IcalUtil;
import org.bedework.jsforj.impl.values.dataTypes.JSLocalDateTimeImpl;
import org.bedework.jsforj.impl.values.dataTypes.JSUTCDateTimeImpl;
import org.bedework.jsforj.model.DateTimeComponents;
import org.bedework.jsforj.model.JSCalendarObject;
import org.bedework.jsforj.model.JSProperty;
import org.bedework.jsforj.model.values.JSAbsoluteTrigger;
import org.bedework.jsforj.model.values.JSAlert;
import org.bedework.jsforj.model.values.JSLink;
import org.bedework.jsforj.model.values.JSOffsetTrigger;
import org.bedework.jsforj.model.values.JSParticipant;
import org.bedework.jsforj.model.values.JSRoles;
import org.bedework.jsforj.model.values.JSTrigger;
import org.bedework.jsforj.model.values.JSValue;
import org.bedework.jsforj.model.values.collections.JSAlerts;
import org.bedework.jsforj.model.values.collections.JSLinks;
import org.bedework.jsforj.model.values.collections.JSList;
import org.bedework.jsforj.model.values.collections.JSParticipants;
import org.bedework.jsforj.model.values.collections.JSSendTo;
import org.bedework.jsforj.model.values.dataTypes.JSLocalDateTime;
import org.bedework.jsforj.model.values.dataTypes.JSString;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.misc.Util;
import org.bedework.util.misc.response.GetEntityResponse;
import org.bedework.util.misc.response.Response;
import org.bedework.util.timezones.Timezones;

public class JsCal2BwEvent {
    private static final BwLogger logger = new BwLogger().setLoggedClass(JsCal2BwEvent.class);
    private static final List<String> attendeeRoles = Arrays.asList("attendee", "optional", "informational", "chair");

    public static GetEntityResponse<EventInfo> toEvent(IcalCallback cb, JSCalendarObject val, BwCalendar col, Icalendar ical) {
        String icalEvstart;
        String evStart;
        int entityType;
        String jstype;
        GetEntityResponse resp = new GetEntityResponse();
        if (val == null) {
            return (GetEntityResponse)Response.notOk((Response)resp, (Response.Status)Response.Status.failed, (String)"No entity supplied");
        }
        switch (jstype = val.getType()) {
            case "Event": {
                entityType = 0;
                break;
            }
            case "Task": {
                entityType = 2;
                break;
            }
            default: {
                return (GetEntityResponse)Response.error((Response)resp, (String)("org.bedework.invalid.component.type: " + jstype));
            }
        }
        BwDateTime ridObj = null;
        String rid = null;
        String guid = val.getUid();
        if (guid == null) {
            return (GetEntityResponse)Response.notOk((Response)resp, (Response.Status)Response.Status.failed, (String)"org.bedework.exception.ical.noguid");
        }
        boolean dtOnlyP = val.getBooleanProperty("showWithoutTime");
        JSLocalDateTime jsrid = val.getRecurrenceId();
        if (jsrid != null) {
            IcalDate icalDate = new IcalDate(jsrid.getStringValue());
            ridObj = BwDateTime.makeBwDateTime((boolean)dtOnlyP, (String)icalDate.format(dtOnlyP), (String)val.getStringProperty("recurrenceIdTimeZone"));
            rid = ridObj.getDate();
        }
        if ((evStart = val.getStringProperty("start")) != null) {
            IcalDate icalDate = new IcalDate(evStart);
            icalEvstart = icalDate.format(dtOnlyP);
        } else {
            if (ridObj == null) {
                return (GetEntityResponse)Response.notOk((Response)resp, (Response.Status)Response.Status.failed, (String)"org.bedework.error.invalid.override");
            }
            icalEvstart = ridObj.getDtval();
        }
        GetEntityResponse<CnvUtil.RetrievedEvents> ger = CnvUtil.retrieveEvent(cb, guid, rid, entityType, col, ical, icalEvstart, val.getStringProperty("recurrenceIdTimeZone"), logger);
        if (!ger.isOk()) {
            return (GetEntityResponse)Response.fromResponse((Response)resp, ger);
        }
        EventInfo masterEI = ((CnvUtil.RetrievedEvents)ger.getEntity()).masterEI;
        EventInfo evinfo = ((CnvUtil.RetrievedEvents)ger.getEntity()).evinfo;
        BwEvent ev = evinfo.getEvent();
        ChangeTable chg = evinfo.getChangeset(cb.getPrincipal().getPrincipalRef());
        if (rid != null) {
            String evrid = evinfo.getEvent().getRecurrenceId();
            if (evrid == null || !evrid.equals(rid)) {
                logger.warn("Mismatched rid ev=" + evrid + " expected " + rid);
                chg.changed(PropertyIndex.PropertyInfoIndex.RECURRENCE_ID, (Object)evrid, (Object)rid);
            }
            if (masterEI.getEvent().getSuppressed()) {
                masterEI.getEvent().addRdate(ridObj);
            }
        }
        ev.setEntityType(entityType);
        ev.setCreatorHref(cb.getPrincipal().getPrincipalRef());
        ev.setOwnerHref(cb.getOwner().getPrincipalRef());
        JsCal2BwEvent.setValues((GetEntityResponse<EventInfo>)resp, cb, chg, ridObj, evinfo, val);
        chg.processChanges(ev, true, false);
        resp.setEntity((Object)evinfo);
        return (GetEntityResponse)Response.ok((Response)resp);
    }

    private static void setValues(GetEntityResponse<EventInfo> resp, IcalCallback cb, ChangeTable chg, BwDateTime recurrenceId, EventInfo ei, JSCalendarObject val) {
        BwEvent ev = ei.getEvent();
        if (!JsCal2BwEvent.doAlarms(resp, cb, chg, ev, val.getAlerts(false))) {
            return;
        }
        if (!JsCal2BwEvent.doCategories(resp, cb, chg, ev, (JSList<String>)val.getCategories(false))) {
            return;
        }
        if (val.hasProperty("color")) {
            String color = val.getColor();
            if (chg.changed(PropertyIndex.PropertyInfoIndex.COLOR, (Object)ev.getColor(), (Object)color)) {
                ev.setColor(color);
            }
        }
        if (!JsCal2BwEvent.doCreated(resp, cb, chg, ev, val.getStringProperty("created"))) {
            return;
        }
        if (!JsCal2BwEvent.setDates(resp, cb, val, ei, recurrenceId)) {
            return;
        }
        if (val.hasProperty("description")) {
            String desc = val.getDescription();
            if (chg.changed(PropertyIndex.PropertyInfoIndex.DESCRIPTION, (Object)ev.getDescription(), (Object)desc)) {
                ev.setDescription(desc);
            }
        }
        if (val.hasProperty("estimatedDuration")) {
            String estd = val.getStringProperty("estimatedDuration");
            if (chg.changed(PropertyIndex.PropertyInfoIndex.ESTIMATED_DURATION, (Object)ev.getEstimatedDuration(), (Object)estd)) {
                ev.setEstimatedDuration(estd);
            }
        }
        if (!JsCal2BwEvent.doKeywords(resp, cb, chg, ev, (JSList<String>)val.getKeywords(false))) {
            return;
        }
        if (!JsCal2BwEvent.doLinks(resp, cb, chg, ev, val.getLinks(false))) {
            return;
        }
        if (!JsCal2BwEvent.doParticipants(resp, cb, chg, ev, val.getParticipants(false))) {
            return;
        }
        if (chg.changed(PropertyIndex.PropertyInfoIndex.SUMMARY, (Object)ev.getSummary(), (Object)val.getTitle())) {
            ev.setSummary(val.getTitle());
        }
        ev.setRecurring(Boolean.valueOf(false));
        block52: for (JSProperty prop : val.getProperties()) {
            String pname = prop.getName();
            JSValue pval = prop.getValue();
            switch (pname) {
                case "entries": {
                    continue block52;
                }
                case "excluded": {
                    continue block52;
                }
                case "freeBusyStatus": {
                    continue block52;
                }
                case "locale": {
                    continue block52;
                }
                case "localizations": {
                    continue block52;
                }
                case "locations": {
                    continue block52;
                }
                case "method": {
                    continue block52;
                }
                case "priority": {
                    continue block52;
                }
                case "privacy": {
                    continue block52;
                }
                case "prodId": {
                    continue block52;
                }
                case "progress": {
                    continue block52;
                }
                case "progressUpdated": {
                    continue block52;
                }
                case "recurrenceRules": {
                    continue block52;
                }
                case "relatedTo": {
                    continue block52;
                }
                case "replyTo": {
                    continue block52;
                }
                case "sequence": {
                    continue block52;
                }
                case "source": {
                    continue block52;
                }
                case "status": {
                    continue block52;
                }
                case "timeZone": {
                    continue block52;
                }
                case "timeZones": {
                    continue block52;
                }
                case "title": {
                    continue block52;
                }
                case "updated": {
                    continue block52;
                }
                case "useDefaultAlerts": {
                    continue block52;
                }
                case "virtualLocations": {
                    continue block52;
                }
            }
            logger.warn("Unknown property: " + pname);
        }
    }

    private static boolean doAlarms(GetEntityResponse<EventInfo> resp, IcalCallback cb, ChangeTable chg, BwEvent ev, JSAlerts value) {
        if (value == null) {
            return true;
        }
        for (JSProperty alertp : value.get()) {
            BwAlarm al;
            JSAlert alert = (JSAlert)alertp.getValue();
            String action = alert.getAction();
            BwAlarm.TriggerVal tr = JsCal2BwEvent.getTrigger(alert.getTrigger());
            String summary = alert.getTitle();
            String desc = alert.getDescription();
            if (summary == null) {
                summary = ev.getSummary();
            }
            if (desc == null) {
                desc = ev.getDescription();
            }
            if ("display".equals(action)) {
                al = BwAlarm.displayAlarm((String)ev.getCreatorHref(), (BwAlarm.TriggerVal)tr, null, (int)0, (String)summary);
            } else {
                if (!"email".equals(action)) continue;
                if (desc == null) {
                    desc = summary;
                }
                al = BwAlarm.emailAlarm((String)ev.getCreatorHref(), (BwAlarm.TriggerVal)tr, null, (int)0, null, (String)desc, (String)summary, null);
            }
            chg.addValue(PropertyIndex.PropertyInfoIndex.VALARM, (Object)al);
        }
        return true;
    }

    public static BwAlarm.TriggerVal getTrigger(JSTrigger val) {
        BwAlarm.TriggerVal tr = new BwAlarm.TriggerVal();
        if (val instanceof JSAbsoluteTrigger) {
            JSAbsoluteTrigger absTrigger = (JSAbsoluteTrigger)val;
            IcalDate icalDate = new IcalDate(absTrigger.getWhen().getStringValue());
            tr.trigger = icalDate.format(false);
            tr.triggerDateTime = true;
            return tr;
        }
        if (!(val instanceof JSOffsetTrigger)) {
            return tr;
        }
        JSOffsetTrigger offsetTrigger = (JSOffsetTrigger)val;
        String rel = offsetTrigger.getRelativeTo();
        tr.triggerStart = rel == null || "start".equals(rel);
        tr.trigger = offsetTrigger.getOffset().getStringValue();
        return tr;
    }

    private static boolean doCategories(GetEntityResponse<EventInfo> resp, IcalCallback cb, ChangeTable chg, BwEvent ev, JSList<String> value) {
        if (value == null) {
            return true;
        }
        for (String cval : value.get()) {
            chg.addValue(PropertyIndex.PropertyInfoIndex.XPROP, (Object)ev.makeConcept(cval));
        }
        return true;
    }

    private static boolean doKeywords(GetEntityResponse<EventInfo> resp, IcalCallback cb, ChangeTable chg, BwEvent ev, JSList<String> value) {
        if (value == null) {
            return true;
        }
        for (String kw : value.get()) {
            BwCategory cat;
            BwString key = new BwString(null, kw);
            GetEntityResponse fcResp = cb.findCategory(key);
            if (fcResp.isError()) {
                Response.fromResponse(resp, (Response)fcResp);
                return false;
            }
            if (fcResp.isNotFound()) {
                cat = BwCategory.makeCategory();
                cat.setWord(key);
                cb.addCategory(cat);
            } else {
                cat = (BwCategory)fcResp.getEntity();
            }
            chg.addValue(PropertyIndex.PropertyInfoIndex.CATEGORIES, (Object)cat);
        }
        return true;
    }

    private static boolean doLinks(GetEntityResponse<EventInfo> resp, IcalCallback cb, ChangeTable chg, BwEvent ev, JSLinks value) {
        if (value == null) {
            return true;
        }
        return true;
    }

    private static boolean doParticipants(GetEntityResponse<EventInfo> resp, IcalCallback cb, ChangeTable chg, BwEvent ev, JSParticipants value) {
        if (value == null) {
            return true;
        }
        for (String key : value.getKeys()) {
            boolean isAttendee;
            JSProperty partProp = value.get((Object)key);
            boolean processed = false;
            JSParticipant part = (JSParticipant)partProp.getValue();
            List roles = part.getRoles(true).get();
            if (roles.contains("contact")) {
                if (!JsCal2BwEvent.doContact(resp, cb, chg, ev, key, part)) {
                    return false;
                }
                processed = true;
            }
            if (!(isAttendee = attendeeRoles.stream().anyMatch(roles::contains))) continue;
            if (!JsCal2BwEvent.doAttendee(resp, cb, chg, ev, part)) {
                return false;
            }
            processed = true;
        }
        return true;
    }

    private static boolean doContact(GetEntityResponse<EventInfo> resp, IcalCallback cb, ChangeTable chg, BwEvent ev, String partKey, JSParticipant value) {
        BwContact contact;
        BwString cn = new BwString(null, value.getDescription());
        GetEntityResponse cResp = cb.findContact(cn);
        if (cResp.isError()) {
            Response.fromResponse(resp, (Response)cResp);
            return false;
        }
        JSLinks links = value.getLinks(false);
        JSLink link = null;
        if (links != null) {
            for (JSProperty linkP : links.get()) {
                JSLink l = (JSLink)linkP.getValue();
                if (!"alternate".equals(l.getRel())) continue;
                link = l;
                break;
            }
        }
        if (cResp.isOk()) {
            contact = (BwContact)cResp.getEntity();
        } else {
            contact = BwContact.makeContact();
            contact.setCn(cn);
            cb.addContact(contact);
        }
        if (link != null) {
            contact.setLink(link.getHref(false).getStringValue());
        }
        chg.addValue(PropertyIndex.PropertyInfoIndex.CONTACT, (Object)contact);
        return true;
    }

    private static boolean doAttendee(GetEntityResponse<EventInfo> resp, IcalCallback cb, ChangeTable chg, BwEvent ev, JSParticipant value) {
        JSRoles roles;
        String lang;
        String cuType;
        String calAddr = JsCal2BwEvent.getSendTo("imip", value);
        if (calAddr == null) {
            return true;
        }
        BwAttendee attendee = new BwAttendee();
        attendee.setAttendeeUri(calAddr);
        if (value.getParticipationStatus() != null) {
            attendee.setPartstat(value.getParticipationStatus().toUpperCase());
        }
        if (value.getExpectReply()) {
            attendee.setRsvp(true);
        }
        if (value.getName() != null) {
            attendee.setCn(value.getName());
        }
        if ((cuType = JsCal2BwEvent.iCalCutype(value.getKind())) != null) {
            attendee.setCuType(cuType);
        }
        JSLinks links = value.getLinks(false);
        JSLink link = null;
        if (links != null) {
            for (JSProperty linkP : links.get()) {
                JSLink l = (JSLink)linkP.getValue();
                if (!"alternate".equals(l.getRel())) continue;
                link = l;
                break;
            }
        }
        if (link != null) {
            attendee.setDir(link.getHref(false).getStringValue());
        }
        if ((lang = value.getLanguage()) != null) {
            attendee.setLanguage(lang);
        }
        if ((roles = value.getRoles(false)) != null) {
            attendee.setRole(JsCal2BwEvent.iCalRole(roles.get()));
        }
        chg.addValue(PropertyIndex.PropertyInfoIndex.ATTENDEE, (Object)attendee);
        return true;
    }

    private static String getSendTo(String key, JSParticipant value) {
        JSSendTo sendTo = value.getSendTo(false);
        if (sendTo == null) {
            return null;
        }
        JSProperty imipAddr = sendTo.get((Object)key);
        if (imipAddr == null || imipAddr.getValue() == null) {
            return null;
        }
        return ((JSString)imipAddr.getValue()).getStringValue();
    }

    private static String iCalCutype(String jsCalCutype) {
        if (jsCalCutype == null) {
            return null;
        }
        if ("location".equalsIgnoreCase(jsCalCutype)) {
            return "room";
        }
        return jsCalCutype.toUpperCase();
    }

    private static String iCalRole(List<String> roles) {
        if (Util.isEmpty(roles)) {
            return null;
        }
        boolean attendee = false;
        boolean chair = false;
        boolean optional = false;
        boolean informational = false;
        for (String val : roles) {
            switch (val.toLowerCase()) {
                case "attendee": {
                    attendee = true;
                    break;
                }
                case "chair": {
                    chair = true;
                    break;
                }
                case "optional": {
                    optional = true;
                    break;
                }
                case "informational": {
                    informational = true;
                }
            }
        }
        if (!attendee) {
            return null;
        }
        if (chair) {
            return "CHAIR";
        }
        if (optional) {
            return "OPT-PARTICIPANT";
        }
        if (informational) {
            return "NON-PARTICIPANT";
        }
        return "REQ-PARTICIPANT";
    }

    private static boolean doCreated(GetEntityResponse<EventInfo> resp, IcalCallback cb, ChangeTable chg, BwEvent ev, String value) {
        IcalDate icalDate = new IcalDate(value);
        String dt = icalDate.format(false);
        if (chg.changed(PropertyIndex.PropertyInfoIndex.CREATED, (Object)ev.getCreated(), (Object)dt)) {
            ev.setCreated(dt);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean setDates(GetEntityResponse<EventInfo> resp, IcalCallback cb, JSCalendarObject obj, EventInfo evinfo, BwDateTime recurrenceId) {
        try {
            String durStr;
            String due;
            DtStart st;
            String startTimezoneId;
            boolean dateOnly = obj.getBooleanProperty("showWithoutTime");
            if (dateOnly) {
                startTimezoneId = null;
                Object endTimezoneId = null;
            } else {
                startTimezoneId = obj.getStringProperty("timeZone");
                Object endTimezoneId = null;
            }
            TimeZone startTz = startTimezoneId != null ? Timezones.getTz((String)startTimezoneId) : null;
            String start = obj.getStringProperty("start");
            if (start == null) {
                if (recurrenceId == null) {
                    resp.setMessage("Missing start");
                    resp.setStatus(Response.Status.failed);
                    return false;
                }
                st = recurrenceId.makeDtStart();
            } else {
                IcalDate icdt = new IcalDate(start);
                st = new DtStart(icdt.format(dateOnly), startTz);
            }
            DtEnd de = null;
            if (evinfo.getEvent().getEntityType() == 2 && (due = obj.getStringProperty("due")) != null) {
                IcalDate icdt = new IcalDate(due);
                de = new DtEnd(icdt.format(dateOnly), startTz);
            }
            Duration dur = (durStr = obj.getStringProperty("duration")) != null ? new Duration(null, durStr) : null;
            IcalUtil.setDates(cb.getPrincipal().getPrincipalRef(), evinfo, st, de, dur);
            return true;
        }
        catch (Throwable t) {
            resp.setException(t);
            return false;
        }
    }

    private static class IcalDate {
        private final DateTimeComponents dtc;
        private final String utcFormat = "%04d%02d%02dT%02d%02d%02dZ";
        private final String dateTimeFormat = "%04d%02d%02dT%02d%02d%02d";
        private final String dateFormat = "%04d%02d%02d";

        IcalDate(String val) {
            boolean utc = val.endsWith("Z");
            Object dt = utc ? new JSUTCDateTimeImpl(val) : new JSLocalDateTimeImpl(val);
            this.dtc = dt.getComponents();
        }

        String format(boolean dtOnly) {
            if (this.dtc.isUtc()) {
                return String.format("%04d%02d%02dT%02d%02d%02dZ", this.dtc.getYear(), this.dtc.getMonth(), this.dtc.getDay(), this.dtc.getHours(), this.dtc.getMinutes(), this.dtc.getSeconds());
            }
            if (dtOnly) {
                return String.format("%04d%02d%02d", this.dtc.getYear(), this.dtc.getMonth(), this.dtc.getDay());
            }
            return String.format("%04d%02d%02dT%02d%02d%02d", this.dtc.getYear(), this.dtc.getMonth(), this.dtc.getDay(), this.dtc.getHours(), this.dtc.getMinutes(), this.dtc.getSeconds());
        }

        long getFractions() {
            return this.dtc.getFractional();
        }

        boolean isUtc() {
            return this.dtc.isUtc();
        }
    }
}

