/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.convert.xcal;

import ietf.params.xml.ns.icalendar_2.AltrepParamType;
import ietf.params.xml.ns.icalendar_2.ArrayOfParameters;
import ietf.params.xml.ns.icalendar_2.ArrayOfProperties;
import ietf.params.xml.ns.icalendar_2.BaseComponentType;
import ietf.params.xml.ns.icalendar_2.BasePropertyType;
import ietf.params.xml.ns.icalendar_2.DateDatetimePropertyType;
import ietf.params.xml.ns.icalendar_2.IcalendarType;
import ietf.params.xml.ns.icalendar_2.LanguageParamType;
import ietf.params.xml.ns.icalendar_2.MethodPropType;
import ietf.params.xml.ns.icalendar_2.ObjectFactory;
import ietf.params.xml.ns.icalendar_2.ProdidPropType;
import ietf.params.xml.ns.icalendar_2.TzidParamType;
import ietf.params.xml.ns.icalendar_2.VcalendarType;
import ietf.params.xml.ns.icalendar_2.VersionPropType;
import ietf.params.xml.ns.icalendar_2.XBedeworkExsynchEndtzidPropType;
import ietf.params.xml.ns.icalendar_2.XBedeworkExsynchLastmodPropType;
import ietf.params.xml.ns.icalendar_2.XBedeworkExsynchStarttzidPropType;
import ietf.params.xml.ns.icalendar_2.XBedeworkMaxTicketsPerUserPropType;
import ietf.params.xml.ns.icalendar_2.XBedeworkMaxTicketsPropType;
import ietf.params.xml.ns.icalendar_2.XBedeworkRegistrationEndPropType;
import ietf.params.xml.ns.icalendar_2.XBedeworkRegistrationStartPropType;
import ietf.params.xml.ns.icalendar_2.XBedeworkUidParamType;
import ietf.params.xml.ns.icalendar_2.XBedeworkWaitListLimitPropType;
import ietf.params.xml.ns.icalendar_2.XBedeworkWrappedNameParamType;
import ietf.params.xml.ns.icalendar_2.XBedeworkWrapperPropType;
import ietf.params.xml.ns.icalendar_2.XBwCategoriesPropType;
import ietf.params.xml.ns.icalendar_2.XBwContactPropType;
import ietf.params.xml.ns.icalendar_2.XBwLocationPropType;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBElement;
import net.fortuna.ical4j.model.NumberList;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwXproperty;
import org.bedework.calfacade.base.BwStringBase;
import org.bedework.util.calendar.ScheduleMethods;
import org.bedework.util.calendar.XcalUtil;
import org.bedework.util.logging.BwLogger;

public class Xutil {
    private static final BwLogger logger = new BwLogger().setLoggedClass(Xutil.class);
    protected static ObjectFactory of = new ObjectFactory();

    protected static void listFromNumberList(List<String> l, NumberList nl) {
        if (nl == null) {
            return;
        }
        for (Object o : nl) {
            l.add((String)o);
        }
    }

    protected static void intlistFromNumberList(List<Integer> l, NumberList nl) {
        if (nl == null) {
            return;
        }
        for (Object o : nl) {
            l.add(Integer.valueOf((String)o));
        }
    }

    protected static void bigintlistFromNumberList(List<BigInteger> l, NumberList nl) {
        if (nl == null) {
            return;
        }
        for (Object o : nl) {
            l.add(BigInteger.valueOf(Integer.parseInt((String)o)));
        }
    }

    protected static BasePropertyType tzidProp(BasePropertyType prop, String val) {
        if (val == null) {
            return prop;
        }
        ArrayOfParameters pars = Xutil.getAop(prop);
        TzidParamType tzid = new TzidParamType();
        tzid.setText(val);
        JAXBElement t = of.createTzid(tzid);
        pars.getBaseParameter().add(t);
        return prop;
    }

    protected static BasePropertyType altrepProp(BasePropertyType prop, String val) {
        if (val == null) {
            return prop;
        }
        ArrayOfParameters pars = Xutil.getAop(prop);
        AltrepParamType a = new AltrepParamType();
        a.setUri(val);
        JAXBElement param = of.createAltrep(a);
        pars.getBaseParameter().add(param);
        return prop;
    }

    protected static BasePropertyType uidProp(BasePropertyType prop, String uid) {
        if (uid == null) {
            return prop;
        }
        ArrayOfParameters pars = Xutil.getAop(prop);
        XBedeworkUidParamType x = new XBedeworkUidParamType();
        x.setText(uid);
        JAXBElement param = of.createXBedeworkUid(x);
        pars.getBaseParameter().add(param);
        return prop;
    }

    protected static BasePropertyType langProp(BasePropertyType prop, BwStringBase<?> s) {
        String lang = s.getLang();
        if (lang == null) {
            return prop;
        }
        ArrayOfParameters pars = Xutil.getAop(prop);
        LanguageParamType l = new LanguageParamType();
        l.setText(lang);
        JAXBElement param = of.createLanguage(l);
        pars.getBaseParameter().add(param);
        return prop;
    }

    protected static ArrayOfParameters getAop(BasePropertyType prop) {
        ArrayOfParameters pars = prop.getParameters();
        if (pars == null) {
            pars = new ArrayOfParameters();
            prop.setParameters(pars);
        }
        return pars;
    }

    protected static DateDatetimePropertyType makeDateDatetime(DateDatetimePropertyType p, BwDateTime dt, boolean forceUTC) {
        String dtval = forceUTC ? dt.getDate() : (!dt.getDateType() ? dt.getDtval() : dt.getDtval().substring(0, 8));
        XcalUtil.initDt((DateDatetimePropertyType)p, (String)dtval, (String)dt.getTzid());
        return p;
    }

    public static IcalendarType initCalendar(String prodId, int methodType) {
        IcalendarType ical = new IcalendarType();
        VcalendarType vcal = new VcalendarType();
        ical.getVcalendar().add(vcal);
        vcal.setProperties(new ArrayOfProperties());
        List pl = vcal.getProperties().getBasePropertyOrTzid();
        ProdidPropType prod = new ProdidPropType();
        prod.setText(prodId);
        pl.add(of.createProdid(prod));
        VersionPropType vers = new VersionPropType();
        vers.setText("2.0");
        pl.add(of.createVersion(vers));
        if (methodType > 0 && methodType < 99) {
            MethodPropType m = new MethodPropType();
            m.setText(ScheduleMethods.methods[methodType]);
            pl.add(of.createMethod(m));
        }
        return ical;
    }

    public static void xpropertiesToXcal(List<JAXBElement<? extends BasePropertyType>> pl, List<BwXproperty> xprops, BaseComponentType pattern, Class<?> masterClass, boolean wrapXprops) {
        for (BwXproperty x : xprops) {
            Object tzid;
            XBedeworkExsynchEndtzidPropType p;
            String xname = x.getName();
            String val = x.getValue();
            if (xname.startsWith("X-BEDEWORK-TZ-")) continue;
            if (xname.equals("X-BEDEWORK-EXSYNCH-ENDTZID")) {
                if (!Xutil.emit(pattern, masterClass, XBedeworkExsynchEndtzidPropType.class)) continue;
                p = new XBedeworkExsynchEndtzidPropType();
                p.setText(val);
                pl.add((JAXBElement<? extends BasePropertyType>)of.createXBedeworkExsynchEndtzid(p));
                continue;
            }
            if (xname.equals("X-BEDEWORK-EXSYNCH-LASTMOD")) {
                if (!Xutil.emit(pattern, masterClass, XBedeworkExsynchLastmodPropType.class)) continue;
                p = new XBedeworkExsynchLastmodPropType();
                p.setText(val);
                pl.add((JAXBElement<? extends BasePropertyType>)of.createXBedeworkExsynchLastmod((XBedeworkExsynchLastmodPropType)p));
                continue;
            }
            if (xname.equals("X-BEDEWORK-EXSYNCH-ORGANIZER")) continue;
            if (xname.equals("X-BEDEWORK-EXSYNCH-STARTTZID")) {
                if (!Xutil.emit(pattern, masterClass, XBedeworkExsynchStarttzidPropType.class)) continue;
                p = new XBedeworkExsynchStarttzidPropType();
                p.setText(val);
                pl.add((JAXBElement<? extends BasePropertyType>)of.createXBedeworkExsynchStarttzid((XBedeworkExsynchStarttzidPropType)p));
                continue;
            }
            if (xname.equals("X-BEDEWORK-REGISTRATION-START")) {
                if (!Xutil.emit(pattern, masterClass, XBedeworkRegistrationStartPropType.class)) continue;
                p = new XBedeworkRegistrationStartPropType();
                tzid = null;
                for (BwXproperty.Xpar xp : x.getParameters()) {
                    if (!xp.getName().equalsIgnoreCase("TZID")) continue;
                    tzid = xp.getValue();
                    break;
                }
                XcalUtil.initDt((DateDatetimePropertyType)p, (String)val, tzid);
                pl.add((JAXBElement<? extends BasePropertyType>)of.createXBedeworkRegistrationStart((XBedeworkRegistrationStartPropType)p));
                continue;
            }
            if (xname.equals("X-BEDEWORK-REGISTRATION-END")) {
                if (!Xutil.emit(pattern, masterClass, XBedeworkRegistrationEndPropType.class)) continue;
                p = new XBedeworkRegistrationEndPropType();
                tzid = null;
                for (BwXproperty.Xpar xp : x.getParameters()) {
                    if (!xp.getName().equalsIgnoreCase("TZID")) continue;
                    tzid = xp.getValue();
                    break;
                }
                XcalUtil.initDt((DateDatetimePropertyType)p, (String)val, tzid);
                pl.add((JAXBElement<? extends BasePropertyType>)of.createXBedeworkRegistrationEnd((XBedeworkRegistrationEndPropType)p));
                continue;
            }
            if (xname.equals("X-BEDEWORK-MAX-TICKETS")) {
                if (!Xutil.emit(pattern, masterClass, XBedeworkMaxTicketsPropType.class)) continue;
                p = new XBedeworkMaxTicketsPropType();
                p.setInteger(BigInteger.valueOf(Long.parseLong(val.trim())));
                pl.add((JAXBElement<? extends BasePropertyType>)of.createXBedeworkMaxTickets((XBedeworkMaxTicketsPropType)p));
                continue;
            }
            if (xname.equals("X-BEDEWORK-MAX-TICKETS-PER-USER")) {
                if (!Xutil.emit(pattern, masterClass, XBedeworkMaxTicketsPerUserPropType.class)) continue;
                p = new XBedeworkMaxTicketsPerUserPropType();
                p.setInteger(BigInteger.valueOf(Long.parseLong(val.trim())));
                pl.add((JAXBElement<? extends BasePropertyType>)of.createXBedeworkMaxTicketsPerUser((XBedeworkMaxTicketsPerUserPropType)p));
                continue;
            }
            if (xname.equals("X-BEDEWORK-WAIT-LIST-LIMIT")) {
                if (!Xutil.emit(pattern, masterClass, XBedeworkWaitListLimitPropType.class)) continue;
                p = new XBedeworkWaitListLimitPropType();
                p.setText(val);
                pl.add((JAXBElement<? extends BasePropertyType>)of.createXBedeworkWaitListLimit((XBedeworkWaitListLimitPropType)p));
                continue;
            }
            if (xname.equals("X-BEDEWORK-CATEGORIES")) {
                if (!Xutil.emit(pattern, masterClass, XBwCategoriesPropType.class)) continue;
                p = new XBwCategoriesPropType();
                p.getText().add(val);
                pl.add((JAXBElement<? extends BasePropertyType>)of.createXBedeworkCategories((XBwCategoriesPropType)p));
                continue;
            }
            if (xname.equals("X-BEDEWORK-CONTACT")) {
                if (!Xutil.emit(pattern, masterClass, XBwContactPropType.class)) continue;
                p = new XBwContactPropType();
                p.setText(val);
                pl.add((JAXBElement<? extends BasePropertyType>)of.createXBedeworkContact((XBwContactPropType)p));
                continue;
            }
            if (xname.equals("X-BEDEWORK-LOCATION")) {
                if (!Xutil.emit(pattern, masterClass, XBwLocationPropType.class)) continue;
                p = new XBwLocationPropType();
                p.setText(val);
                pl.add((JAXBElement<? extends BasePropertyType>)of.createXBedeworkLocation((XBwLocationPropType)p));
                continue;
            }
            if (!wrapXprops) {
                if (!logger.debug()) continue;
                logger.warn("Not handing x-property " + xname);
                continue;
            }
            XBedeworkWrapperPropType wrapper = new XBedeworkWrapperPropType();
            if (x.getParameters() != null) {
                for (BwXproperty.Xpar xp : x.getParameters()) {
                    Xutil.xparam((BasePropertyType)wrapper, xp);
                }
            }
            XBedeworkWrappedNameParamType wnp = new XBedeworkWrappedNameParamType();
            wnp.setText(x.getName());
            if (wrapper.getParameters() == null) {
                wrapper.setParameters(new ArrayOfParameters());
            }
            wrapper.getParameters().getBaseParameter().add(of.createXBedeworkWrappedName(wnp));
            wrapper.setText(val);
            pl.add((JAXBElement<? extends BasePropertyType>)of.createXBedeworkWrapper(wrapper));
        }
    }

    protected static void xparam(BasePropertyType prop, BwXproperty.Xpar xp) {
        ArrayOfParameters aop = prop.getParameters();
        if (aop == null) {
            aop = new ArrayOfParameters();
            prop.setParameters(aop);
        }
        if (xp.getName().equalsIgnoreCase("tzid")) {
            TzidParamType tz = new TzidParamType();
            tz.setText(xp.getValue());
            aop.getBaseParameter().add(of.createTzid(tz));
            return;
        }
        if (xp.getName().equalsIgnoreCase("altrep")) {
            Xutil.altrepProp(prop, xp.getValue());
        }
    }

    protected static boolean emit(BaseComponentType pattern, Class<?> compCl, Class<?> ... cl) {
        if (pattern == null) {
            return true;
        }
        if (!compCl.getName().equals(pattern.getClass().getName())) {
            return false;
        }
        if (cl == null || cl.length == 0) {
            return true;
        }
        String className = cl[0].getName();
        if (BasePropertyType.class.isAssignableFrom(cl[0])) {
            if (pattern.getProperties() == null) {
                return false;
            }
            List patternProps = pattern.getProperties().getBasePropertyOrTzid();
            for (JAXBElement jp : patternProps) {
                if (!((BasePropertyType)jp.getValue()).getClass().getName().equals(className)) continue;
                return true;
            }
            return false;
        }
        List patternComps = XcalUtil.getComponents((BaseComponentType)pattern);
        if (patternComps == null) {
            return false;
        }
        for (JAXBElement jp : patternComps) {
            if (!((BaseComponentType)jp.getValue()).getClass().getName().equals(className)) continue;
            return Xutil.emit(pattern, cl[0], Arrays.copyOfRange(cl, 1, cl.length - 1));
        }
        return false;
    }
}

