/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.convert;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwGeo;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwOrganizer;
import org.bedework.calfacade.BwRelatedTo;
import org.bedework.calfacade.base.Differable;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calfacade.util.CalFacadeUtil;
import org.bedework.convert.DifferListResult;
import org.bedework.convert.DifferResult;
import org.bedework.convert.DifferSetResult;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.misc.Util;

public class BwDiffer {
    private static final BwLogger logger = new BwLogger().setLoggedClass(BwDiffer.class);

    static <T extends Comparable<T>, CT extends Collection<T>> DifferResult<T, CT> diffres(Class<T> cl, boolean differs) {
        return new DifferListResult(differs);
    }

    public static <T extends Comparable<T>, CT extends Collection<T>> DifferResult<T, CT> differs(Class<T> cl, PropertyIndex.PropertyInfoIndex pi, Object val, EventInfo master) {
        if (master == null) {
            if (!(val instanceof Collection)) {
                return BwDiffer.diffres(cl, val != null);
            }
            return BwDiffer.diffres(cl, !Util.isEmpty((Collection)((Collection)val)));
        }
        BwEvent ev = master.getEvent();
        switch (pi) {
            case UNKNOWN_PROPERTY: {
                break;
            }
            case CLASS: {
                return BwDiffer.diffres(cl, Util.cmpObjval((Comparable)((Object)((String)val)), (Comparable)((Object)ev.getClassification())) != 0);
            }
            case COMPLETED: {
                return BwDiffer.diffres(cl, Util.cmpObjval((Comparable)((Object)((String)val)), (Comparable)((Object)ev.getCompleted())) != 0);
            }
            case CREATED: {
                break;
            }
            case DESCRIPTION: {
                return BwDiffer.diffres(cl, Util.cmpObjval((Comparable)((Object)((String)val)), (Comparable)((Object)ev.getDescription())) != 0);
            }
            case DTEND: 
            case DUE: {
                BwDateTime dt = (BwDateTime)val;
                return BwDiffer.diffres(cl, !CalFacadeUtil.eqObjval((Object)ev.getDtend(), (Object)dt));
            }
            case DTSTAMP: {
                break;
            }
            case DTSTART: {
                BwDateTime dt1 = (BwDateTime)val;
                return BwDiffer.diffres(cl, !CalFacadeUtil.eqObjval((Object)ev.getDtstart(), (Object)dt1));
            }
            case DURATION: {
                return BwDiffer.diffres(cl, Util.cmpObjval((Comparable)((Object)((String)val)), (Comparable)((Object)ev.getDuration())) != 0);
            }
            case ESTIMATED_DURATION: {
                return BwDiffer.diffres(cl, Util.cmpObjval((Comparable)((Object)((String)val)), (Comparable)((Object)ev.getEstimatedDuration())) != 0);
            }
            case GEO: {
                return BwDiffer.diffres(cl, Util.cmpObjval((Comparable)((BwGeo)val), (Comparable)ev.getGeo()) != 0);
            }
            case LAST_MODIFIED: {
                break;
            }
            case LOCATION: {
                return BwDiffer.diffres(cl, Util.cmpObjval((Comparable)((BwLocation)val), (Comparable)ev.getLocation()) != 0);
            }
            case ORGANIZER: {
                BwOrganizer organizer = (BwOrganizer)val;
                return BwDiffer.diffres(cl, Util.cmpObjval((Comparable)organizer, (Comparable)ev.getOrganizer()) != 0 || organizer.differsFrom(ev.getOrganizer()));
            }
            case PRIORITY: {
                return BwDiffer.diffres(cl, Util.cmpObjval((Comparable)((Integer)val), (Comparable)ev.getPriority()) != 0);
            }
            case RECURRENCE_ID: {
                break;
            }
            case SEQUENCE: {
                return BwDiffer.diffres(cl, ((Integer)val).intValue() != ev.getSequence());
            }
            case STATUS: {
                return BwDiffer.diffres(cl, Util.cmpObjval((Comparable)((Object)((String)val)), (Comparable)((Object)ev.getStatus())) != 0);
            }
            case SUMMARY: {
                return BwDiffer.diffres(cl, Util.cmpObjval((Comparable)((Object)((String)val)), (Comparable)((Object)ev.getSummary())) != 0);
            }
            case PERCENT_COMPLETE: {
                return BwDiffer.diffres(cl, Util.cmpObjval((Comparable)((Integer)val), (Comparable)ev.getPercentComplete()) != 0);
            }
            case UID: {
                break;
            }
            case URL: {
                return BwDiffer.diffres(cl, Util.cmpObjval((Comparable)((Object)((String)val)), (Comparable)((Object)ev.getLink())) != 0);
            }
            case TRANSP: {
                return BwDiffer.diffres(cl, Util.cmpObjval((Comparable)((Object)((String)val)), (Comparable)((Object)ev.getTransparency())) != 0);
            }
            case ATTACH: {
                return BwDiffer.cmpObjval((Set)val, ev.getAttachments());
            }
            case ATTENDEE: {
                return BwDiffer.cmpObjval((Set)val, ev.getAttendees());
            }
            case CATEGORIES: {
                return BwDiffer.cmpObjval((Set)val, ev.getCategories());
            }
            case COMMENT: {
                return BwDiffer.cmpObjval((Set)val, ev.getComments());
            }
            case CONCEPT: {
                return BwDiffer.cmpObjval((List)val, ev.getConcepts());
            }
            case CONTACT: {
                return BwDiffer.cmpObjval((Set)val, ev.getContacts());
            }
            case EXDATE: {
                return BwDiffer.cmpObjval((Set)val, ev.getExdates());
            }
            case EXRULE: {
                return BwDiffer.cmpObjval((Set)val, ev.getExrules());
            }
            case REQUEST_STATUS: {
                return BwDiffer.cmpObjval((Set)val, ev.getRequestStatuses());
            }
            case RELATED_TO: {
                return BwDiffer.diffres(cl, Util.cmpObjval((Comparable)((BwRelatedTo)val), (Comparable)ev.getRelatedTo()) != 0);
            }
            case RESOURCES: {
                return BwDiffer.cmpObjval((Set)val, ev.getResources());
            }
            case RDATE: {
                return BwDiffer.cmpObjval((Set)val, ev.getRdates());
            }
            case RRULE: {
                return BwDiffer.cmpObjval((Set)val, ev.getRrules());
            }
            case VALARM: {
                return BwDiffer.cmpObjval((Set)val, ev.getAlarms());
            }
            case VLOCATION: {
                return BwDiffer.cmpObjval((List)val, ev.getVlocations());
            }
            case XPROP: {
                return BwDiffer.cmpObjval((List)val, ev.getXproperties());
            }
            case SCHEDULE_METHOD: 
            case SCHEDULE_STATE: 
            case SCHEDULE_TAG: 
            case TRIGGER_DATE_TIME: 
            case URI: 
            case FREEBUSY: 
            case TZID: 
            case TZNAME: 
            case TZOFFSETFROM: 
            case TZOFFSETTO: 
            case TZURL: 
            case ACTION: 
            case REPEAT: 
            case TRIGGER: {
                break;
            }
            case COLLECTION: 
            case COST: 
            case CREATOR: 
            case OWNER: 
            case ENTITY_TYPE: {
                break;
            }
            case LANG: 
            case TZIDPAR: {
                break;
            }
            case PUBLISH_URL: 
            case POLL_ITEM_ID: 
            case END_TYPE: 
            case ETAG: 
            case HREF: 
            case XBEDEWORK_COST: 
            case CALSCALE: 
            case METHOD: 
            case PRODID: 
            case VERSION: 
            case ACL: 
            case AFFECTS_FREE_BUSY: 
            case ALIAS_URI: 
            case ATTENDEE_SCHEDULING_OBJECT: 
            case CALTYPE: 
            case COL_PROPERTIES: 
            case COLPATH: 
            case CTOKEN: 
            case DISPLAY: 
            case DOCTYPE: 
            case EVENTREG_END: 
            case EVENTREG_MAX_TICKETS: 
            case EVENTREG_MAX_TICKETS_PER_USER: 
            case EVENTREG_START: 
            case EVENTREG_WAIT_LIST_LIMIT: 
            case FILTER_EXPR: 
            case IGNORE_TRANSP: 
            case IMAGE: 
            case INDEX_END: 
            case INDEX_START: 
            case INSTANCE: 
            case LAST_REFRESH: 
            case LAST_REFRESH_STATUS: 
            case LOCATION_HREF: 
            case LOCATION_STR: {
                break;
            }
            case CALSUITE: 
            case LASTMODSEQ: 
            case MASTER: 
            case NAME: 
            case NO_START: 
            case ORGANIZER_SCHEDULING_OBJECT: 
            case ORIGINATOR: 
            case OVERRIDE: 
            case PARAMETERS: 
            case PUBLIC: 
            case RECIPIENT: 
            case REFRESH_RATE: 
            case REMOTE_ID: 
            case REMOTE_PW: 
            case SUGGESTED_TO: 
            case TAG: 
            case TARGET: 
            case THUMBIMAGE: 
            case TOMBSTONED: 
            case TOPICAL_AREA: 
            case UNREMOVEABLE: 
            case VPATH: 
            case VIEW: 
            case X_BEDEWORK_CATEGORIES: 
            case X_BEDEWORK_CONTACT: 
            case X_BEDEWORK_LOCATION: {
                break;
            }
            default: {
                logger.warn("Not handling icalendar property " + pi);
            }
        }
        return BwDiffer.diffres(cl, false);
    }

    public static <T extends Comparable<T>, CT extends Collection<T>> DifferResult<T, CT> cmpObjval(CT to, CT from) {
        if (Util.isEmpty(to)) {
            if (Util.isEmpty(from)) {
                return new DifferResult(false);
            }
            return new DifferResult(false, null, true, null);
        }
        if (Util.isEmpty(from)) {
            return new DifferResult(true, to, false, null);
        }
        DifferResult res = to instanceof Set ? new DifferSetResult() : new DifferListResult();
        for (Comparable c : to) {
            if (from.contains(c)) continue;
            res.toAdd(c);
        }
        boolean differable = false;
        for (Comparable c : from) {
            if (!to.contains(c)) {
                res.toRemove(c);
                continue;
            }
            if (!differable && !(c instanceof Differable)) continue;
            Differable fromC = (Differable)c;
            differable = true;
            for (Comparable toC : to) {
                if (!c.equals(toC) || !fromC.differsFrom((Object)toC)) continue;
                res.doesDiffer(toC);
            }
        }
        return res;
    }
}

