/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.convert;

import ietf.params.xml.ns.icalendar_2.BaseComponentType;
import ietf.params.xml.ns.icalendar_2.IcalendarType;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import javax.xml.bind.JAXBElement;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.CalendarParser;
import net.fortuna.ical4j.data.CalendarParserImpl;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.data.UnfoldingReader;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.VAvailability;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VFreeBusy;
import net.fortuna.ical4j.model.component.VPoll;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.property.TzId;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwVersion;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.ifs.IcalCallback;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.convert.EventTimeZonesRegistry;
import org.bedework.convert.Icalendar;
import org.bedework.convert.ical.BwEvent2Ical;
import org.bedework.convert.ical.Ical2BwEvent;
import org.bedework.convert.ical.IcalMalformedException;
import org.bedework.convert.ical.IcalUtil;
import org.bedework.convert.ical.VFreeUtil;
import org.bedework.util.calendar.IcalendarUtil;
import org.bedework.util.calendar.JcalCalendarBuilder;
import org.bedework.util.calendar.WsXMLTranslator;
import org.bedework.util.calendar.XmlCalendarBuilder;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.misc.Util;
import org.bedework.util.misc.response.GetEntityResponse;
import org.bedework.util.timezones.Timezones;

public class IcalTranslator
implements Logged,
Serializable {
    protected IcalCallback cb;
    protected Pars pars = new Pars();
    private final BwLogger logger = new BwLogger();

    public IcalTranslator(IcalCallback cb) {
        this.cb = cb;
    }

    public static String freebusyToIcalString(int methodType, BwEvent ent) {
        Calendar cal = IcalendarUtil.newIcal((int)methodType, (String)BwVersion.prodId);
        if (ent.getEntityType() != 4) {
            throw new RuntimeException("Unexpected entity type");
        }
        VFreeBusy vfreeBusy = VFreeUtil.toVFreeBusy(ent);
        cal.getComponents().add((Object)vfreeBusy);
        return IcalendarUtil.toIcalString((Calendar)cal);
    }

    public Calendar toIcal(EventInfo val, int methodType) throws CalFacadeException {
        if (val == null) {
            return null;
        }
        try {
            Calendar cal = IcalendarUtil.newIcal((int)methodType, (String)BwVersion.prodId);
            this.addToCalendar(cal, val, new TreeSet<String>());
            return cal;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public Calendar toIcal(Collection<EventInfo> vals, int methodType) throws CalFacadeException {
        Calendar cal = IcalendarUtil.newIcal((int)methodType, (String)BwVersion.prodId);
        if (vals == null || vals.size() == 0) {
            return cal;
        }
        TreeSet<String> added = new TreeSet<String>();
        try {
            for (EventInfo ev : vals) {
                this.addToCalendar(cal, ev, added);
            }
            return cal;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public TimeZone tzFromTzdef(String val) throws CalFacadeException {
        StringReader sr = new StringReader(val);
        Icalendar ic = this.fromIcal(null, sr);
        if (ic == null || ic.size() != 0 || ic.getTimeZones().size() != 1) {
            if (this.debug()) {
                this.debug("Not icalendar");
            }
            throw new CalFacadeException("Not icalendar");
        }
        return ic.getTimeZones().iterator().next().tz;
    }

    public Icalendar fromIcal(BwCalendar col, Reader rdr) throws CalFacadeException {
        return this.fromIcal(col, rdr, null, false);
    }

    public Icalendar fromIcal(BwCalendar col, IcalendarType ical) throws CalFacadeException {
        Icalendar ic = new Icalendar();
        IcalTranslator.setSystemProperties();
        WsXMLTranslator bldr = new WsXMLTranslator((TimeZoneRegistry)ic);
        try {
            Calendar cal = bldr.fromXcal(ical);
            return this.makeIc(col, ic, cal, false);
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public Icalendar fromIcal(BwCalendar col, Reader rdr, String contentType, boolean mergeAttendees) throws CalFacadeException {
        try {
            Calendar cal;
            Icalendar ic = new Icalendar();
            IcalTranslator.setSystemProperties();
            if ("application/calendar+xml".equals(contentType)) {
                XmlCalendarBuilder bldr = new XmlCalendarBuilder((TimeZoneRegistry)ic);
                cal = bldr.build(rdr);
            } else if ("application/calendar+json".equals(contentType)) {
                JcalCalendarBuilder bldr = new JcalCalendarBuilder((TimeZoneRegistry)ic);
                cal = bldr.build(rdr);
            } else {
                CalendarBuilder bldr = new CalendarBuilder((CalendarParser)new CalendarParserImpl(), (TimeZoneRegistry)ic);
                UnfoldingReader ufrdr = new UnfoldingReader(rdr, true);
                cal = bldr.build(ufrdr);
            }
            return this.makeIc(col, ic, cal, mergeAttendees);
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (ParserException pe) {
            throw new IcalMalformedException(pe);
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public void addOverride(EventInfo ei, JAXBElement<? extends BaseComponentType> comp) throws CalFacadeException {
        try {
            Calendar cal = new WsXMLTranslator((TimeZoneRegistry)new Icalendar()).fromXcomp(comp);
            if (cal == null) {
                return;
            }
            Icalendar ic = new Icalendar();
            ic.addComponent(ei);
            this.makeIc(null, ic, cal, false);
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    private Icalendar makeIc(BwCalendar col, Icalendar ic, Calendar cal, boolean mergeAttendees) throws CalFacadeException {
        try {
            if (cal == null) {
                return ic;
            }
            PropertyList pl = cal.getProperties();
            Property prop = (Property)pl.getProperty("PRODID");
            if (prop != null) {
                ic.setProdid(prop.getValue());
            }
            if ((prop = (Property)pl.getProperty("VERSION")) != null) {
                ic.setVersion(prop.getValue());
            }
            ic.setMethod(IcalTranslator.getMethod(cal));
            prop = (Property)pl.getProperty("CALSCALE");
            if (prop != null) {
                ic.setCalscale(prop.getValue());
            }
            Collection<CalendarComponent> clist = IcalTranslator.orderedComponents(cal.getComponents());
            for (CalendarComponent comp : clist) {
                if (comp instanceof VTimeZone) {
                    ic.addTimeZone(this.doTimeZone((VTimeZone)comp));
                    continue;
                }
                if (!(comp instanceof VFreeBusy) && !(comp instanceof VEvent) && !(comp instanceof VToDo) && !(comp instanceof VPoll) && !(comp instanceof VAvailability)) continue;
                GetEntityResponse<EventInfo> eiResp = Ical2BwEvent.toEvent(this.cb, col, ic, (Component)comp, mergeAttendees);
                if (eiResp.isError()) {
                    if (eiResp.getException() != null) {
                        throw eiResp.getException();
                    }
                    throw new CalFacadeException(eiResp.toString());
                }
                if (!eiResp.isOk()) continue;
                ic.addComponent((EventInfo)eiResp.getEntity());
            }
            for (EventInfo ei : ic.getComponents()) {
                if (Util.isEmpty((Collection)ei.getOverrides())) continue;
                for (EventInfo rei : ei.getOverrides()) {
                    if (rei.recurrenceSeen) continue;
                    ei.removeOverride(rei.getRecurrenceId());
                }
            }
            return ic;
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public static String getMethod(Calendar val) {
        Property prop = (Property)val.getProperties().getProperty("METHOD");
        if (prop == null) {
            return null;
        }
        return prop.getValue();
    }

    private void addToCalendar(Calendar cal, EventInfo val, TreeSet<String> added) {
        try {
            String currentPrincipal = null;
            BwPrincipal principal = this.cb.getPrincipal();
            if (principal != null) {
                currentPrincipal = principal.getPrincipalRef();
            }
            BwEvent ev = val.getEvent();
            EventTimeZonesRegistry tzreg = new EventTimeZonesRegistry(this, ev);
            if (!this.cb.getTimezonesByReference()) {
                this.addIcalTimezones(cal, ev, added, tzreg);
            }
            if (!ev.getSuppressed()) {
                Object comp = ev.getEntityType() == 4 ? VFreeUtil.toVFreeBusy(ev) : BwEvent2Ical.convert(val, false, tzreg, currentPrincipal);
                cal.getComponents().add((Object)((CalendarComponent)comp));
            }
            if (val.getNumOverrides() > 0) {
                for (EventInfo oei : val.getOverrides()) {
                    cal.getComponents().add((Object)((CalendarComponent)BwEvent2Ical.convert(oei, true, tzreg, currentPrincipal)));
                }
            }
        }
        catch (CalFacadeException cfe) {
            throw new RuntimeException(cfe);
        }
    }

    private static Collection<CalendarComponent> orderedComponents(ComponentList<?> clist) {
        SubList<CalendarComponent> tzs = new SubList<CalendarComponent>();
        SubList<CalendarComponent> fbs = new SubList<CalendarComponent>();
        SubList<CalendarComponent> instances = new SubList<CalendarComponent>();
        SubList<CalendarComponent> masters = new SubList<CalendarComponent>();
        for (Object aClist : clist) {
            CalendarComponent c = (CalendarComponent)aClist;
            if (c instanceof VFreeBusy) {
                fbs.add(c);
                continue;
            }
            if (c instanceof VTimeZone) {
                tzs.add(c);
                continue;
            }
            if (IcalUtil.getProperty((Component)c, "RECURRENCE-ID") != null) {
                instances.add(c);
                continue;
            }
            masters.add(c);
        }
        ArrayList<CalendarComponent> all = new ArrayList<CalendarComponent>();
        tzs.appendTo(all);
        masters.appendTo(all);
        instances.appendTo(all);
        fbs.appendTo(all);
        return all;
    }

    private Icalendar.TimeZoneInfo doTimeZone(VTimeZone vtz) {
        TzId tzid = vtz.getTimeZoneId();
        if (tzid == null) {
            throw new RuntimeException("Missing tzid property");
        }
        String id = tzid.getValue();
        try {
            TimeZone tz = Timezones.getTz((String)id);
            String tzSpec = null;
            if (tz == null) {
                tz = new TimeZone(vtz);
                tzSpec = vtz.toString();
            }
            return new Icalendar.TimeZoneInfo(id, tz, tzSpec);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected void addIcalTimezones(Calendar cal, Collection<EventInfo> vals) {
        TreeSet<String> added = new TreeSet<String>();
        for (EventInfo o : vals) {
            if (!(o instanceof EventInfo)) continue;
            EventInfo ei = o;
            BwEvent ev = ei.getEvent();
            if (!ev.getSuppressed()) {
                this.addIcalTimezones(cal, ev, added, new EventTimeZonesRegistry(this, ev));
            }
            if (ei.getNumOverrides() <= 0) continue;
            for (EventInfo oei : ei.getOverrides()) {
                ev = oei.getEvent();
                this.addIcalTimezones(cal, ev, added, new EventTimeZonesRegistry(this, ev));
            }
        }
    }

    private void addIcalTimezones(Calendar cal, BwEvent ev, TreeSet<String> added, TimeZoneRegistry tzreg) {
        if (ev.getEntityType() == 4) {
            return;
        }
        if (!ev.getForceUTC()) {
            IcalendarUtil.addIcalTimezone((Calendar)cal, (String)ev.getDtstart().getTzid(), added, (TimeZoneRegistry)tzreg);
            if (ev.getEndType() == 'E') {
                IcalendarUtil.addIcalTimezone((Calendar)cal, (String)ev.getDtend().getTzid(), added, (TimeZoneRegistry)tzreg);
            }
        }
    }

    protected static void setSystemProperties() {
        try {
            System.setProperty("ical4j.unfolding.relaxed", "true");
            System.setProperty("ical4j.parsing.relaxed", "true");
            System.setProperty("ical4j.compatibility.outlook", "true");
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }

    public static class Pars {
        public boolean simpleLocation = true;
        public boolean simpleContact = true;
    }

    private static class SubList<T> {
        ArrayList<T> list;

        private SubList() {
        }

        void add(T o) {
            if (this.list == null) {
                this.list = new ArrayList();
            }
            this.list.add(o);
        }

        void appendTo(Collection<T> c) {
            if (this.list != null) {
                c.addAll(this.list);
            }
        }
    }
}

