/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.convert.ical;

import java.net.URI;
import java.text.ParseException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.TextList;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.component.Available;
import net.fortuna.ical4j.model.component.Participant;
import net.fortuna.ical4j.model.component.VAvailability;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VFreeBusy;
import net.fortuna.ical4j.model.component.VJournal;
import net.fortuna.ical4j.model.component.VPoll;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.parameter.AltRep;
import net.fortuna.ical4j.model.parameter.FbType;
import net.fortuna.ical4j.model.parameter.RelType;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.parameter.XParameter;
import net.fortuna.ical4j.model.property.AcceptResponse;
import net.fortuna.ical4j.model.property.Attach;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.BusyType;
import net.fortuna.ical4j.model.property.Categories;
import net.fortuna.ical4j.model.property.Clazz;
import net.fortuna.ical4j.model.property.Comment;
import net.fortuna.ical4j.model.property.Completed;
import net.fortuna.ical4j.model.property.Contact;
import net.fortuna.ical4j.model.property.Created;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Due;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.ExDate;
import net.fortuna.ical4j.model.property.ExRule;
import net.fortuna.ical4j.model.property.FreeBusy;
import net.fortuna.ical4j.model.property.Geo;
import net.fortuna.ical4j.model.property.LastModified;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.PercentComplete;
import net.fortuna.ical4j.model.property.PollMode;
import net.fortuna.ical4j.model.property.PollProperties;
import net.fortuna.ical4j.model.property.PollWinner;
import net.fortuna.ical4j.model.property.Priority;
import net.fortuna.ical4j.model.property.RDate;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.RecurrenceId;
import net.fortuna.ical4j.model.property.RelatedTo;
import net.fortuna.ical4j.model.property.Resources;
import net.fortuna.ical4j.model.property.Sequence;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Transp;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Url;
import org.bedework.calfacade.BwAttachment;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwContact;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwFreeBusyComponent;
import org.bedework.calfacade.BwGeo;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwLongString;
import org.bedework.calfacade.BwOrganizer;
import org.bedework.calfacade.BwRelatedTo;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.BwXproperty;
import org.bedework.calfacade.base.BwStringBase;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.convert.ical.IcalUtil;
import org.bedework.convert.ical.VAlarmUtil;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.misc.Util;

public class BwEvent2Ical
extends IcalUtil {
    private static final BwLogger logger = new BwLogger().setLoggedClass(BwEvent2Ical.class);

    public static Component convert(EventInfo ei, boolean isOverride, TimeZoneRegistry tzreg, String currentPrincipal) throws CalFacadeException {
        if (ei == null || ei.getEvent() == null) {
            return null;
        }
        BwEvent val = ei.getEvent();
        boolean isInstance = false;
        try {
            List xlocs;
            URI uri;
            String status;
            Integer prio;
            Integer pc;
            BwGeo bwgeo;
            List fbps;
            BwLongString bwstr;
            String pval;
            Attendee prop;
            VEvent comp;
            PropertyList pl = new PropertyList();
            boolean freeBusy = false;
            boolean vavail = false;
            boolean todo = false;
            boolean event = false;
            boolean vpoll = false;
            int entityType = val.getEntityType();
            if (entityType == 0) {
                comp = new VEvent(pl);
                event = true;
            } else if (entityType == 2) {
                comp = new VToDo(pl);
                todo = true;
            } else if (entityType == 3) {
                comp = new VJournal(pl);
            } else if (entityType == 4) {
                comp = new VFreeBusy(pl);
                freeBusy = true;
            } else if (entityType == 5) {
                comp = new VAvailability(pl);
                vavail = true;
            } else if (entityType == 6) {
                comp = new Available(pl);
            } else if (entityType == 7) {
                comp = new VPoll(pl);
                vpoll = true;
            } else {
                throw new CalFacadeException("org.bedework.invalid.entity.type", String.valueOf(entityType));
            }
            Component xcomp = IcalUtil.getXcomp(val, comp.getName());
            String strval = val.getRecurrenceId();
            if (strval != null && strval.length() > 0) {
                isInstance = true;
                BwEvent anEv = ei.getParent() == null || ei.getParent().getEvent() == null ? val : ei.getParent().getEvent();
                pl.add((Property)new RecurrenceId(BwEvent2Ical.makeZonedDt(anEv, strval)));
            }
            VAlarmUtil.processEventAlarm(val, (Component)comp, currentPrincipal);
            if (val.getNumAttachments() > 0) {
                for (BwAttachment att : val.getAttachments()) {
                    pl.add((Property)BwEvent2Ical.setAttachment(att));
                }
            }
            if (!vpoll && val.getNumAttendees() > 0) {
                for (BwAttachment att : val.getAttendees()) {
                    prop = BwEvent2Ical.setAttendee((BwAttendee)att);
                    BwEvent2Ical.mergeXparams((Property)prop, xcomp);
                    pl.add((Property)prop);
                }
            }
            if (val.getNumCategories() > 0) {
                for (Object cat : val.getCategories()) {
                    BwString catval = cat.getWord();
                    prop = new Categories();
                    TextList cl = ((Categories)prop).getCategories();
                    cl.add(catval.getValue());
                    pl.add(BwEvent2Ical.langProp((Property)prop, catval));
                }
            }
            if ((pval = val.getClassification()) != null) {
                pl.add((Property)new Clazz(pval));
            }
            if (val.getNumComments() > 0) {
                for (BwString str : val.getComments()) {
                    pl.add(BwEvent2Ical.langProp((Property)new Comment(str.getValue()), str));
                }
            }
            if ((todo || vpoll) && val.getCompleted() != null) {
                prop = new Completed(new DateTime(val.getCompleted()));
                pl.add((Property)prop);
            }
            if (val.getNumContacts() > 0) {
                for (BwContact c : val.getContacts()) {
                    prop = new Contact(c.getCn().getValue());
                    String l = c.getLink();
                    if (l != null) {
                        prop.getParameters().add((Parameter)new AltRep(l));
                    }
                    pl.add(BwEvent2Ical.langProp(BwEvent2Ical.uidProp((Property)prop, c.getUid()), c.getCn()));
                }
            }
            if (val.getCost() != null) {
                BwEvent2Ical.addXproperty((PropertyList<Property>)pl, "X-BEDEWORK-COST", null, val.getCost());
            }
            prop = new Created(val.getCreated());
            pl.add((Property)prop);
            if (val.getDeleted()) {
                BwEvent2Ical.addXproperty((PropertyList<Property>)pl, "X-BEDEWORK-DELETED", null, String.valueOf(val.getDeleted()));
            }
            if ((bwstr = val.findDescription(null)) != null) {
                pl.add(BwEvent2Ical.langProp((Property)new Description(bwstr.getValue()), bwstr));
            }
            if (val.getEndType() == 'E') {
                if (todo) {
                    Due due = IcalUtil.makeDue(val.getDtend(), tzreg);
                    if (freeBusy | val.getForceUTC()) {
                        due.setUtc(true);
                    }
                    pl.add((Property)due);
                } else {
                    DtEnd dtend = IcalUtil.makeDtEnd(val.getDtend(), tzreg);
                    if (freeBusy | val.getForceUTC()) {
                        dtend.setUtc(true);
                    }
                    pl.add((Property)dtend);
                }
            } else if (val.getEndType() == 'D') {
                BwEvent2Ical.addProperty((Component)comp, (Property)new Duration(new Dur(val.getDuration())));
            }
            prop = new DtStamp(new DateTime(val.getDtstamp()));
            pl.add((Property)prop);
            if (!val.getNoStart().booleanValue()) {
                DtStart dtstart = val.getDtstart().makeDtStart(tzreg);
                if (freeBusy | val.getForceUTC()) {
                    dtstart.setUtc(true);
                }
                pl.add((Property)dtstart);
            }
            if (freeBusy && (fbps = val.getFreeBusyPeriods()) != null) {
                for (BwFreeBusyComponent fbc : fbps) {
                    FreeBusy fb = new FreeBusy();
                    int type = fbc.getType();
                    if (type == 0) {
                        BwEvent2Ical.addParameter((Property)fb, (Parameter)FbType.BUSY);
                    } else if (type == 1) {
                        BwEvent2Ical.addParameter((Property)fb, (Parameter)FbType.FREE);
                    } else if (type == 2) {
                        BwEvent2Ical.addParameter((Property)fb, (Parameter)FbType.BUSY_UNAVAILABLE);
                    } else if (type == 3) {
                        BwEvent2Ical.addParameter((Property)fb, (Parameter)FbType.BUSY_TENTATIVE);
                    } else {
                        throw new CalFacadeException("Bad free-busy type " + type);
                    }
                    PeriodList pdl = fb.getPeriods();
                    for (Period p : fbc.getPeriods()) {
                        Period np = new Period(p.getStart(), p.getEnd());
                        pdl.add(np);
                    }
                    pl.add((Property)fb);
                }
            }
            if (!vpoll && (bwgeo = val.getGeo()) != null) {
                pl.add((Property)new Geo(bwgeo.getLatitude(), bwgeo.getLongitude()));
            }
            prop = new LastModified(new DateTime(val.getLastmod()));
            pl.add((Property)prop);
            BwEvent2Ical.doLocation(val, (PropertyList<Property>)pl, (Component)comp, vpoll);
            BwOrganizer org = val.getOrganizer();
            if (org != null) {
                prop = BwEvent2Ical.setOrganizer(org);
                BwEvent2Ical.mergeXparams((Property)prop, xcomp);
                pl.add((Property)prop);
            }
            if (todo && (pc = val.getPercentComplete()) != null) {
                pl.add((Property)new PercentComplete(pc.intValue()));
            }
            if ((prio = val.getPriority()) != null) {
                pl.add((Property)new Priority(prio.intValue()));
            }
            String[] info = null;
            BwRelatedTo relto = val.getRelatedTo();
            if (relto != null) {
                info = new String[]{relto.getRelType(), "", relto.getValue()};
            } else {
                String relx = val.getXproperty("X-BEDEWORK-RELATED-TO");
                if (relx != null) {
                    info = Util.decodeArray((String)relx);
                }
            }
            if (info != null) {
                for (int i = 0; i < info.length; i += 3) {
                    String reltype = info[i];
                    String valtype = info[i + 1];
                    String relval = info[i + 2];
                    ParameterList rtpl = null;
                    if (reltype != null && reltype.length() > 0) {
                        rtpl = new ParameterList();
                        rtpl.add((Parameter)new RelType(reltype));
                    }
                    if (valtype.length() > 0) {
                        if (rtpl == null) {
                            rtpl = new ParameterList();
                        }
                        rtpl.add((Parameter)new Value(valtype));
                    }
                    RelatedTo irelto = rtpl != null ? new RelatedTo(rtpl, relval) : new RelatedTo(relval);
                    pl.add((Property)irelto);
                }
            }
            if (val.getNumResources() > 0) {
                prop = new Resources();
                TextList rl = ((Resources)prop).getResources();
                for (Object str : val.getResources()) {
                    rl.add(str.getValue());
                }
                pl.add((Property)prop);
            }
            if (val.getSequence() > 0) {
                pl.add((Property)new Sequence(val.getSequence()));
            }
            if ((status = val.getStatus()) != null && !status.equals("MASTER-SUPPRESSED")) {
                pl.add((Property)new Status(status));
            }
            if ((bwstr = val.findSummary(null)) != null) {
                pl.add(BwEvent2Ical.langProp((Property)new Summary(bwstr.getValue()), bwstr));
            }
            if (!todo && !vpoll && (strval = val.getPeruserTransparency(currentPrincipal)) != null && strval.length() > 0) {
                pl.add((Property)new Transp(strval));
            }
            pl.add((Property)new Uid(val.getUid()));
            strval = val.getLink();
            if (strval != null) {
                strval = strval.trim();
            }
            if (strval != null && strval.length() > 0 && (uri = Util.validURI((String)strval)) != null) {
                pl.add((Property)new Url(uri));
            }
            if (val.getNumXproperties() > 0) {
                try {
                    BwEvent2Ical.xpropertiesToIcal((PropertyList<Property>)pl, val.getXproperties());
                }
                catch (Throwable t) {
                    logger.error(t);
                }
            }
            if (!vpoll && !isInstance && !isOverride && val.isRecurringEntity()) {
                BwEvent2Ical.doRecurring(val, (PropertyList<Property>)pl);
            }
            if (vavail) {
                String s;
                if (ei.getNumContainedItems() > 0) {
                    VAvailability va = (VAvailability)comp;
                    for (EventInfo aei : ei.getContainedItems()) {
                        va.getAvailable().add((Object)((Available)BwEvent2Ical.convert(aei, false, tzreg, currentPrincipal)));
                    }
                }
                if ((s = val.getBusyTypeString()) != null) {
                    pl.add((Property)new BusyType(s));
                }
            }
            if (!Util.isEmpty((Collection)(xlocs = val.getXproperties("X-BEDEWORK-LOCATION"))) && comp.getProperty("LOCATION") == null) {
                BwXproperty xloc = (BwXproperty)xlocs.get(0);
                Location loc = new Location(xloc.getValue());
                comp.getProperties().add((Property)loc);
            }
            if (vpoll) {
                Integer ival = val.getPollWinner();
                if (ival != null) {
                    pl.add((Property)new PollWinner(ival.intValue()));
                }
                if ((strval = val.getPollAcceptResponse()) != null && strval.length() > 0) {
                    pl.add((Property)new AcceptResponse(strval));
                }
                if ((strval = val.getPollMode()) != null && strval.length() > 0) {
                    pl.add((Property)new PollMode(strval));
                }
                if ((strval = val.getPollProperties()) != null && strval.length() > 0) {
                    pl.add((Property)new PollProperties(strval));
                }
                Map<String, Participant> voters = BwEvent2Ical.parseVpollVoters(val);
                for (Participant v : voters.values()) {
                    ((VPoll)comp).getComponents().add((Object)v);
                }
                Map<Integer, Component> comps = BwEvent2Ical.parseVpollCandidates(val);
                for (Component candidate : comps.values()) {
                    ((VPoll)comp).getComponents().add((Object)candidate);
                }
            }
            return comp;
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public static void doLocation(BwEvent val, PropertyList<Property> pl, Component comp, boolean vpoll) {
        BwLocation loc;
        if (!vpoll && (loc = val.getLocation()) != null) {
            Location prop = new Location(loc.getCombinedValues());
            pl.add(BwEvent2Ical.langProp(BwEvent2Ical.uidProp((Property)prop, loc.getUid()), loc.getAddress()));
            BwEvent2Ical.addXproperty(pl, "X-BEDEWORK-LOCATION-ADDR", null, loc.getAddressField());
            BwEvent2Ical.addXproperty(pl, "X-BEDEWORK-LOCATION-ROOM", null, loc.getRoomField());
            BwEvent2Ical.addXproperty(pl, "X-BEDEWORK-LOCATION-ACCESSIBLE", null, String.valueOf(loc.getAccessible()));
            BwEvent2Ical.addXproperty(pl, "X-BEDEWORK-LOCATION-SFIELD1", null, loc.getSubField1());
            BwEvent2Ical.addXproperty(pl, "X-BEDEWORK-LOCATION-SFIELD2", null, loc.getSubField2());
            BwEvent2Ical.addXproperty(pl, "X-BEDEWORK-LOCATION-GEO", null, loc.getGeouri());
            BwEvent2Ical.addXproperty(pl, "X-BEDEWORK-LOCATION-STREET", null, loc.getStreet());
            BwEvent2Ical.addXproperty(pl, "X-BEDEWORK-LOCATION-CITY", null, loc.getCity());
            BwEvent2Ical.addXproperty(pl, "X-BEDEWORK-LOCATION-STATE", null, loc.getState());
            BwEvent2Ical.addXproperty(pl, "X-BEDEWORK-LOCATION-ZIP", null, loc.getZip());
            BwEvent2Ical.addXproperty(pl, "X-BEDEWORK-LOCATION-LINK", null, loc.getLink());
        }
    }

    public static void doRecurring(BwEvent val, PropertyList<Property> pl) {
        try {
            RRule rule;
            if (val.hasRrules()) {
                for (String s : val.getRrules()) {
                    rule = new RRule();
                    rule.setValue(s);
                    pl.add((Property)rule);
                }
            }
            if (val.hasExrules()) {
                for (String s : val.getExrules()) {
                    rule = new ExRule();
                    rule.setValue(s);
                    pl.add((Property)rule);
                }
            }
            BwEvent2Ical.makeDlp(val, false, val.getRdates(), pl);
            BwEvent2Ical.makeDlp(val, true, val.getExdates(), pl);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
    }

    private static void mergeXparams(Property p, Component c) {
        Value v;
        if (c == null) {
            return;
        }
        PropertyList pl = c.getProperties(p.getName());
        if (Util.isEmpty((Collection)pl)) {
            return;
        }
        String pval = p.getValue();
        if (p instanceof Attach && (v = (Value)p.getParameter("VALUE")) != null) {
            pval = String.valueOf(pval.hashCode());
        }
        Property from = null;
        if (pl.size() == 1) {
            from = (Property)pl.get(0);
        } else {
            Object aPl;
            Iterator iterator = pl.iterator();
            while (iterator.hasNext() && !(from = (Property)(aPl = iterator.next())).getValue().equals(pval)) {
            }
        }
        if (from == null) {
            return;
        }
        ParameterList params = from.getParameters();
        for (Parameter param : params) {
            XParameter xpar;
            if (!(param instanceof XParameter) || (xpar = (XParameter)param).getName().equalsIgnoreCase("X-BEDEWORK-UID")) continue;
            p.getParameters().add((Parameter)xpar);
        }
    }

    private static Property uidProp(Property prop, String uid) {
        XParameter par = new XParameter("X-BEDEWORK-UID", uid);
        prop.getParameters().add((Parameter)par);
        return prop;
    }

    private static Property langProp(Property prop, BwStringBase<?> s) {
        Parameter par = s.getLangPar();
        if (par != null) {
            prop.getParameters().add(par);
        }
        return prop;
    }

    private static void makeDlp(BwEvent val, boolean exdt, Collection<BwDateTime> dts, PropertyList<Property> pl) throws ParseException {
        BwDateTime dtstart;
        if (dts == null || dts.isEmpty()) {
            return;
        }
        TimeZone tz = null;
        if (!val.getForceUTC() && (dtstart = val.getDtstart()) != null && !dtstart.isUTC()) {
            DtStart ds = dtstart.makeDtStart();
            tz = ds.getTimeZone();
        }
        for (BwDateTime dt : dts) {
            DateList dl;
            boolean dateType = false;
            if (dt.getDateType()) {
                dl = new DateList(Value.DATE);
                dl.setUtc(true);
                dateType = true;
                dl.add(new Date(dt.getDtval()));
            } else {
                dl = new DateList(Value.DATE_TIME);
                if (tz == null) {
                    dl.setUtc(true);
                    dtm = new DateTime(dt.getDate());
                    dtm.setUtc(true);
                    dl.add((Date)dtm);
                } else {
                    dl.setTimeZone(tz);
                    dtm = new DateTime(dt.getDate());
                    dtm.setTimeZone(tz);
                    dl.add((Date)dtm);
                }
            }
            Object dlp = exdt ? new ExDate(dl) : new RDate(dl);
            if (dateType) {
                dlp.getParameters().add((Parameter)Value.DATE);
            } else if (tz != null) {
                dlp.setTimeZone(tz);
            }
            pl.add((Property)dlp);
        }
    }

    private static Date makeZonedDt(BwEvent val, String dtval) throws Throwable {
        BwDateTime dtstart = val.getDtstart();
        DateTime dt = new DateTime(dtval);
        if (dtstart.getDateType()) {
            if (dtval.length() > 8) {
                dt.setTimeZone(null);
                return new Date(dt.toString().substring(0, 8));
            }
            return dt;
        }
        if (val.getForceUTC()) {
            return dt;
        }
        if (!dtstart.isUTC()) {
            DtStart ds = dtstart.makeDtStart();
            dt.setTimeZone(ds.getTimeZone());
        }
        return dt;
    }
}

