/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.convert.jcal;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentContainer;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Version;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwVersion;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.convert.EventTimeZonesRegistry;
import org.bedework.convert.ical.BwEvent2Ical;
import org.bedework.convert.ical.VFreeUtil;
import org.bedework.convert.jcal.JsonProperty;
import org.bedework.util.calendar.ScheduleMethods;
import org.bedework.util.logging.BwLogger;

public class JcalHandler
implements Serializable {
    private static final BwLogger logger = new BwLogger().setLoggedClass(JcalHandler.class);
    private static final JsonFactory jsonFactory = new JsonFactory();

    public static String toJcal(Collection<EventInfo> vals, int methodType, String currentPrincipal, EventTimeZonesRegistry tzreg) throws CalFacadeException {
        StringWriter sw = new StringWriter();
        JcalHandler.outJcal(sw, vals, methodType, currentPrincipal, tzreg);
        return sw.toString();
    }

    public static String toJcal(Calendar cal) throws CalFacadeException {
        StringWriter sw = new StringWriter();
        JcalHandler.outJcal(sw, cal);
        return sw.toString();
    }

    public static void outJcal(Writer wtr, Calendar cal) throws CalFacadeException {
        try {
            JsonGenerator jgen = jsonFactory.createGenerator(wtr);
            if (logger.debug()) {
                jgen.useDefaultPrettyPrinter();
            }
            jgen.writeStartArray();
            jgen.writeString("vcalendar");
            jgen.writeStartArray();
            for (Property p : cal.getProperties()) {
                JsonProperty.addFields(jgen, p);
            }
            jgen.writeEndArray();
            jgen.writeStartArray();
            for (Component comp : cal.getComponents()) {
                JcalHandler.outComp(jgen, comp);
            }
            jgen.writeEndArray();
            jgen.writeEndArray();
            jgen.flush();
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public static void outJcal(Writer wtr, Collection<EventInfo> vals, int methodType, String currentPrincipal, EventTimeZonesRegistry tzreg) throws CalFacadeException {
        try {
            JsonGenerator jgen = jsonFactory.createGenerator(wtr);
            if (logger.debug()) {
                jgen.useDefaultPrettyPrinter();
            }
            jgen.writeStartArray();
            JcalHandler.calendarProps(jgen, methodType);
            jgen.writeStartArray();
            for (EventInfo ei : vals) {
                BwEvent ev = ei.getEvent();
                Object comp = ev.getEntityType() == 4 ? VFreeUtil.toVFreeBusy(ev) : BwEvent2Ical.convert(ei, false, tzreg, currentPrincipal);
                JcalHandler.outComp(jgen, (Component)comp);
                if (ei.getNumOverrides() <= 0) continue;
                for (EventInfo oei : ei.getOverrides()) {
                    JcalHandler.outComp(jgen, BwEvent2Ical.convert(oei, true, tzreg, currentPrincipal));
                }
            }
            jgen.writeEndArray();
            jgen.writeEndArray();
            jgen.flush();
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    private static void outComp(JsonGenerator jgen, Component comp) throws CalFacadeException {
        try {
            ComponentList cl;
            jgen.writeStartArray();
            jgen.writeString(comp.getName().toLowerCase());
            jgen.writeStartArray();
            for (Property p : comp.getProperties()) {
                JsonProperty.addFields(jgen, p);
            }
            jgen.writeEndArray();
            jgen.writeStartArray();
            if (comp instanceof ComponentContainer && (cl = ((ComponentContainer)comp).getComponents()) != null) {
                for (Component c : cl) {
                    JcalHandler.outComp(jgen, c);
                }
            }
            jgen.writeEndArray();
            jgen.writeEndArray();
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    private static void calendarProps(JsonGenerator jgen, int methodType) throws CalFacadeException {
        try {
            jgen.writeString("vcalendar");
            jgen.writeStartArray();
            JsonProperty.addFields(jgen, (Property)new ProdId(BwVersion.prodId));
            JsonProperty.addFields(jgen, (Property)Version.VERSION_2_0);
            if (methodType > 0 && methodType < 99) {
                JsonProperty.addFields(jgen, (Property)new Method(ScheduleMethods.methods[methodType]));
            }
            jgen.writeEndArray();
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    static {
        jsonFactory.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        jsonFactory.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    }
}

