/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.convert.jcal;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import net.fortuna.ical4j.model.Calendar;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.ifs.IcalCallback;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.convert.EventTimeZonesRegistry;
import org.bedework.convert.IcalTranslator;
import org.bedework.convert.jcal.JcalHandler;

public class JcalTranslator
extends IcalTranslator {
    public JcalTranslator(IcalCallback cb) {
        super(cb);
    }

    public String toJcal(EventInfo val, int methodType) throws CalFacadeException {
        String currentPrincipal = null;
        BwPrincipal principal = this.cb.getPrincipal();
        if (principal != null) {
            currentPrincipal = principal.getPrincipalRef();
        }
        ArrayList<EventInfo> eis = new ArrayList<EventInfo>();
        eis.add(val);
        return JcalHandler.toJcal(eis, methodType, currentPrincipal, new EventTimeZonesRegistry(this, val.getEvent()));
    }

    public static String toJcal(Calendar val) throws CalFacadeException {
        return JcalHandler.toJcal(val);
    }

    public void writeJcal(Collection<EventInfo> vals, int methodType, Writer wtr) throws CalFacadeException {
        String currentPrincipal = null;
        BwPrincipal principal = this.cb.getPrincipal();
        if (principal != null) {
            currentPrincipal = principal.getPrincipalRef();
        }
        JcalHandler.outJcal(wtr, vals, methodType, currentPrincipal, new EventTimeZonesRegistry(this, null));
    }
}

